package de.rhocas.featuregen.generator;

import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * This is a helper class to use consistent names between the generators.
 * 
 * @author Nils Christian Ehmke
 */
@SuppressWarnings("all")
final class NameProvider {
  public String getSimpleFeaturesEnumName(final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(rootFeatureName);
    _builder.append("Feature");
    return _builder.toString();
  }
  
  public String getSimpleFeatureCheckServiceClassName(final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(rootFeatureName);
    _builder.append("FeatureCheckService");
    return _builder.toString();
  }
  
  public String getSimpleSelectedFeaturesAnnotationName(final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(rootFeatureName);
    _builder.append("SelectedFeatures");
    return _builder.toString();
  }
  
  public String getSimpleVariantInterfaceName(final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(rootFeatureName);
    _builder.append("Variant");
    return _builder.toString();
  }
}
