package de.rhocas.featuregen.generator;

import com.google.common.base.Objects;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * This is a helper class for the generators.
 * 
 * @author Nils Christian Ehmke
 */
@SuppressWarnings("all")
final class GeneratorHelper {
  public void writeContentToFileIfChanged(final String newFileContent, final File outputFile) {
    try {
      String _xifexpression = null;
      boolean _isFile = outputFile.isFile();
      if (_isFile) {
        byte[] _readAllBytes = Files.readAllBytes(outputFile.toPath());
        _xifexpression = new String(_readAllBytes, StandardCharsets.UTF_8);
      } else {
        _xifexpression = "";
      }
      final String oldFileContent = _xifexpression;
      boolean _notEquals = (!Objects.equal(oldFileContent, newFileContent));
      if (_notEquals) {
        Files.write(outputFile.toPath(), newFileContent.getBytes(StandardCharsets.UTF_8));
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
