package de.rhocas.featuregen.generator;

/**
 * This is a helper class to convert the names of the features to valid Java identifiers.
 * 
 * @author Nils Christian Ehmke
 */
@SuppressWarnings("all")
final class FeatureNameConverter {
  public String convertToValidSimpleFeatureName(final String rawFeatureName, final String prefix, final String suffix) {
    String _xblockexpression = null;
    {
      String _replaceAll = rawFeatureName.replaceAll("\\s", "_").replaceAll("(\\W)", "");
      String _plus = (prefix + _replaceAll);
      final String simpleFeatureName = (_plus + suffix);
      _xblockexpression = simpleFeatureName.toUpperCase();
    }
    return _xblockexpression;
  }
}
