/*
 * Decompiled with CFR 0.152.
 */
package de.rhocas.featuregen.ap;

import com.google.common.base.Objects;
import de.rhocas.featuregen.ap.FeatureIDEFeatures;
import de.rhocas.featuregen.ap.FeatureIDEVariant;
import de.rhocas.featuregen.ap.FeatureNameConverter;
import de.rhocas.featuregen.ap.NameProvider;
import de.rhocas.featuregen.featureide.model.configuration.Configuration;
import de.rhocas.featuregen.featureide.model.configuration.Feature;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.file.FileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public final class FeatureIDEVariantProcessor
extends AbstractClassProcessor {
    @Extension
    private final NameProvider _nameProvider = new NameProvider();
    @Extension
    private final FeatureNameConverter _featureNameConverter = new FeatureNameConverter();
    private final JAXBContext jaxbContext = new Functions.Function0<JAXBContext>(){

        public JAXBContext apply() {
            try {
                JAXBContext _newInstance = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
                return _newInstance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        this.addPrivateConstructor(annotatedClass);
        this.makeFinal(annotatedClass);
        Configuration configurationModel = this.getConfigurationModel((ClassDeclaration)annotatedClass, context);
        if (configurationModel != null && this.featuresAnnotationCanBeFound(annotatedClass, context)) {
            this.addSelectedFeaturesAnnotation(configurationModel, annotatedClass, context);
            this.addVariantInterface(configurationModel, annotatedClass, context);
        }
    }

    public MutableConstructorDeclaration addPrivateConstructor(MutableClassDeclaration annotatedClass) {
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PRIVATE);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                }
            };
            it.setBody(_client);
        };
        return annotatedClass.addConstructor(_function);
    }

    public boolean featuresAnnotationCanBeFound(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type _annotatedFeaturesClass = this.getAnnotatedFeaturesClass((ClassDeclaration)annotatedClass, context);
        ClassDeclaration featuresClass = (ClassDeclaration)_annotatedFeaturesClass;
        AnnotationReference annotationReference = featuresClass.findAnnotation(context.findTypeGlobally(FeatureIDEFeatures.class));
        if (annotationReference != null) {
            return true;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The referenced class ");
        String _simpleName = featuresClass.getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" must be annotated with ");
        String _simpleName_1 = FeatureIDEFeatures.class.getSimpleName();
        _builder.append(_simpleName_1);
        _builder.append(".");
        context.addError((Element)annotatedClass, _builder.toString());
        return false;
    }

    private void makeFinal(MutableClassDeclaration annotatedClass) {
        annotatedClass.setFinal(true);
    }

    private void addVariantInterface(Configuration configurationModel, MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type variantInterface = this.getVariantInterface(configurationModel, annotatedClass, context);
        TypeReference _newSelfTypeReference = context.newSelfTypeReference(variantInterface);
        annotatedClass.setImplementedInterfaces(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newSelfTypeReference})));
    }

    private Type getVariantInterface(Configuration configurationModel, MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type _xblockexpression = null;
        String fullQualifiedName = this.getFullQualifiedVariantName(configurationModel, annotatedClass, context);
        _xblockexpression = context.findTypeGlobally(fullQualifiedName);
        return _xblockexpression;
    }

    private String getFullQualifiedVariantName(Configuration configurationModel, MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        String _xblockexpression = null;
        Type annotatedFeaturesClass = this.getAnnotatedFeaturesClass((ClassDeclaration)annotatedClass, context);
        Feature root = this.getRoot(configurationModel);
        _xblockexpression = this._nameProvider.getFullQualifiedVariantInterfaceName(annotatedFeaturesClass, root.getName());
        return _xblockexpression;
    }

    private void addSelectedFeaturesAnnotation(Configuration configurationModel, MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type selectedFeaturesAnnotation = this.getSelectedFeaturesAnnotation(configurationModel, annotatedClass, context);
        Procedures.Procedure1 _function = it -> it.setEnumValue("value", (EnumerationValueDeclaration[])Conversions.unwrapArray(this.getSelectedFeatures(configurationModel, (ClassDeclaration)annotatedClass, context), EnumerationValueDeclaration.class));
        annotatedClass.addAnnotation(context.newAnnotationReference(selectedFeaturesAnnotation, _function));
    }

    private Type getSelectedFeaturesAnnotation(Configuration configurationModel, MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type _xblockexpression = null;
        String fullQualifiedName = this.getFullQualifiedSelectedFeaturesAnnotationName(configurationModel, annotatedClass, context);
        _xblockexpression = context.findTypeGlobally(fullQualifiedName);
        return _xblockexpression;
    }

    private String getFullQualifiedSelectedFeaturesAnnotationName(Configuration configurationModel, MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        String _xblockexpression = null;
        Type annotatedFeaturesClass = this.getAnnotatedFeaturesClass((ClassDeclaration)annotatedClass, context);
        Feature root = this.getRoot(configurationModel);
        _xblockexpression = this._nameProvider.getFullQualifiedSelectedFeaturesAnnotationName(annotatedFeaturesClass, root.getName());
        return _xblockexpression;
    }

    private Type getAnnotatedFeaturesClass(ClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type _xblockexpression = null;
        AnnotationReference annotationReference = annotatedClass.findAnnotation(context.findTypeGlobally(FeatureIDEVariant.class));
        _xblockexpression = annotationReference.getClassValue("featuresClass").getType();
        return _xblockexpression;
    }

    private Feature getRoot(Configuration configurationModel) {
        Feature _xblockexpression = null;
        List features = configurationModel.getFeature();
        _xblockexpression = (Feature)IterableExtensions.head((Iterable)features);
        return _xblockexpression;
    }

    private Configuration getConfigurationModel(ClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Configuration _xblockexpression = null;
        Path modelFilePath = this.getModelFilePath(annotatedClass, context);
        Configuration _xifexpression = null;
        boolean _isFile = context.isFile(modelFilePath);
        if (_isFile) {
            _xifexpression = this.readConfigurationModel(modelFilePath, (FileSystemSupport)context);
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The configuration file could not be found (Assumed path was: '");
            _builder.append((Object)modelFilePath);
            _builder.append("').");
            context.addError((Element)annotatedClass, _builder.toString());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Path getModelFilePath(ClassDeclaration annotatedClass, @Extension TransformationContext context) {
        AnnotationReference annotationReference = annotatedClass.findAnnotation(context.findTypeGlobally(FeatureIDEVariant.class));
        String value = annotationReference.getStringValue("value");
        boolean _equals = Objects.equal((Object)value, (Object)"");
        if (_equals) {
            String _plus;
            String _simpleName = annotatedClass.getSimpleName();
            value = _plus = _simpleName + ".xml";
        }
        Path path = null;
        boolean _startsWith = value.startsWith("/");
        path = _startsWith ? context.getProjectFolder(annotatedClass.getCompilationUnit().getFilePath()) : annotatedClass.getCompilationUnit().getFilePath().getParent();
        return path.append("/").append(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration readConfigurationModel(Path modelFilePath, @Extension FileSystemSupport fileSystemSupport) {
        Configuration configuration;
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        InputStream stream = fileSystemSupport.getContentsAsStream(modelFilePath);
        try {
            Object _unmarshal = unmarshaller.unmarshal(stream);
            configuration = (Configuration)_unmarshal;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        stream.close();
        return configuration;
    }

    private Iterable<EnumerationValueDeclaration> getSelectedFeatures(Configuration configurationModel, ClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Iterable _xblockexpression = null;
        EnumerationTypeDeclaration featureEnum = this.getFeatureEnum(configurationModel, annotatedClass, context);
        List features = configurationModel.getFeature();
        Type _annotatedFeaturesClass = this.getAnnotatedFeaturesClass(annotatedClass, context);
        ClassDeclaration featuresClass = (ClassDeclaration)_annotatedFeaturesClass;
        AnnotationReference annotationReference = featuresClass.findAnnotation(context.findTypeGlobally(FeatureIDEFeatures.class));
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> this._featureNameConverter.convertToValidSimpleFeatureName((String)it, annotationReference);
        Functions.Function1 _function_2 = it -> featureEnum.findDeclaredValue(it);
        _xblockexpression = IterableExtensions.filterNull((Iterable)ListExtensions.map((List)ListExtensions.map((List)ListExtensions.map((List)features, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        return _xblockexpression;
    }

    private EnumerationTypeDeclaration getFeatureEnum(Configuration configurationModel, ClassDeclaration annotatedClass, @Extension TransformationContext context) {
        EnumerationTypeDeclaration _xblockexpression = null;
        String fullQualifiedName = this.getFullQualifiedFeatureEnumName(configurationModel, annotatedClass, context);
        Type _findTypeGlobally = context.findTypeGlobally(fullQualifiedName);
        _xblockexpression = (EnumerationTypeDeclaration)_findTypeGlobally;
        return _xblockexpression;
    }

    private String getFullQualifiedFeatureEnumName(Configuration configurationModel, ClassDeclaration annotatedClass, @Extension TransformationContext context) {
        String _xblockexpression = null;
        Type annotatedFeaturesClass = this.getAnnotatedFeaturesClass(annotatedClass, context);
        Feature root = this.getRoot(configurationModel);
        _xblockexpression = this._nameProvider.getFullQualifiedFeaturesEnumName(annotatedFeaturesClass, root.getName());
        return _xblockexpression;
    }
}

