/*
 * Decompiled with CFR 0.152.
 */
package de.rhocas.featuregen.ap;

import de.rhocas.featuregen.ap.FeatureIDEFeatures;
import de.rhocas.featuregen.ap.FeatureNameConverter;
import de.rhocas.featuregen.ap.NameProvider;
import de.rhocas.featuregen.featureide.model.feature.BranchedFeatureType;
import de.rhocas.featuregen.featureide.model.feature.FeatureModel;
import de.rhocas.featuregen.featureide.model.feature.FeatureModelType;
import de.rhocas.featuregen.featureide.model.feature.FeatureType;
import de.rhocas.featuregen.featureide.model.feature.StructType;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeElementDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.FileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public final class FeatureIDEFeaturesProcessor
extends AbstractClassProcessor {
    @Extension
    private final NameProvider _nameProvider = new NameProvider();
    @Extension
    private final FeatureNameConverter _featureNameConverter = new FeatureNameConverter();
    private final JAXBContext jaxbContext = new Functions.Function0<JAXBContext>(){

        public JAXBContext apply() {
            try {
                JAXBContext _newInstance = JAXBContext.newInstance((Class[])new Class[]{FeatureModel.class});
                return _newInstance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();

    public void doRegisterGlobals(ClassDeclaration annotatedClass, @Extension RegisterGlobalsContext context) {
        AnnotationReference annotationReference = annotatedClass.findAnnotation(context.findUpstreamType(FeatureIDEFeatures.class));
        Path modelFilePath = this.findModelFilePath(annotatedClass, annotationReference, (FileLocations)context);
        boolean _isFile = context.isFile(modelFilePath);
        if (_isFile) {
            FeatureModelType featureModel = this.readFeatureModel(modelFilePath, (FileSystemSupport)context);
            this.registerFeatureCheckService(annotatedClass, featureModel, context);
            this.registerSelectedFeatures(annotatedClass, featureModel, context);
            this.registerFeature(annotatedClass, featureModel, context);
            this.registerVariant(annotatedClass, featureModel, context);
        }
    }

    private Path findModelFilePath(ClassDeclaration annotatedClass, AnnotationReference annotationReference, @Extension FileLocations context) {
        String value = annotationReference.getStringValue("value");
        boolean _equals = com.google.common.base.Objects.equal((Object)value, (Object)"");
        if (_equals) {
            value = "model.xml";
        }
        Path path = null;
        boolean _startsWith = value.startsWith("/");
        path = _startsWith ? context.getProjectFolder(annotatedClass.getCompilationUnit().getFilePath()) : annotatedClass.getCompilationUnit().getFilePath().getParent();
        return path.append("/").append(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureModelType readFeatureModel(Path modelFilePath, @Extension FileSystemSupport fileSystemSupport) {
        FeatureModelType featureModelType;
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        InputStream stream = fileSystemSupport.getContentsAsStream(modelFilePath);
        try {
            Object _unmarshal = unmarshaller.unmarshal(stream);
            featureModelType = (FeatureModelType)_unmarshal;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        stream.close();
        return featureModelType;
    }

    private void registerFeatureCheckService(ClassDeclaration annotatedClass, FeatureModelType featureModel, @Extension RegisterGlobalsContext context) {
        FeatureType root = this.getRoot(featureModel);
        if (root != null) {
            context.registerClass(this._nameProvider.getFullQualifiedFeatureCheckServiceClassName((Type)annotatedClass, root.getName()));
        }
    }

    private FeatureType getRoot(FeatureModelType model) {
        boolean _tripleNotEquals;
        FeatureType _xblockexpression = null;
        StructType struct = model.getStruct();
        FeatureType _xifexpression = null;
        FeatureType _feature = struct.getFeature();
        boolean bl = _tripleNotEquals = _feature != null;
        if (_tripleNotEquals) {
            _xifexpression = struct.getFeature();
        } else {
            boolean _tripleNotEquals_1;
            BranchedFeatureType _xifexpression_1 = null;
            BranchedFeatureType _and = struct.getAnd();
            boolean bl2 = _tripleNotEquals_1 = _and != null;
            if (_tripleNotEquals_1) {
                _xifexpression_1 = struct.getAnd();
            } else {
                BranchedFeatureType _xifexpression_2 = null;
                BranchedFeatureType _or = struct.getOr();
                boolean _tripleNotEquals_2 = _or != null;
                _xifexpression_2 = _tripleNotEquals_2 ? struct.getOr() : struct.getAlt();
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private void registerSelectedFeatures(ClassDeclaration annotatedClass, FeatureModelType featureModel, @Extension RegisterGlobalsContext context) {
        FeatureType root = this.getRoot(featureModel);
        if (root != null) {
            context.registerAnnotationType(this._nameProvider.getFullQualifiedSelectedFeaturesAnnotationName((Type)annotatedClass, root.getName()));
        }
    }

    private void registerFeature(ClassDeclaration annotatedClass, FeatureModelType featureModel, @Extension RegisterGlobalsContext context) {
        FeatureType root = this.getRoot(featureModel);
        if (root != null) {
            context.registerEnumerationType(this._nameProvider.getFullQualifiedFeaturesEnumName((Type)annotatedClass, root.getName()));
        }
    }

    private void registerVariant(ClassDeclaration annotatedClass, FeatureModelType featureModel, @Extension RegisterGlobalsContext context) {
        FeatureType root = this.getRoot(featureModel);
        if (root != null) {
            context.registerInterface(this.getVariantName(annotatedClass, root));
        }
    }

    private String getVariantName(ClassDeclaration annotatedClass, FeatureType root) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = annotatedClass.getCompilationUnit().getPackageName();
        _builder.append(_packageName);
        _builder.append(".");
        String _name = root.getName();
        _builder.append(_name);
        _builder.append("Variant");
        return _builder.toString();
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        this.makeFinal(annotatedClass);
        AnnotationReference annotationReference = annotatedClass.findAnnotation(context.findTypeGlobally(FeatureIDEFeatures.class));
        Path modelFilePath = this.findModelFilePath((ClassDeclaration)annotatedClass, annotationReference, (FileLocations)context);
        boolean _isFile = context.isFile(modelFilePath);
        if (_isFile) {
            FeatureModelType featureModel = this.readFeatureModel(modelFilePath, (FileSystemSupport)context);
            this.transformFeature(annotatedClass, featureModel, context);
            this.transformSelectedFeatures(annotatedClass, featureModel, context);
            this.transformVariant(annotatedClass, featureModel, context);
            this.transformFeatureCheckService(annotatedClass, featureModel, context);
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The model file could not be found (Assumed path was: '");
            _builder.append((Object)modelFilePath);
            _builder.append("').");
            context.addError((Element)annotatedClass, _builder.toString());
        }
    }

    private void makeFinal(MutableClassDeclaration annotatedClass) {
        annotatedClass.setFinal(true);
    }

    private MutableMethodDeclaration transformFeatureCheckService(MutableClassDeclaration annotatedClass, FeatureModelType featureModel, final @Extension TransformationContext context) {
        MutableMethodDeclaration _xblockexpression = null;
        FeatureType root = this.getRoot(featureModel);
        final MutableClassDeclaration featureCheckService = context.findClass(this._nameProvider.getFullQualifiedFeatureCheckServiceClassName((Type)annotatedClass, root.getName()));
        final MutableEnumerationTypeDeclaration featureEnum = context.findEnumerationType(this._nameProvider.getFullQualifiedFeaturesEnumName((Type)annotatedClass, root.getName()));
        featureCheckService.setFinal(true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This service allows to check which features are currently active.<br/>");
        _builder.newLine();
        _builder.append("<br/>");
        _builder.newLine();
        _builder.append("Note that instances of this class are immutable and thus inherent thread safe.<br/>");
        _builder.newLine();
        _builder.append("<br/>");
        _builder.newLine();
        _builder.append("This service is generated.");
        _builder.newLine();
        featureCheckService.setDocComment(_builder.toString());
        Procedures.Procedure1 _function = it -> {
            it.setFinal(true);
            it.setType(context.newTypeReference(Set.class, new TypeReference[0]));
        };
        featureCheckService.addField("activeFeatures", _function);
        Procedures.Procedure1 _function_1 = it -> {
            it.setFinal(true);
            it.setType(context.newTypeReference(String.class, new TypeReference[0]));
        };
        featureCheckService.addField("description", _function_1);
        Procedures.Procedure1 _function_2 = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.addParameter("selectedFeatures", context.newTypeReference(List.class, new TypeReference[]{context.newSelfTypeReference((Type)featureEnum)}));
            it.addParameter("variantName", context.newTypeReference(String.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"activeFeatures = ");
                    TypeReference _newTypeReference = context.newTypeReference(EnumSet.class, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference);
                    _builder.append((Object)".noneOf( ");
                    TypeReference _newTypeReference_1 = context.newTypeReference((Type)featureEnum, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference_1);
                    _builder.append((Object)".class );");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"activeFeatures.addAll( selectedFeatures );");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"description = \"");
                    String _simpleName = featureCheckService.getSimpleName();
                    _builder.append((Object)_simpleName);
                    _builder.append((Object)" [\" + variantName + \"]\";");
                    _builder.newLineIfNotEmpty();
                }
            };
            it.setBody(_client);
        };
        featureCheckService.addConstructor(_function_2);
        Procedures.Procedure1 _function_3 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Checks whether the given feature is currently active or not.");
            _builder_1.newLine();
            _builder_1.newLine();
            _builder_1.append("@param feature");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("The feature to check. Must not be {@code null}.");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("@return true if and only if the given feature is active.");
            _builder_1.newLine();
            _builder_1.newLine();
            _builder_1.append("@throws NullPointerException");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("If the given feature is {@code null}.");
            _builder_1.newLine();
            it.setDocComment(_builder_1.toString());
            it.addParameter("feature", context.newTypeReference(context.findTypeGlobally(this._nameProvider.getFullQualifiedFeaturesEnumName((Type)annotatedClass, root.getName())), new TypeReference[0]));
            it.setReturnType(context.getPrimitiveBoolean());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    TypeReference _newTypeReference = context.newTypeReference(Objects.class, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference);
                    _builder.append((Object)".requireNonNull( feature, \"The feature must not be null.\" );");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"return activeFeatures.contains( feature );");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        featureCheckService.addMethod("isFeatureActive", _function_3);
        Procedures.Procedure1 _function_4 = it -> {
            it.addAnnotation(context.newAnnotationReference(Override.class));
            it.setReturnType(context.newTypeReference(String.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return description;");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        featureCheckService.addMethod("toString", _function_4);
        MutableInterfaceDeclaration variant = context.findInterface(this.getVariantName((ClassDeclaration)annotatedClass, root));
        final MutableAnnotationTypeDeclaration selectedFeaturesAnnotation = context.findAnnotationType(this._nameProvider.getFullQualifiedSelectedFeaturesAnnotationName((Type)annotatedClass, root.getName()));
        Procedures.Procedure1 _function_5 = it -> {
            it.setReturnType(context.newSelfTypeReference((Type)featureCheckService));
            it.setStatic(true);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Creates a new instance of this service with the features of the given variant.");
            _builder_1.newLine();
            _builder_1.newLine();
            _builder_1.append("@param variant");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("The new variant. Must not be {@code null} and must be annotated with {@link ");
            TypeReference _newTypeReference = context.newTypeReference((Type)selectedFeaturesAnnotation, new TypeReference[0]);
            _builder_1.append((Object)_newTypeReference, "\t");
            _builder_1.append("}.");
            _builder_1.newLineIfNotEmpty();
            _builder_1.newLine();
            _builder_1.append("@return A new feature check service.");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("@throws NullPointerException");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("If the given variant is {@code null} or not annotated with {@link ");
            TypeReference _newTypeReference_1 = context.newTypeReference((Type)selectedFeaturesAnnotation, new TypeReference[0]);
            _builder_1.append((Object)_newTypeReference_1, "\t");
            _builder_1.append("}.");
            _builder_1.newLineIfNotEmpty();
            it.setDocComment(_builder_1.toString());
            it.addParameter("variant", context.newTypeReference(Class.class, new TypeReference[]{context.newWildcardTypeReference(context.newSelfTypeReference((Type)variant))}));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    TypeReference _newTypeReference = context.newTypeReference(Objects.class, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference);
                    _builder.append((Object)".requireNonNull( variant, \"The variant must not be null.\" );");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"final ");
                    TypeReference _newTypeReference_1 = context.newTypeReference((Type)selectedFeaturesAnnotation, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference_1);
                    _builder.append((Object)" selectedFeaturesAnnotation = variant.getAnnotation( ");
                    TypeReference _newTypeReference_2 = context.newTypeReference((Type)selectedFeaturesAnnotation, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference_2);
                    _builder.append((Object)".class );");
                    _builder.newLineIfNotEmpty();
                    TypeReference _newTypeReference_3 = context.newTypeReference(Objects.class, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference_3);
                    _builder.append((Object)".requireNonNull( selectedFeaturesAnnotation, \"The variant must be annotated with ");
                    String _simpleName = selectedFeaturesAnnotation.getSimpleName();
                    _builder.append((Object)_simpleName);
                    _builder.append((Object)".\" );");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"final ");
                    TypeReference _newTypeReference_4 = context.newTypeReference(List.class, new TypeReference[]{context.newSelfTypeReference((Type)featureEnum)});
                    _builder.append((Object)_newTypeReference_4);
                    _builder.append((Object)" selectedFeatures = ");
                    TypeReference _newTypeReference_5 = context.newTypeReference(Arrays.class, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference_5);
                    _builder.append((Object)".asList( selectedFeaturesAnnotation.value( ) );");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"return new ");
                    TypeReference _newSelfTypeReference = context.newSelfTypeReference((Type)featureCheckService);
                    _builder.append((Object)_newSelfTypeReference);
                    _builder.append((Object)"( selectedFeatures, variant.getSimpleName( ) );");
                    _builder.newLineIfNotEmpty();
                }
            };
            it.setBody(_client);
        };
        featureCheckService.addMethod("of", _function_5);
        Procedures.Procedure1 _function_6 = it -> {
            it.setReturnType(context.newSelfTypeReference((Type)featureCheckService));
            it.setStatic(true);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Creates a new instance of this service without any active features.");
            _builder_1.newLine();
            _builder_1.newLine();
            _builder_1.append("@return A new feature check service.");
            _builder_1.newLine();
            it.setDocComment(_builder_1.toString());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return new ");
                    TypeReference _newSelfTypeReference = context.newSelfTypeReference((Type)featureCheckService);
                    _builder.append((Object)_newSelfTypeReference);
                    _builder.append((Object)"( ");
                    TypeReference _newSelfTypeReference_1 = context.newSelfTypeReference(context.findTypeGlobally(Collections.class));
                    _builder.append((Object)_newSelfTypeReference_1);
                    _builder.append((Object)".emptyList( ), \"Empty\" );");
                    _builder.newLineIfNotEmpty();
                }
            };
            it.setBody(_client);
        };
        _xblockexpression = featureCheckService.addMethod("empty", _function_6);
        return _xblockexpression;
    }

    private MutableAnnotationTypeElementDeclaration transformSelectedFeatures(MutableClassDeclaration annotatedClass, FeatureModelType featureModel, @Extension TransformationContext context) {
        MutableAnnotationTypeElementDeclaration _xblockexpression = null;
        FeatureType root = this.getRoot(featureModel);
        MutableAnnotationTypeDeclaration selectedFeatures = context.findAnnotationType(this._nameProvider.getFullQualifiedSelectedFeaturesAnnotationName((Type)annotatedClass, root.getName()));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This annotation is used to mark which features the annotated variant provides.<br/>");
        _builder.newLine();
        _builder.append("<br/>");
        _builder.newLine();
        _builder.append("This annotation is generated.");
        _builder.newLine();
        selectedFeatures.setDocComment(_builder.toString());
        Procedures.Procedure1 _function = it -> {
            Type _findTypeGlobally = context.findTypeGlobally(RetentionPolicy.class);
            it.setEnumValue("value", new EnumerationValueDeclaration[]{((EnumerationTypeDeclaration)_findTypeGlobally).findDeclaredValue(RetentionPolicy.RUNTIME.name())});
        };
        selectedFeatures.addAnnotation(context.newAnnotationReference(Retention.class, _function));
        Procedures.Procedure1 _function_1 = it -> {
            Type _findTypeGlobally = context.findTypeGlobally(ElementType.class);
            it.setEnumValue("value", new EnumerationValueDeclaration[]{((EnumerationTypeDeclaration)_findTypeGlobally).findDeclaredValue(ElementType.TYPE.name())});
        };
        selectedFeatures.addAnnotation(context.newAnnotationReference(Target.class, _function_1));
        Procedures.Procedure1 _function_2 = it -> {
            it.setDocComment("The selected features.");
            it.setType(context.newArrayTypeReference(context.newSelfTypeReference((Type)context.findEnumerationType(this._nameProvider.getFullQualifiedFeaturesEnumName((Type)annotatedClass, root.getName())))));
        };
        _xblockexpression = selectedFeatures.addAnnotationTypeElement("value", _function_2);
        return _xblockexpression;
    }

    private void transformFeature(MutableClassDeclaration annotatedClass, FeatureModelType featureModel, @Extension TransformationContext context) {
        FeatureType root = this.getRoot(featureModel);
        MutableEnumerationTypeDeclaration feature = context.findEnumerationType(this._nameProvider.getFullQualifiedFeaturesEnumName((Type)annotatedClass, root.getName()));
        AnnotationReference annotation = annotatedClass.findAnnotation(context.findTypeGlobally(FeatureIDEFeatures.class));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This enumeration contains all available features.<br/>");
        _builder.newLine();
        _builder.append("<br/>");
        _builder.newLine();
        _builder.append("This enumeration is generated.");
        _builder.newLine();
        feature.setDocComment(_builder.toString());
        this.addFeaturesToEnum(feature, annotation, root);
    }

    private void addFeaturesToEnum(MutableEnumerationTypeDeclaration enumeration, AnnotationReference annotationReference, FeatureType type) {
        if (type != null) {
            boolean _not;
            boolean _equals = Boolean.TRUE.equals(type.isAbstract());
            boolean bl = _not = !_equals;
            if (_not) {
                Procedures.Procedure1 _function = it -> it.setDocComment(type.getDescription());
                enumeration.addValue(this._featureNameConverter.convertToValidSimpleFeatureName(type.getName(), annotationReference), _function);
            }
            if (type instanceof BranchedFeatureType) {
                List _andOrOrOrAlt = ((BranchedFeatureType)type).getAndOrOrOrAlt();
                for (JAXBElement feature : _andOrOrOrAlt) {
                    this.addFeaturesToEnum(enumeration, annotationReference, (FeatureType)feature.getValue());
                }
            }
        }
    }

    private void transformVariant(MutableClassDeclaration annotatedClass, FeatureModelType featureModel, @Extension TransformationContext context) {
        FeatureType root = this.getRoot(featureModel);
        MutableInterfaceDeclaration variant = context.findInterface(this.getVariantName((ClassDeclaration)annotatedClass, root));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This is a marker interface for all variants.<br/>");
        _builder.newLine();
        _builder.append("<br/>");
        _builder.newLine();
        _builder.append("This interface is generated.");
        _builder.newLine();
        variant.setDocComment(_builder.toString());
    }
}

