package de.rhocas.featuregen.ap;

import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * This is a helper class to use consistent names between the annotation processors.
 * 
 * @author Nils Christian Ehmke
 */
@SuppressWarnings("all")
final class NameProvider {
  public String getFullQualifiedFeaturesEnumName(final Type annotatedElement, final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    String _fullQualifiedPrefix = this.getFullQualifiedPrefix(annotatedElement, rootFeatureName);
    _builder.append(_fullQualifiedPrefix);
    _builder.append("Feature");
    return _builder.toString();
  }
  
  public String getFullQualifiedFeatureCheckServiceClassName(final Type annotatedElement, final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    String _fullQualifiedPrefix = this.getFullQualifiedPrefix(annotatedElement, rootFeatureName);
    _builder.append(_fullQualifiedPrefix);
    _builder.append("FeatureCheckService");
    return _builder.toString();
  }
  
  public String getFullQualifiedSelectedFeaturesAnnotationName(final Type annotatedElement, final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    String _fullQualifiedPrefix = this.getFullQualifiedPrefix(annotatedElement, rootFeatureName);
    _builder.append(_fullQualifiedPrefix);
    _builder.append("SelectedFeatures");
    return _builder.toString();
  }
  
  public String getFullQualifiedVariantInterfaceName(final Type annotatedElement, final String rootFeatureName) {
    StringConcatenation _builder = new StringConcatenation();
    String _fullQualifiedPrefix = this.getFullQualifiedPrefix(annotatedElement, rootFeatureName);
    _builder.append(_fullQualifiedPrefix);
    _builder.append("Variant");
    return _builder.toString();
  }
  
  private String getFullQualifiedPrefix(final Type annotatedElement, final String rootFeatureName) {
    String _xblockexpression = null;
    {
      final String qualifiedName = annotatedElement.getQualifiedName();
      final String simpleName = annotatedElement.getSimpleName();
      int _length = qualifiedName.length();
      int _length_1 = simpleName.length();
      int _minus = (_length - _length_1);
      int _minus_1 = (_minus - 1);
      final String packageName = qualifiedName.substring(0, _minus_1);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(packageName);
      _builder.append(".");
      _builder.append(rootFeatureName);
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
}
