package de.rhocas.featuregen.ap;

import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;

/**
 * This is a helper class to convert the names of the features to valid Java identifiers.
 * 
 * @author Nils Christian Ehmke
 */
@SuppressWarnings("all")
final class FeatureNameConverter {
  public String convertToValidSimpleFeatureName(final String rawFeatureName, final AnnotationReference annotation) {
    String _xblockexpression = null;
    {
      final String prefix = annotation.getStringValue("prefix");
      final String suffix = annotation.getStringValue("suffix");
      String _replaceAll = rawFeatureName.replaceAll("(\\W)", "");
      String _plus = (prefix + _replaceAll);
      final String simpleFeatureName = (_plus + suffix);
      _xblockexpression = simpleFeatureName.toUpperCase();
    }
    return _xblockexpression;
  }
}
