/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import de.retest.ui.Path;
import de.retest.ui.descriptors.AttributeDifference;
import de.retest.ui.descriptors.Attributes;
import de.retest.ui.descriptors.IdentifyingAttributes;
import de.retest.ui.descriptors.IdentifyingAttributesAdapter;
import de.retest.ui.descriptors.RenderContainedElementsAdapter;
import de.retest.ui.descriptors.StateAttributesAdapter;
import de.retest.ui.image.Screenshot;
import de.retest.ui.review.ActionChangeSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ObjectUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Element
implements Serializable,
Comparable<Element> {
    protected static final long serialVersionUID = 2L;
    @XmlAttribute
    protected final String retestId;
    @XmlJavaTypeAdapter(value=IdentifyingAttributesAdapter.class)
    @XmlElement
    protected final IdentifyingAttributes identifyingAttributes;
    @XmlJavaTypeAdapter(value=StateAttributesAdapter.class)
    @XmlElement
    protected final Attributes attributes;
    @XmlElement
    @XmlJavaTypeAdapter(value=RenderContainedElementsAdapter.class)
    protected final List<Element> containedComponents;
    @XmlElement
    protected Screenshot screenshot;
    @XmlTransient
    private transient Integer hashCodeCache;

    protected Element() {
        this.retestId = "";
        this.identifyingAttributes = null;
        this.attributes = null;
        this.containedComponents = new ArrayList<Element>();
    }

    public Element(String retestId, IdentifyingAttributes identifyingAttributes, Attributes attributes) {
        this(retestId, identifyingAttributes, attributes, new ArrayList<Element>());
    }

    public Element(String retestId, IdentifyingAttributes identifyingAttributes, Attributes attributes, Element ... containedComponents) {
        this(retestId, identifyingAttributes, attributes, new ArrayList<Element>(Arrays.asList(containedComponents)));
    }

    public Element(String retestId, IdentifyingAttributes identifyingAttributes, Attributes attributes, List<Element> containedComponents) {
        this(retestId, identifyingAttributes, attributes, containedComponents, null);
    }

    public Element(String retestId, IdentifyingAttributes identifyingAttributes, Attributes attributes, Screenshot screenshot) {
        this(retestId, identifyingAttributes, attributes, new ArrayList<Element>(), screenshot);
    }

    public Element(String retestId, IdentifyingAttributes identifyingAttributes, Attributes attributes, List<Element> containedComponents, Screenshot screenshot) {
        this.retestId = this.verify(retestId);
        this.identifyingAttributes = identifyingAttributes;
        this.attributes = attributes;
        this.containedComponents = containedComponents;
        this.screenshot = screenshot;
    }

    private String verify(String retestId) {
        if (retestId == null) {
            throw new NullPointerException("retestId must not be null.");
        }
        if (retestId.isEmpty()) {
            throw new IllegalArgumentException("retestId must not be empty.");
        }
        if (retestId.matches(".*[^\\w].*")) {
            throw new IllegalArgumentException("retestID must not contain any whitespace characters.");
        }
        return retestId;
    }

    @Override
    public int compareTo(Element other) {
        int result = this.identifyingAttributes.compareTo(other.getIdentifyingAttributes());
        if (result != 0) {
            return result;
        }
        return this.attributes.compareTo(other.getAttributes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        if (!this.identifyingAttributes.equals(other.identifyingAttributes)) {
            return false;
        }
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        return this.containedComponents.equals(other.containedComponents);
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            this.hashCodeCache = this.identifyingAttributes.hashCode() + 31 * this.attributes.hashCode();
        }
        return this.hashCodeCache;
    }

    public String toString() {
        return this.identifyingAttributes.toString();
    }

    public IdentifyingAttributes getIdentifyingAttributes() {
        return this.identifyingAttributes;
    }

    public List<Element> getContainedElements() {
        return this.containedComponents;
    }

    public boolean hasContainedElements() {
        return !this.containedComponents.isEmpty();
    }

    public Screenshot getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(Screenshot screenshot) {
        if (screenshot == null && this.screenshot != null) {
            throw new RuntimeException("Screenshot can only be replaced, not deleted.");
        }
        this.screenshot = screenshot;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Element applyChanges(ActionChangeSet actionChangeSet) {
        if (actionChangeSet == null) {
            return this;
        }
        IdentifyingAttributes newIdentAttributes = this.identifyingAttributes.applyChanges(actionChangeSet.getIdentAttributeChanges().getAll(this.identifyingAttributes));
        Attributes newAttributes = this.attributes.applyChanges(actionChangeSet.getAttributesChanges().getAll(this.identifyingAttributes));
        List<Element> newContainedComps = this.createNewComponentList(actionChangeSet, newIdentAttributes);
        return new Element(this.retestId, newIdentAttributes, newAttributes, newContainedComps, this.screenshot);
    }

    protected List<Element> createNewComponentList(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes) {
        List<Element> newContainedComps = this.containedComponents;
        newContainedComps = this.removeDeleted(actionChangeSet, newContainedComps);
        newContainedComps = this.applyChangesToContainedComponents(actionChangeSet, newIdentAttributes, newContainedComps);
        newContainedComps = this.addInserted(actionChangeSet, newIdentAttributes, newContainedComps);
        return newContainedComps;
    }

    private List<Element> removeDeleted(ActionChangeSet actionChangeSet, List<Element> oldContainedComps) {
        Set<IdentifyingAttributes> deletedChanges = actionChangeSet.getDeletedChanges();
        ArrayList<Element> newContainedComps = new ArrayList<Element>(oldContainedComps.size());
        for (Element oldComp : oldContainedComps) {
            if (deletedChanges.contains(oldComp.getIdentifyingAttributes())) continue;
            newContainedComps.add(oldComp);
        }
        return newContainedComps;
    }

    private List<Element> applyChangesToContainedComponents(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes, List<Element> oldContainedComps) {
        ArrayList<Element> newContainedComps = new ArrayList<Element>(oldContainedComps.size());
        for (Element oldComp : oldContainedComps) {
            this.addPathChangeToChangeSet(actionChangeSet, newIdentAttributes, oldComp);
            newContainedComps.add(oldComp.applyChanges(actionChangeSet));
        }
        return newContainedComps;
    }

    private void addPathChangeToChangeSet(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes, Element oldComp) {
        if (ObjectUtils.notEqual((Object)this.identifyingAttributes.getPathTyped(), (Object)newIdentAttributes.getPathTyped())) {
            Path oldPath = oldComp.identifyingAttributes.getPathTyped();
            Path newPath = Path.fromString(newIdentAttributes.getPath() + "/" + oldComp.identifyingAttributes.getPathElement().toString());
            actionChangeSet.getIdentAttributeChanges().add(oldComp.identifyingAttributes, new AttributeDifference("path", oldPath, newPath));
        }
    }

    private List<Element> addInserted(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes, List<Element> newContainedComps) {
        for (Element insertedComp : actionChangeSet.getInsertedChanges()) {
            if (!Element.isParent(newIdentAttributes, insertedComp.identifyingAttributes)) continue;
            newContainedComps.add(insertedComp);
        }
        return newContainedComps;
    }

    private static boolean isParent(IdentifyingAttributes parentIdentAttributes, IdentifyingAttributes containedIdentAttributes) {
        return parentIdentAttributes.getPathTyped().equals(containedIdentAttributes.getParentPathTyped());
    }

    public int countAllContainedElements() {
        int result = 1;
        for (Element element : this.containedComponents) {
            result += element.countAllContainedElements();
        }
        return result;
    }

    public Element getElement(Path path) {
        Path thisPath = this.getIdentifyingAttributes().getPathTyped();
        if (thisPath.equals(path)) {
            return this;
        }
        if (thisPath.isParent(path)) {
            for (Element element : this.containedComponents) {
                Element contained = element.getElement(path);
                if (contained == null) continue;
                return contained;
            }
        }
        return null;
    }
}

