/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import de.retest.ui.descriptors.Attribute;
import de.retest.util.ChecksumCalculator;
import de.retest.util.ObjectUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AttributeDifference
implements Comparable<AttributeDifference>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AttributeDifference.class);
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String key;
    @XmlAttribute
    private final String attributeDifferenceId;
    @XmlElement
    private final Object expected;
    @XmlElement
    private final Object actual;

    protected AttributeDifference() {
        this.key = null;
        this.expected = null;
        this.actual = null;
        this.attributeDifferenceId = null;
    }

    public AttributeDifference(String key, Serializable expected, Serializable actual) {
        this.key = key;
        this.expected = expected;
        this.actual = actual;
        this.attributeDifferenceId = this.identifier();
    }

    public String getKey() {
        return this.key;
    }

    public Serializable getExpected() {
        return (Serializable)this.expected;
    }

    public Serializable getActual() {
        return (Serializable)this.actual;
    }

    public String identifier() {
        String contents = Joiner.on((String)" # ").join(Iterables.filter(Arrays.asList(this.actual, this.expected), (Predicate)Predicates.notNull()));
        return ChecksumCalculator.getInstance().sha256(contents);
    }

    public Attribute applyChangeTo(Attribute attribute) {
        this.warnIfAttributesDontMatch(attribute != null ? attribute.getValue() : null);
        return attribute.applyChanges(this.getActual());
    }

    protected final void warnIfAttributesDontMatch(Serializable fromAttribute) {
        Serializable expected = this.getExpected();
        if (ObjectUtil.isNullOrEmptyString(fromAttribute) ? ObjectUtil.isNullOrEmptyString(expected) : expected != null && fromAttribute.toString().equals(expected.toString())) {
            return;
        }
        logger.warn("Mismatch for attribute '{}': value from ExecSuite '{}', value from TestResult '{}'. This could be due to a change of the execsuite in between.", new Object[]{this.key, fromAttribute, expected});
    }

    public int hashCode() {
        return ObjectUtil.nextHashCode(ObjectUtil.nextHashCode(ObjectUtil.nextHashCode(1, (Serializable)this.actual), (Serializable)this.expected), (Serializable)((Object)this.key));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AttributeDifference other = (AttributeDifference)obj;
        return ObjectUtil.equal(this.key, other.key) && ObjectUtil.equal(this.expected, other.expected) && ObjectUtil.equal(this.actual, other.actual);
    }

    @Override
    public int compareTo(AttributeDifference other) {
        if (other == null) {
            return 1;
        }
        int result = ObjectUtil.compare(0, (Serializable)((Object)this.key), (Serializable)((Object)other.getKey()));
        result = ObjectUtil.compare(result, (Serializable)this.expected, other.getExpected());
        return ObjectUtil.compare(result, (Serializable)this.actual, other.getActual());
    }

    public String toString() {
        return this.key + ": expected=\"" + this.expected + "\", actual=\"" + this.actual + "\"";
    }

    public static String getSumIdentifier(List<AttributeDifference> attributeDifferences) {
        String result = "";
        for (AttributeDifference attributeDifference : attributeDifferences) {
            result = result + " # " + attributeDifference.identifier();
        }
        return ChecksumCalculator.getInstance().sha256(result);
    }
}

