/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import de.retest.ui.descriptors.Attributes;
import de.retest.ui.descriptors.Element;
import de.retest.ui.descriptors.IdentifyingAttributes;
import de.retest.ui.image.Screenshot;
import de.retest.ui.review.ActionChangeSet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RootElement
extends Element {
    private static final long serialVersionUID = 2L;
    @XmlAttribute
    private final int screenId;
    @XmlAttribute
    private final String screen;
    @XmlAttribute
    private final String title;

    private RootElement() {
        this.screenId = 0;
        this.screen = null;
        this.title = null;
    }

    public RootElement(IdentifyingAttributes identifyingAttributes, Attributes attributes, Screenshot screenshot, List<Element> containedComponents, String screen, int screenId, String title) {
        super(identifyingAttributes, attributes, containedComponents);
        this.setScreenshot(screenshot);
        this.screen = screen;
        this.screenId = screenId;
        this.title = title;
    }

    public String getScreen() {
        return this.screen;
    }

    public int getScreenId() {
        return this.screenId;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public RootElement applyChanges(ActionChangeSet actionChangeSet) {
        if (actionChangeSet == null) {
            return this;
        }
        IdentifyingAttributes newIdentAttributes = this.identifyingAttributes.applyChanges(actionChangeSet.getIdentAttributeChanges().getAll(this.identifyingAttributes));
        Attributes newAttributes = this.attributes.applyChanges(actionChangeSet.getAttributesChanges().getAll(this.identifyingAttributes));
        List<Element> newContainedComponents = this.createNewComponentList(actionChangeSet, newIdentAttributes);
        return new RootElement(newIdentAttributes, newAttributes, this.screenshot, newContainedComponents, this.screen, this.screenId, this.title);
    }

    public static List<Screenshot> getScreenshots(List<RootElement> windows) {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        for (RootElement rootElement : windows) {
            result.add(rootElement.getScreenshot());
        }
        return result;
    }
}

