/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import de.retest.ui.Path;
import de.retest.ui.PathElement;
import de.retest.ui.descriptors.Attribute;
import de.retest.ui.descriptors.AttributeDifference;
import de.retest.ui.descriptors.AttributesAdapter;
import de.retest.ui.descriptors.PathAttribute;
import de.retest.ui.descriptors.StringAttribute;
import de.retest.ui.descriptors.SuffixAttribute;
import de.retest.util.ChecksumCalculator;
import de.retest.util.ObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IdentifyingAttributes
implements Serializable,
Comparable<IdentifyingAttributes> {
    public static final String[] ATTRIBUTES = new String[]{"path", "type", "name", "text", "codeLoc", "x", "y", "height", "width", "context"};
    public static final double PERFECT_SIMILARITY = 3.0;
    private static final long serialVersionUID = 1L;
    @XmlElement
    @XmlJavaTypeAdapter(value=AttributesAdapter.class)
    private final SortedMap<String, Attribute> attributes = new TreeMap<String, Attribute>();
    private transient String parentPathCache;

    protected IdentifyingAttributes() {
    }

    public IdentifyingAttributes(Collection<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.attributes.put(attribute.getKey(), attribute);
        }
    }

    public static Collection<Attribute> createList(Path path, String type) {
        return new ArrayList<Attribute>(Arrays.asList(new PathAttribute(path), new StringAttribute("type", ObjectUtil.checkNull(type, "type")), new SuffixAttribute(path.getElement().getSuffix())));
    }

    public static IdentifyingAttributes create(Path path, Class<?> type) {
        return IdentifyingAttributes.create(path, type.getName());
    }

    public static IdentifyingAttributes create(Path path, String type) {
        return new IdentifyingAttributes(IdentifyingAttributes.createList(path, type));
    }

    public String getType() {
        return (String)this.get("type");
    }

    public String getSimpleType() {
        return this.getType().substring(this.getType().lastIndexOf(46) + 1);
    }

    public String getPath() {
        return this.getPathTyped().toString();
    }

    public Path getPathTyped() {
        return ((PathAttribute)this.attributes.get("path")).getValue();
    }

    public String getParentPath() {
        if (this.parentPathCache == null) {
            this.parentPathCache = this.getPathTyped().getParentPath() == null ? "" : this.getPathTyped().getParentPath().toString();
        }
        return this.parentPathCache;
    }

    public Path getParentPathTyped() {
        return this.getPathTyped().getParentPath();
    }

    public PathElement getPathElement() {
        return this.getPathTyped().getElement();
    }

    public String toFullString() {
        return Joiner.on((String)" # ").join(Iterables.filter(this.getValuesForFullString(), (Predicate)Predicates.notNull()));
    }

    public String identifier() {
        return ChecksumCalculator.getInstance().sha256(this.toFullString());
    }

    protected List<String> getValuesForFullString() {
        return Arrays.asList(this.getParentPath(), this.getType(), this.getSuffix());
    }

    @Override
    public int compareTo(IdentifyingAttributes other) {
        for (Attribute attribute : this.attributes.values()) {
            int result = attribute.compareTo(other.getAttribute(attribute.getKey()));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public double match(IdentifyingAttributes other) {
        double result = 0.0;
        double unifyingFactor = 0.0;
        HashSet<Attribute> otherAttributes = new HashSet<Attribute>(other.attributes.values());
        for (Attribute attribute : this.attributes.values()) {
            unifyingFactor += attribute.getWeight();
            Attribute otherAttribute = other.getAttribute(attribute.getKey());
            otherAttributes.remove(otherAttribute);
            if (otherAttribute == null) continue;
            result += attribute.getWeight() * attribute.match(otherAttribute);
        }
        for (Attribute attribute : otherAttributes) {
            unifyingFactor += attribute.getWeight();
        }
        assert ((result /= unifyingFactor) >= 0.0 && result <= 1.0) : "Match result " + result + " should be in [0,1].";
        return result;
    }

    public int hashCode() {
        int result = 0;
        Collection<Attribute> values = this.attributes.values();
        for (Attribute attribute : values) {
            if (!(attribute.getWeight() > 0.0)) continue;
            result = ObjectUtil.nextHashCode(result, Integer.valueOf(attribute.hashCode()));
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IdentifyingAttributes)) {
            return false;
        }
        IdentifyingAttributes other = (IdentifyingAttributes)object;
        return this.match(other) > 0.999999999999999;
    }

    public String toString() {
        return IdentifyingAttributes.createCompIdentString(this.getType(), (String)this.get("text"));
    }

    public static String createCompIdentString(String type, String text) {
        if (type == null) {
            return "";
        }
        String result = type;
        if (type.lastIndexOf(".") > -1) {
            result = type.substring(type.lastIndexOf(".") + 1, type.length());
        }
        if (text != null) {
            result = result + " [" + text + "]";
        }
        return result;
    }

    public String getSuffix() {
        return (String)this.get("suffix");
    }

    public <T> T get(String key) {
        Attribute attribute = (Attribute)this.attributes.get(key);
        if (attribute == null) {
            return null;
        }
        Serializable value = attribute.getValue();
        return (T)value;
    }

    public String getContext() {
        return (String)this.get("context");
    }

    public IdentifyingAttributes applyChanges(Set<AttributeDifference> attributeChanges) {
        if (attributeChanges.isEmpty()) {
            return this;
        }
        HashMap<String, Attribute> newAttributes = new HashMap<String, Attribute>(this.attributes);
        for (AttributeDifference attributeDifference : attributeChanges) {
            String key = attributeDifference.getKey();
            Attribute attribute = (Attribute)this.attributes.get(key);
            newAttributes.put(key, attributeDifference.applyChangeTo(attribute));
        }
        return this.newInstance(newAttributes.values());
    }

    protected IdentifyingAttributes newInstance(Collection<Attribute> attributes) {
        return new IdentifyingAttributes(attributes);
    }

    public Attribute getAttribute(String key) {
        return (Attribute)this.attributes.get(key);
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> result = new ArrayList<Attribute>(this.attributes.values());
        Collections.sort(result);
        return result;
    }
}

