/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import com.google.common.base.Objects;
import de.retest.ui.descriptors.AttributeDifference;
import de.retest.ui.descriptors.MutableAttributes;
import de.retest.ui.image.Screenshot;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Attributes
implements Iterable<Map.Entry<String, Object>>,
Serializable,
Comparable<Attributes> {
    public static final String TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String SCREENSHOT = "screenshot";
    private static final long serialVersionUID = 1L;
    @XmlElement
    private final TreeMap<String, Object> attributes;
    public static final String ENABLED = "enabled";
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String FOREGROUND_COLOR = "foregroundColor";
    public static final String FONT_SIZE = "fontSize";
    public static final String FONT_TYPE = "fontType";
    public static final String FONT_FAMILY = "fontFamily";
    @XmlElement
    protected final Screenshot screenshot;

    public Attributes() {
        this.attributes = new TreeMap();
        this.screenshot = null;
    }

    Attributes(MutableAttributes other) {
        this.attributes = new TreeMap<String, Object>((SortedMap<String, Object>)other.attributes);
        this.screenshot = (Screenshot)other.get(SCREENSHOT);
        if (this.screenshot != null) {
            this.attributes.put(SCREENSHOT, this.screenshot.getPersistenceId());
        }
    }

    public Object get(String name) {
        if (name.equals(SCREENSHOT)) {
            return this.screenshot;
        }
        return this.attributes.get(name);
    }

    @Override
    public int compareTo(Attributes other) {
        TreeSet<String> allKeys = new TreeSet<String>(this.attributes.keySet());
        allKeys.addAll(other.attributes.keySet());
        for (String key : allKeys) {
            Comparable localValue = (Comparable)this.attributes.get(key);
            Comparable otherValue = (Comparable)other.get(key);
            if (localValue == null) {
                return -1 * otherValue.compareTo(localValue);
            }
            int result = localValue.compareTo(otherValue);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return Collections.unmodifiableSet(this.attributes.entrySet()).iterator();
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof Attributes) {
            Attributes other = (Attributes)object;
            if (this.attributes.equals(other.attributes)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.attributes.toString();
    }

    public Map<String, ? extends Serializable> getMap() {
        TreeMap<String, Serializable> result = new TreeMap<String, Serializable>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            result.put(entry.getKey(), (Serializable)entry.getValue());
        }
        if (this.screenshot != null) {
            result.put(SCREENSHOT, this.screenshot);
        }
        return result;
    }

    public int size() {
        return this.attributes.size();
    }

    public Attributes applyChanges(Set<AttributeDifference> attributeChanges) {
        MutableAttributes result = new MutableAttributes(this);
        for (AttributeDifference attributeDifference : attributeChanges) {
            if (Objects.equal((Object)this.attributes.get(attributeDifference.getKey()), (Object)attributeDifference.getExpected())) {
                if (attributeDifference.getActual() == null) {
                    result.attributes.remove(attributeDifference.getKey());
                    continue;
                }
                result.attributes.put(attributeDifference.getKey(), attributeDifference.getActual());
                continue;
            }
            if (!attributeDifference.getKey().equals(SCREENSHOT)) continue;
            result.put((Screenshot)attributeDifference.getActual());
        }
        return result.immutable();
    }
}

