/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Header;
import de.resol.vbus.Packet;
import de.resol.vbus.SpecificationFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class Specification {
    private static Specification defaultSpecification = null;
    private SpecificationFile specificationFile;
    private HashMap<String, SpecificationFile.Unit> unitByCode;
    private HashMap<String, DeviceSpec> deviceSpecById;
    private HashMap<String, PacketSpec> packetSpecById;

    public static synchronized Specification getDefaultSpecification() {
        if (defaultSpecification == null) {
            SpecificationFile specFile = SpecificationFile.getDefaultSpecificationFile();
            defaultSpecification = new Specification(specFile);
        }
        return defaultSpecification;
    }

    private static DateFormat createUtcDateFormat(String format, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    public Specification(SpecificationFile specFile) {
        this.specificationFile = specFile;
        this.unitByCode = new HashMap();
        this.deviceSpecById = new HashMap();
        this.packetSpecById = new HashMap();
        for (SpecificationFile.Unit unit : specFile.getUnits()) {
            this.unitByCode.put(unit.getUnitCodeText(), unit);
        }
    }

    public SpecificationFile.Unit getUnitByCode(String unitCode) {
        return this.unitByCode.get(unitCode);
    }

    public DeviceSpec getDeviceSpec(int channel, int selfAddress, int peerAddress) {
        DeviceSpec deviceSpec;
        String id = String.format("%02X_%04X_%04X", channel, selfAddress, peerAddress);
        if (!this.deviceSpecById.containsKey(id)) {
            SpecificationFile.DeviceTemplate deviceTemplate = this.specificationFile.findDeviceTemplate(selfAddress, peerAddress);
            deviceSpec = new DeviceSpec(channel, selfAddress, peerAddress, deviceTemplate);
            this.deviceSpecById.put(id, deviceSpec);
        } else {
            deviceSpec = this.deviceSpecById.get(id);
        }
        return deviceSpec;
    }

    public DeviceSpec getSourceDeviceSpec(Header header) {
        return this.getDeviceSpec(header.getChannel(), header.getSourceAddress(), header.getDestinationAddress());
    }

    public DeviceSpec getDestinationDeviceSpec(Header header) {
        return this.getDeviceSpec(header.getChannel(), header.getDestinationAddress(), header.getSourceAddress());
    }

    public PacketSpec getPacketSpec(int channel, int destinationAddress, int sourceAddress, int command) {
        PacketSpec packetSpec;
        String id = String.format("%02X_%04X_%04X_10_%04X", channel, destinationAddress, sourceAddress, command);
        if (!this.packetSpecById.containsKey(id)) {
            SpecificationFile.PacketTemplate packetTemplate = this.specificationFile.findPacketTemplate(destinationAddress, sourceAddress, command);
            packetSpec = new PacketSpec(channel, destinationAddress, sourceAddress, command, packetTemplate);
            this.packetSpecById.put(id, packetSpec);
        } else {
            packetSpec = this.packetSpecById.get(id);
        }
        return packetSpec;
    }

    public PacketSpec getPacketSpec(Packet packet) {
        return this.getPacketSpec(packet.getChannel(), packet.getDestinationAddress(), packet.getSourceAddress(), packet.getCommand());
    }

    public PacketFieldSpec getPacketFieldSpec(PacketSpec packetSpec, String fieldId) {
        PacketFieldSpec result = null;
        for (PacketFieldSpec pfs : packetSpec.fieldSpecs) {
            if (!pfs.getFieldId().equals(fieldId)) continue;
            result = pfs;
            break;
        }
        return result;
    }

    public SpecificationFile.Unit[] getUnits() {
        return this.specificationFile.getUnits();
    }

    public Long getRawValueLong(PacketFieldSpec pfs, byte[] buffer, int start, int length) {
        long rawValue = 0L;
        int partCount = 0;
        for (SpecificationFile.PacketTemplateFieldPart ptfp : pfs.getParts()) {
            int offset = ptfp.getOffset();
            if (offset < 0 || offset >= length) continue;
            long partRawValue = buffer[start + offset];
            if (!ptfp.isSigned()) {
                partRawValue &= 0xFFL;
            }
            if (ptfp.getMask() != 255) {
                partRawValue &= (long)ptfp.getMask();
            }
            if (ptfp.getBitPos() > 0) {
                partRawValue >>= ptfp.getBitPos();
            }
            rawValue += partRawValue * ptfp.getFactor();
            ++partCount;
        }
        return partCount > 0 ? new Long(rawValue) : null;
    }

    public Double getRawValueDouble(PacketFieldSpec pfs, byte[] buffer, int start, int length) {
        Long rawValueLong = this.getRawValueLong(pfs, buffer, start, length);
        Double rawValueDouble = rawValueLong != null ? new Double(rawValueLong.doubleValue() * pfs.getFactor()) : null;
        return rawValueDouble;
    }

    protected String formatTextValueFromRawValueInternal(double rawValue, SpecificationFile.Unit unit, Locale locale, SpecificationFile.Type rootType, int precision, SpecificationFile.Unit defaultUnit) {
        String unitText = unit != null ? unit.getUnitTextText() : (defaultUnit != null ? defaultUnit.getUnitTextText() : "");
        Formatter formatter = Formatter.getFormatterForType(rootType);
        String textValue = formatter.formatTextValue(rawValue, locale, precision);
        return textValue + unitText;
    }

    public String formatTextValueFromRawValue(PacketFieldSpec pfs, double rawValue, SpecificationFile.Unit unit, Locale locale) {
        String textValue = this.formatTextValueFromRawValueInternal(rawValue, unit, locale, pfs.getType(), pfs.getPrecision(), pfs.getUnit());
        return textValue;
    }

    public String formatTextValueFromRawValue(PacketFieldSpec pfs, Double rawValue, SpecificationFile.Unit unit, Locale locale) {
        String textValue = rawValue != null ? this.formatTextValueFromRawValue(pfs, (double)rawValue, unit, locale) : "";
        return textValue;
    }

    public PacketFieldValue[] getPacketFieldValuesForHeaders(Header[] headers) {
        ArrayList<PacketFieldValue> pfvList = new ArrayList<PacketFieldValue>();
        for (Header header : headers) {
            Packet packet;
            PacketSpec packetSpec;
            if (!(header instanceof Packet) || (packetSpec = this.getPacketSpec(packet = (Packet)header)) == null) continue;
            for (PacketFieldSpec pfs : packetSpec.fieldSpecs) {
                PacketFieldValue pfv = new PacketFieldValue(packet, packetSpec, pfs);
                pfvList.add(pfv);
            }
        }
        return pfvList.toArray(new PacketFieldValue[pfvList.size()]);
    }

    public static double getPowerOfTen(int exponent) {
        double result;
        switch (exponent) {
            case -9: {
                result = 1.0E-9;
                break;
            }
            case -8: {
                result = 1.0E-8;
                break;
            }
            case -7: {
                result = 1.0E-7;
                break;
            }
            case -6: {
                result = 1.0E-6;
                break;
            }
            case -5: {
                result = 1.0E-5;
                break;
            }
            case -4: {
                result = 1.0E-4;
                break;
            }
            case -3: {
                result = 0.001;
                break;
            }
            case -2: {
                result = 0.01;
                break;
            }
            case -1: {
                result = 0.1;
                break;
            }
            case 0: {
                result = 1.0;
                break;
            }
            case 1: {
                result = 10.0;
                break;
            }
            case 2: {
                result = 100.0;
                break;
            }
            case 3: {
                result = 1000.0;
                break;
            }
            case 4: {
                result = 10000.0;
                break;
            }
            case 5: {
                result = 100000.0;
                break;
            }
            case 6: {
                result = 1000000.0;
                break;
            }
            case 7: {
                result = 1.0E7;
                break;
            }
            case 8: {
                result = 1.0E8;
                break;
            }
            case 9: {
                result = 1.0E9;
                break;
            }
            default: {
                result = Math.pow(10.0, exponent);
            }
        }
        return result;
    }

    public class PacketFieldValue {
        private Packet packet;
        private PacketSpec packetSpec;
        private PacketFieldSpec packetFieldSpec;
        private String packetFieldId;

        public PacketFieldValue(Packet packet, PacketSpec packetSpec, PacketFieldSpec packetFieldSpec) {
            this.packet = packet;
            this.packetSpec = packetSpec;
            this.packetFieldSpec = packetFieldSpec;
        }

        public Packet getPacket() {
            return this.packet;
        }

        public PacketSpec getPacketSpec() {
            return this.packetSpec;
        }

        public PacketFieldSpec getPacketFieldSpec() {
            return this.packetFieldSpec;
        }

        public String getPacketFieldId() {
            if (this.packetFieldId == null) {
                this.packetFieldId = String.format("%s_%s", this.packet.getId(), this.packetFieldSpec.getFieldId());
            }
            return this.packetFieldId;
        }

        public String getName(SpecificationFile.Language language) {
            return this.packetFieldSpec.getName(language);
        }

        public String getName() {
            return this.getName(SpecificationFile.Language.En);
        }

        public Long getRawValueLong() {
            return Specification.this.getRawValueLong(this.packetFieldSpec, this.packet.frameData, 0, this.packet.frameCount * 4);
        }

        public Double getRawValueDouble() {
            return Specification.this.getRawValueDouble(this.packetFieldSpec, this.packet.frameData, 0, this.packet.frameCount * 4);
        }

        public Date getRawValueDate() {
            Date date;
            Long rawValue = this.getRawValueLong();
            if (rawValue != null) {
                Formatter formatter = Formatter.getFormatterForType(this.packetFieldSpec.getType());
                date = formatter.convertToDate(rawValue);
            } else {
                date = null;
            }
            return date;
        }

        public String formatTextValue(SpecificationFile.Unit unit, Locale locale) {
            return Specification.this.formatTextValueFromRawValue(this.packetFieldSpec, this.getRawValueDouble(), unit, locale);
        }

        public SpecificationFile.EnumVariant getEnumVariant() {
            Long rawValue = this.getRawValueLong();
            SpecificationFile.EnumVariant enumVariant = rawValue != null ? this.packetFieldSpec.getEnumVariantForRawValue(rawValue) : null;
            return enumVariant;
        }

        public String formatText(SpecificationFile.Unit unit, Locale locale, SpecificationFile.Language language) {
            SpecificationFile.EnumVariant enumVariant = this.getEnumVariant();
            String result = enumVariant != null ? enumVariant.getText(language) : this.formatTextValue(unit, locale);
            return result;
        }

        public String formatText() {
            return this.formatText(null, Locale.getDefault(), SpecificationFile.Language.En);
        }

        public boolean isBooleanLikeEnum() {
            PacketFieldSpec pfs = this.getPacketFieldSpec();
            SpecificationFile.PacketTemplateFieldPart[] parts = pfs.getParts();
            SpecificationFile.Enum enum_ = pfs.getEnum();
            boolean isBitField = parts.length == 1 && Integer.bitCount(parts[0].getMask()) == 1;
            boolean isTwoVariantEnum = enum_ != null && enum_.getEnumVariants().length == 2;
            return isBitField && isTwoVariantEnum;
        }
    }

    public static class PacketSpec {
        private int channel;
        private int destinationAddress;
        private int sourceAddress;
        private int command;
        private PacketFieldSpec[] fieldSpecs;

        public PacketSpec(int channel, int destinationAddress, int sourceAddress, int command, SpecificationFile.PacketTemplate packetTemplate) {
            PacketFieldSpec[] fieldSpecs;
            this.channel = channel;
            this.destinationAddress = destinationAddress;
            this.sourceAddress = sourceAddress;
            this.command = command;
            if (packetTemplate != null) {
                SpecificationFile.PacketTemplateField[] packetTemplateFields = packetTemplate.getFields();
                fieldSpecs = new PacketFieldSpec[packetTemplateFields.length];
                for (int index = 0; index < packetTemplateFields.length; ++index) {
                    fieldSpecs[index] = new PacketFieldSpec(packetTemplateFields[index]);
                }
            } else {
                fieldSpecs = new PacketFieldSpec[]{};
            }
            this.fieldSpecs = fieldSpecs;
        }

        public int getChannel() {
            return this.channel;
        }

        public int getDestinationAddress() {
            return this.destinationAddress;
        }

        public int getSourceAddress() {
            return this.sourceAddress;
        }

        public int getCommand() {
            return this.command;
        }

        public PacketFieldSpec[] getFieldSpecs() {
            return this.fieldSpecs;
        }
    }

    public static class PacketFieldSpec {
        private SpecificationFile.PacketTemplateField packetTemplateField;

        protected PacketFieldSpec(SpecificationFile.PacketTemplateField packetTemplateField) {
            this.packetTemplateField = packetTemplateField;
        }

        public String getFieldId() {
            return this.packetTemplateField.getIdText();
        }

        public String getName(SpecificationFile.Language language) {
            return this.packetTemplateField.getNameLocalizedText(language);
        }

        public String getName() {
            return this.getName(SpecificationFile.Language.En);
        }

        public SpecificationFile.Unit getUnit() {
            return this.packetTemplateField.getUnit();
        }

        public int getPrecision() {
            return this.packetTemplateField.getPrecision();
        }

        public double getFactor() {
            return Specification.getPowerOfTen(-this.getPrecision());
        }

        public SpecificationFile.Type getType() {
            return this.packetTemplateField.getType();
        }

        public SpecificationFile.PacketTemplateFieldPart[] getParts() {
            return this.packetTemplateField.getParts();
        }

        public SpecificationFile.Enum getEnum() {
            return this.packetTemplateField.getEnum();
        }

        public SpecificationFile.EnumVariant getEnumVariantForRawValue(long rawValue) {
            SpecificationFile.Enum enum_ = this.packetTemplateField.getEnum();
            SpecificationFile.EnumVariant enumVariant = enum_ != null ? enum_.getEnumVariantForValue(rawValue) : null;
            return enumVariant;
        }
    }

    public static class DeviceSpec {
        private int channel;
        private int selfAddress;
        private int peerAddress;
        private String nameEn;
        private String nameDe;
        private String nameFr;

        public DeviceSpec(int channel, int selfAddress, int peerAddress, SpecificationFile.DeviceTemplate deviceTemplate) {
            this.channel = channel;
            this.selfAddress = selfAddress;
            this.peerAddress = peerAddress;
            if (deviceTemplate != null) {
                this.nameEn = deviceTemplate.getNameLocalizedText(SpecificationFile.Language.En);
                this.nameDe = deviceTemplate.getNameLocalizedText(SpecificationFile.Language.De);
                this.nameFr = deviceTemplate.getNameLocalizedText(SpecificationFile.Language.Fr);
            } else {
                this.nameEn = String.format("Unknown Device (0x%04X)", selfAddress);
                this.nameDe = String.format("Unbekanntes Ger\u00e4t (0x%04X)", selfAddress);
                this.nameFr = this.nameEn;
            }
        }

        public int getChannel() {
            return this.channel;
        }

        public int getSelfAddress() {
            return this.selfAddress;
        }

        public int getPeerAddress() {
            return this.peerAddress;
        }

        public String getName(SpecificationFile.Language language) {
            String name;
            switch (language) {
                case En: {
                    name = this.nameEn;
                    break;
                }
                case De: {
                    name = this.nameDe;
                    break;
                }
                case Fr: {
                    name = this.nameFr;
                    break;
                }
                default: {
                    name = this.nameEn;
                }
            }
            return name;
        }

        public String getName() {
            return this.nameEn;
        }
    }

    public static abstract class Formatter {
        private String formatterId;
        private static final String TIME_FORMAT_STRING = "HH:mm";
        private static final String WEEKTIME_FORMAT_STRING = "EEE,HH:mm";
        private static final String DATETIME_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
        public static final Formatter Number = new Formatter("Number"){

            @Override
            protected String formatTextValue(double rawValue, Locale locale, int precision) {
                String textValue;
                if (precision == 0) {
                    textValue = String.format(locale, "%.0f", rawValue);
                } else if (precision == 1) {
                    textValue = String.format(locale, "%.1f", rawValue);
                } else if (precision == 2) {
                    textValue = String.format(locale, "%.2f", rawValue);
                } else if (precision == 3) {
                    textValue = String.format(locale, "%.3f", rawValue);
                } else if (precision == 4) {
                    textValue = String.format(locale, "%.4f", rawValue);
                } else {
                    String format = String.format(locale, "%%.%df", precision);
                    textValue = String.format(locale, format, rawValue);
                }
                return textValue;
            }

            @Override
            protected Date convertToDate(long rawValue) {
                return null;
            }
        };
        public static final Formatter Time = new Formatter("Time"){

            @Override
            protected String formatTextValue(double rawValue, Locale locale, int precision) {
                String textValue = Specification.createUtcDateFormat(Formatter.TIME_FORMAT_STRING, locale).format(new Date(Math.round(rawValue) * 60000L));
                return textValue;
            }

            @Override
            protected Date convertToDate(long rawValue) {
                return new Date((rawValue + 16305120L) * 60000L);
            }
        };
        public static final Formatter WeekTime = new Formatter("WeekTime"){

            @Override
            protected String formatTextValue(double rawValue, Locale locale, int precision) {
                String textValue = Specification.createUtcDateFormat(Formatter.WEEKTIME_FORMAT_STRING, locale).format(new Date(Math.round(rawValue + 5760.0) * 60000L));
                return textValue;
            }

            @Override
            protected Date convertToDate(long rawValue) {
                return new Date((rawValue + 16305120L) * 60000L);
            }
        };
        public static final Formatter DateTime = new Formatter("DateTime"){

            @Override
            protected String formatTextValue(double rawValue, Locale locale, int precision) {
                String textValue = Specification.createUtcDateFormat(Formatter.DATETIME_FORMAT_STRING, locale).format(new Date(Math.round(rawValue + 9.783072E8) * 1000L));
                return textValue;
            }

            @Override
            protected Date convertToDate(long rawValue) {
                return new Date((rawValue + 978307200L) * 1000L);
            }
        };

        protected Formatter(String formatterId) {
            this.formatterId = formatterId;
        }

        public String getFormatterId() {
            return this.formatterId;
        }

        protected abstract String formatTextValue(double var1, Locale var3, int var4);

        protected abstract Date convertToDate(long var1);

        public static Formatter getFormatterForType(SpecificationFile.Type type) {
            Formatter formatter;
            switch (type) {
                case Number: {
                    formatter = Number;
                    break;
                }
                case Time: {
                    formatter = Time;
                    break;
                }
                case WeekTime: {
                    formatter = WeekTime;
                    break;
                }
                case DateTime: {
                    formatter = DateTime;
                    break;
                }
                default: {
                    formatter = Number;
                }
            }
            return formatter;
        }
    }
}

