/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.ConfigurationOptimizer;
import de.resol.vbus.ConfigurationValue;
import java.io.IOException;

public abstract class Customizer {
    private int deviceAddress;
    private ConfigurationOptimizer optimizer;

    public Customizer(int deviceAddress, ConfigurationOptimizer optimizer) {
        this.deviceAddress = deviceAddress;
        this.optimizer = optimizer;
    }

    public int getDeviceAddress() {
        return this.deviceAddress;
    }

    public ConfigurationOptimizer getOptimizer() {
        return this.optimizer;
    }

    public ConfigurationValue[] loadConfiguration(ConfigurationValue[] values, boolean optimize) throws IOException {
        if (this.optimizer != null) {
            values = this.optimizer.completeConfiguration(values);
        }
        return this.loadConfigurationInternal(values, optimize);
    }

    protected abstract ConfigurationValue[] loadConfigurationInternal(ConfigurationValue[] var1, boolean var2) throws IOException;

    public ConfigurationValue[] saveConfiguration(ConfigurationValue[] newValues, ConfigurationValue[] oldValues, boolean optimize) throws IOException {
        if (this.optimizer != null) {
            newValues = this.optimizer.completeConfiguration(newValues);
            if (oldValues != null) {
                oldValues = this.optimizer.completeConfiguration(oldValues);
            }
        }
        return this.saveConfigurationInternal(newValues, oldValues, optimize);
    }

    protected abstract ConfigurationValue[] saveConfigurationInternal(ConfigurationValue[] var1, ConfigurationValue[] var2, boolean var3) throws IOException;
}

