/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.DataSource;
import de.resol.vbus.DataSourceProvider;
import de.resol.vbus.TcpDataSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TcpDataSourceProvider
extends DataSourceProvider {
    private static final TcpDataSourceProvider theInstance = new TcpDataSourceProvider();

    public static TcpDataSourceProvider getSharedProvider() {
        return theInstance;
    }

    private TcpDataSourceProvider() {
    }

    @Override
    public String getId() {
        return "de.resol.vbus.TcpDataSourceProvider";
    }

    @Override
    public String getName() {
        return "TCP Data Source Provider";
    }

    @Override
    public String getDescription() {
        return "A Data Source Provider supporting LAN-enabled VBus devices";
    }

    @Override
    public DataSource[] discoverDataSources() {
        try {
            InetAddress address = Inet4Address.getByName("255.255.255.255");
            return TcpDataSourceProvider.discoverDataSources(address, 3, 500, true);
        }
        catch (UnknownHostException ex) {
            return new DataSource[0];
        }
    }

    @Override
    public DataSource createDataSource(String dsString) {
        return null;
    }

    public static TcpDataSource[] discoverDataSources(InetAddress address, int tries, int timeout, boolean fetchInformation) {
        Discovery discovery = new Discovery();
        return discovery.discoverDataSources(address, tries, timeout, fetchInformation);
    }

    public static TcpDataSource fetchInformation(InetAddress address, int timeout) throws IOException {
        TcpDataSource dataSource = null;
        try {
            dataSource = TcpDataSourceProvider.fetchInformation(address, 80, timeout);
        }
        catch (IOException ex) {
            try {
                dataSource = TcpDataSourceProvider.fetchInformation(address, 3000, timeout);
            }
            catch (IOException ex2) {
                throw ex;
            }
        }
        return dataSource;
    }

    public static TcpDataSource fetchInformation(InetAddress address, int port, int timeout) throws IOException {
        String line;
        URL url = new URL("http://" + address.getHostName() + ":" + port + "/cgi-bin/get_resol_device_information");
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String vendor = null;
        String product = null;
        String serial = null;
        String version = null;
        String build = null;
        String name = null;
        String features = null;
        Pattern re = Pattern.compile("^([^ =\t]+)\\s*=\\s*\"(.*)\"$");
        while ((line = in.readLine()) != null) {
            Matcher md = re.matcher(line);
            if (!md.find()) continue;
            String key = md.group(1);
            String value = md.group(2);
            if ("vendor".equals(key)) {
                vendor = value;
                continue;
            }
            if ("product".equals(key)) {
                product = value;
                continue;
            }
            if ("serial".equals(key)) {
                serial = value;
                continue;
            }
            if ("version".equals(key)) {
                version = value;
                continue;
            }
            if ("build".equals(key)) {
                build = value;
                continue;
            }
            if ("name".equals(key)) {
                name = value;
                continue;
            }
            if (!"features".equals(key)) continue;
            features = value;
        }
        in.close();
        TcpDataSource dataSource = new TcpDataSource(TcpDataSourceProvider.getSharedProvider(), address, port, 7053, vendor, product, serial, version, build, name, features);
        return dataSource;
    }

    private static class Discovery {
        ScheduledExecutorService scheduler;
        HashMap<String, TcpDataSource> dataSourceById;
        ArrayList<TcpDataSource> dataSourceList;

        private Discovery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TcpDataSource[] discoverDataSources(InetAddress address, int tries, int timeout, boolean fetchInformation) {
            this.dataSourceById = new HashMap();
            this.dataSourceList = new ArrayList();
            if (fetchInformation) {
                this.scheduler = Executors.newScheduledThreadPool(4);
            }
            DatagramSocket socket = null;
            try {
                socket = new DatagramSocket();
                socket.setBroadcast(true);
                socket.setSoTimeout(timeout);
                String queryString = "---RESOL-BROADCAST-QUERY---";
                byte[] queryBuffer = queryString.getBytes();
                DatagramPacket queryPacket = new DatagramPacket(queryBuffer, queryBuffer.length, new InetSocketAddress(address, 7053));
                String replyString = "---RESOL-BROADCAST-REPLY---";
                byte[] replyBuffer = replyString.getBytes();
                DatagramPacket replyPacket = new DatagramPacket(replyBuffer, replyBuffer.length);
                block9: for (int i = 0; i < tries; ++i) {
                    long cancelTimestamp = System.currentTimeMillis() + (long)timeout;
                    socket.send(queryPacket);
                    while (System.currentTimeMillis() < cancelTimestamp) {
                        String receivedReplyString;
                        replyPacket.setLength(replyBuffer.length);
                        try {
                            socket.receive(replyPacket);
                        }
                        catch (SocketTimeoutException ex) {
                            continue block9;
                        }
                        InetAddress replyAddress = replyPacket.getAddress();
                        if (replyPacket.getLength() != replyBuffer.length || !replyString.equals(receivedReplyString = new String(replyBuffer))) continue;
                        this.processReply(replyAddress, 1500, fetchInformation);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
            }
            if (this.scheduler != null) {
                this.scheduler.shutdown();
                try {
                    this.scheduler.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.dataSourceList.toArray(new TcpDataSource[this.dataSourceList.size()]);
        }

        void processReply(final InetAddress address, final int timeout, boolean fetchInformation) {
            final String addressId = address.getHostAddress();
            if (!this.dataSourceById.containsKey(addressId)) {
                if (fetchInformation && this.scheduler != null) {
                    this.dataSourceById.put(addressId, null);
                    this.scheduler.execute(new Runnable(){

                        @Override
                        public void run() {
                            TcpDataSource dataSource = null;
                            try {
                                dataSource = TcpDataSourceProvider.fetchInformation(address, timeout);
                            }
                            catch (IOException ex) {
                                System.out.println("Did not get information from " + address);
                                ex.printStackTrace();
                            }
                            if (dataSource != null) {
                                dataSourceById.put(addressId, dataSource);
                                dataSourceList.add(dataSource);
                            } else {
                                dataSourceById.remove(addressId);
                            }
                        }
                    });
                } else {
                    TcpDataSource dataSource = new TcpDataSource(TcpDataSourceProvider.getSharedProvider(), address, 80, 7053, null, null, null, null, null, null, null);
                    this.dataSourceById.put(addressId, dataSource);
                    this.dataSourceList.add(dataSource);
                }
            }
        }
    }
}

