/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Connection;
import de.resol.vbus.DataSource;
import de.resol.vbus.TcpConnection;
import de.resol.vbus.TcpDataSourceProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TcpDataSource
extends DataSource {
    public static final Pattern VIA_VBUS_NET_PATTERN = Pattern.compile("^([^\\.]+)\\.vbus\\.io$");
    protected InetAddress address;
    protected int webPort;
    protected int livePort;
    protected String vendor;
    protected String product;
    protected String serial;
    protected String version;
    protected String build;
    protected String deviceName;
    protected String features;
    protected String viaTag;
    protected String livePassword;

    public TcpDataSource(TcpDataSourceProvider provider, InetAddress address, int webPort, int livePort, String vendor, String product, String serial, String version, String build, String name, String features) {
        super(provider, null, name + " (" + address.getHostName() + ")", null);
        this.webPort = webPort;
        this.livePort = livePort;
        this.address = address;
        this.vendor = vendor;
        this.product = product;
        this.serial = serial;
        this.version = version;
        this.build = build;
        this.deviceName = name;
        this.features = features;
        String hostName = address.getHostName();
        Matcher md = VIA_VBUS_NET_PATTERN.matcher(hostName);
        if (md.find()) {
            this.viaTag = md.group(1);
        }
        this.livePassword = "vbus";
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public int getLivePort() {
        return this.livePort;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public String getSerial() {
        return this.serial;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getFeatures() {
        return this.features;
    }

    public String getViaTag() {
        return this.viaTag;
    }

    public void setViaTag(String viaTag) {
        this.viaTag = viaTag;
    }

    public String getLivePassword() {
        return this.livePassword;
    }

    public void setLivePassword(String password) {
        this.livePassword = password;
    }

    @Override
    public boolean isSupportingLiveData() {
        return this.livePort > 0;
    }

    @Override
    public Connection connectLive(int channel, int selfAddress) throws Exception {
        return new TcpConnection(selfAddress, new InetSocketAddress(this.address, this.livePort), this.viaTag, this.livePassword, channel);
    }
}

