/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Connection;
import de.resol.vbus.Header;
import de.resol.vbus.LiveInputStream;
import de.resol.vbus.LiveOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketAddress;

public class TcpConnection
extends Connection {
    private SocketAddress socketAddress;
    private String viaTag;
    private String password;
    private int channel;
    private Thread thread;
    private Socket socket;
    private LiveInputStream is;
    private LiveOutputStream os;

    public TcpConnection(int selfAddress, SocketAddress socketAddress, String viaTag, String password, int channel) {
        super(selfAddress);
        this.socketAddress = socketAddress;
        this.viaTag = viaTag;
        this.password = password;
        this.channel = channel;
    }

    @Override
    public void connect() throws IOException {
        if (this.connectionState != Connection.ConnectionState.DISCONNECTED) {
            throw new IOException("Connection is not disconnected");
        }
        this.setConnectionState(Connection.ConnectionState.CONNECTING);
        try {
            this.connectInternal();
        }
        catch (IOException ex) {
            this.setConnectionState(Connection.ConnectionState.DISCONNECTED);
            throw ex;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TcpConnection.this.runInBackground();
            }
        });
        this.thread.start();
    }

    @Override
    public void disconnect() throws IOException {
        if (this.connectionState != Connection.ConnectionState.DISCONNECTED) {
            this.setConnectionState(Connection.ConnectionState.DISCONNECTING);
            this.disconnectInternal();
            this.setConnectionState(Connection.ConnectionState.DISCONNECTED);
        }
    }

    @Override
    public void send(Header header) throws IOException {
        if (this.os != null) {
            this.os.writeHeader(header);
        }
    }

    private void runInBackground() {
        while (this.getConnectionState() != Connection.ConnectionState.DISCONNECTED) {
            switch (this.getConnectionState()) {
                case CONNECTED: {
                    try {
                        Header header = this.is.readHeader();
                        if (header == null) {
                            throw new IOException("Socket closed");
                        }
                        this.emitHeaderReceived(header);
                    }
                    catch (IOException ex) {
                        this.checkAndSetConnectionState(Connection.ConnectionState.CONNECTED, Connection.ConnectionState.INTERRUPTED);
                    }
                    break;
                }
                case INTERRUPTED: {
                    try {
                        Thread.sleep(1000L);
                        this.checkAndSetConnectionState(Connection.ConnectionState.INTERRUPTED, Connection.ConnectionState.RECONNECTING);
                    }
                    catch (InterruptedException ex) {}
                    break;
                }
                case RECONNECTING: {
                    try {
                        this.connectInternal();
                        this.checkAndSetConnectionState(Connection.ConnectionState.RECONNECTING, Connection.ConnectionState.CONNECTED);
                    }
                    catch (IOException ex) {
                        this.checkAndSetConnectionState(Connection.ConnectionState.RECONNECTING, Connection.ConnectionState.INTERRUPTED);
                    }
                    break;
                }
                case DISCONNECTING: 
                case CONNECTING: {
                    break;
                }
            }
        }
    }

    private void connectInternal() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(5000);
        socket.connect(this.socketAddress, 5500);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PrintWriter out = new PrintWriter(socket.getOutputStream());
        String errorMessage = null;
        String line = in.readLine();
        if (line == null) {
            errorMessage = "Unexpected end of stream while waiting for HELLO";
        } else if (line.charAt(0) == '-') {
            errorMessage = line;
        } else if (line.charAt(0) != '+') {
            errorMessage = "Unexpected line while waiting for HELLO";
        }
        if (errorMessage == null && this.viaTag != null && this.viaTag.length() > 0) {
            out.println("CONNECT " + this.viaTag);
            out.flush();
            line = in.readLine();
            if (line == null) {
                errorMessage = "Unexpected end of stream while waiting for CONNECT response";
            } else if (line.charAt(0) == '-') {
                errorMessage = line;
            } else if (line.charAt(0) != '+') {
                errorMessage = "Unexpected line while waiting for CONNECT response";
            }
        }
        if (errorMessage == null && this.password != null && this.password.length() > 0) {
            out.println("PASS " + this.password);
            out.flush();
            line = in.readLine();
            if (line == null) {
                errorMessage = "Unexpected end of stream while waiting for PASS response";
            } else if (line.charAt(0) == '-') {
                errorMessage = line;
            } else if (line.charAt(0) != '+') {
                errorMessage = "Unexpected line while waiting for PASS response";
            }
        }
        if (errorMessage == null && this.channel != 0) {
            out.println("CHANNEL " + this.channel);
            out.flush();
            line = in.readLine();
            if (line == null) {
                errorMessage = "Unexpected end of stream while waiting for CHANNEL response";
            } else if (line.charAt(0) == '-') {
                errorMessage = line;
            } else if (line.charAt(0) != '+') {
                errorMessage = "Unexpected line while waiting for CHANNEL response";
            }
        }
        if (errorMessage == null) {
            out.println("DATA");
            out.flush();
            line = in.readLine();
            if (line == null) {
                errorMessage = "Unexpected end of stream while waiting for DATA response";
            } else if (line.charAt(0) == '-') {
                errorMessage = line;
            } else if (line.charAt(0) != '+') {
                errorMessage = "Unexpected line while waiting for DATA response";
            }
        }
        if (errorMessage != null) {
            socket.close();
            throw new IOException(errorMessage);
        }
        Socket previousSocket = this.socket;
        this.socket = socket;
        this.is = new LiveInputStream(socket.getInputStream(), this.channel);
        this.os = new LiveOutputStream(socket.getOutputStream());
        this.setConnectionState(Connection.ConnectionState.CONNECTED);
        if (previousSocket != null) {
            try {
                previousSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void disconnectInternal() throws IOException {
        if (this.os != null) {
            this.os = null;
        }
        if (this.is != null) {
            this.is = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }
}

