/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Connection;
import de.resol.vbus.Header;
import de.resol.vbus.LiveInputStream;
import de.resol.vbus.LiveOutputStream;
import java.io.IOException;

public class StreamConnection
extends Connection {
    protected LiveInputStream is;
    protected LiveOutputStream os;
    protected Thread thread;

    public StreamConnection(int selfAddress, LiveInputStream is, LiveOutputStream os) {
        super(selfAddress);
        this.is = is;
        this.os = os;
    }

    @Override
    public void connect() throws IOException {
        if (this.connectionState != Connection.ConnectionState.DISCONNECTED) {
            throw new IOException("Connection is not disconnected");
        }
        this.setConnectionState(Connection.ConnectionState.CONNECTING);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                StreamConnection.this.runInBackground();
            }
        });
        this.thread.start();
    }

    @Override
    public void disconnect() throws IOException {
        if (this.connectionState != Connection.ConnectionState.DISCONNECTED) {
            this.setConnectionState(Connection.ConnectionState.DISCONNECTING);
            this.thread.interrupt();
        }
    }

    @Override
    public void send(Header header) throws IOException {
        this.os.writeHeader(header);
    }

    private void runInBackground() {
        this.setConnectionState(Connection.ConnectionState.CONNECTED);
        block11: while (this.getConnectionState() != Connection.ConnectionState.DISCONNECTED) {
            switch (this.getConnectionState()) {
                case CONNECTED: {
                    try {
                        Header header = this.readHeader();
                        if (header == null) continue block11;
                        this.emitHeaderReceived(header);
                    }
                    catch (IOException ex) {
                        this.checkAndSetConnectionState(Connection.ConnectionState.CONNECTED, Connection.ConnectionState.INTERRUPTED);
                    }
                    break;
                }
                case INTERRUPTED: {
                    try {
                        Thread.sleep(1000L);
                        this.checkAndSetConnectionState(Connection.ConnectionState.INTERRUPTED, Connection.ConnectionState.RECONNECTING);
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
                case RECONNECTING: {
                    this.checkAndSetConnectionState(Connection.ConnectionState.RECONNECTING, Connection.ConnectionState.CONNECTED);
                    break;
                }
                case DISCONNECTING: {
                    this.checkAndSetConnectionState(Connection.ConnectionState.DISCONNECTING, Connection.ConnectionState.DISCONNECTED);
                    break;
                }
                case DISCONNECTED: {
                    break;
                }
            }
        }
    }

    protected Header readHeader() throws IOException {
        Header header = this.is.readHeader();
        if (header == null) {
            throw new IOException("Stream closed");
        }
        return header;
    }
}

