/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.ConfigurationOptimizer;
import de.resol.vbus.ConfigurationValue;
import de.resol.vbus.Connection;
import de.resol.vbus.Customizer;
import de.resol.vbus.Datagram;
import java.io.IOException;

public class ConnectionCustomizer
extends Customizer {
    private Connection connection;
    private int maxRounds;
    private int triesPerValue;
    private long timeoutPerValue;
    private long masterTimeout;

    public ConnectionCustomizer(int deviceAddress, ConfigurationOptimizer optimizer, Connection connection) {
        super(deviceAddress, optimizer);
        this.connection = connection;
        this.maxRounds = 10;
        this.triesPerValue = 2;
        this.timeoutPerValue = 30000L;
        this.masterTimeout = 8000L;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    protected ConfigurationValue[] loadConfigurationInternal(final ConfigurationValue[] valuesParam, final boolean optimize) throws IOException {
        return this.transceiveConfiguration(TransceiveAction.GET, new ConfigurationValueFilter(){

            @Override
            public ConfigurationValue[] filterConfigurationValues(ConfigurationValue[] values, int round) {
                if (optimize) {
                    values = round == 1 ? ConnectionCustomizer.this.getOptimizer().optimizeLoadConfiguration(valuesParam) : ConnectionCustomizer.this.getOptimizer().optimizeLoadConfiguration(values);
                } else if (round == 1) {
                    values = valuesParam;
                    for (int i = 0; i < values.length; ++i) {
                        values[i].setPending(true);
                    }
                }
                return values;
            }
        });
    }

    @Override
    protected ConfigurationValue[] saveConfigurationInternal(final ConfigurationValue[] newValues, final ConfigurationValue[] oldValues, final boolean optimize) throws IOException {
        return this.transceiveConfiguration(TransceiveAction.SAVE, new ConfigurationValueFilter(){

            @Override
            public ConfigurationValue[] filterConfigurationValues(ConfigurationValue[] values, int round) {
                if (optimize) {
                    values = round == 1 ? ConnectionCustomizer.this.getOptimizer().optimizeSaveConfiguration(newValues, oldValues) : ConnectionCustomizer.this.getOptimizer().optimizeSaveConfiguration(newValues, values);
                } else if (round == 1) {
                    values = newValues;
                    for (int i = 0; i < values.length; ++i) {
                        values[i].setPending(true);
                    }
                }
                return values;
            }
        });
    }

    public ConfigurationValue[] transceiveConfiguration(TransceiveAction action, ConfigurationValueFilter filter) throws IOException {
        TransceiveState state = new TransceiveState();
        int round = 0;
        ConfigurationValue[] values = null;
        while (round < this.maxRounds) {
            values = filter.filterConfigurationValues(values, ++round);
            int pendingValues = 0;
            for (int i = 0; i < values.length; ++i) {
                ConfigurationValue valueInfo = values[i];
                if (!valueInfo.isPending()) continue;
                ++pendingValues;
                Datagram dgram = null;
                try {
                    dgram = this.transceiveValue(valueInfo, valueInfo.getValue(), action, state);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                valueInfo.setPending(false);
                valueInfo.setTransceived(dgram != null);
                if (dgram == null) continue;
                valueInfo.setValue(dgram.getValue());
            }
            if (pendingValues != 0) continue;
            break;
        }
        this.releaseBusIfTaken(state);
        return values;
    }

    public Datagram transceiveValue(ConfigurationValue valueInfo, int value, TransceiveAction action, TransceiveState state) throws IOException {
        state.valueStartedAt = System.currentTimeMillis();
        int address = this.getDeviceAddress();
        int tries = 0;
        Datagram result = null;
        while (result == null && tries < this.triesPerValue) {
            Datagram dgram;
            boolean isValidValue;
            this.checkTransceiveValueState(state);
            if (++tries > 1 && state.isBusTaken) {
                state.isBusTaken = false;
                this.connection.releaseBus(state.masterAddress, 1500, 0, 2);
            }
            if (!state.isBusTaken) {
                this.checkTransceiveValueState(state);
                Datagram dgram2 = this.connection.waitForFreeBus(20000);
                if (dgram2 != null) {
                    state.masterAddress = dgram2.getSourceAddress();
                } else {
                    state.masterAddress = 0;
                }
            }
            long now = System.currentTimeMillis();
            boolean contactMaster = state.masterAddress == 0 ? false : (state.masterAddress == address ? false : (!state.isBusTaken ? true : now - state.masterLastContactedAt >= this.masterTimeout));
            if (contactMaster) {
                this.checkTransceiveValueState(state);
                state.isBusTaken = true;
                state.masterLastContactedAt = now;
                this.connection.getValueById(state.masterAddress, 0, 500, 0, 1);
            }
            if (state.masterAddress == address) {
                state.isBusTaken = true;
                state.masterLastContactedAt = now;
            }
            if (valueInfo.getValueIndex() != 0) {
                isValidValue = true;
            } else if (valueInfo.getValueIdHash() != 0) {
                this.checkTransceiveValueState(state);
                dgram = this.connection.getValueIdByIdHash(address, valueInfo.getValueIdHash(), 500, 500, 3);
                if (dgram != null) {
                    valueInfo.setValueIndex(dgram.getValueId());
                    isValidValue = true;
                } else {
                    isValidValue = false;
                }
            } else {
                isValidValue = false;
            }
            if (!isValidValue) continue;
            this.checkTransceiveValueState(state);
            if (state.masterAddress == address) {
                state.isBusTaken = true;
                state.masterLastContactedAt = System.currentTimeMillis();
            }
            if (action == TransceiveAction.GET) {
                dgram = this.connection.getValueById(address, valueInfo.getValueIndex(), 500, 500, 3);
            } else if (action == TransceiveAction.SET) {
                dgram = this.connection.setValueById(address, valueInfo.getValueIndex(), value, false, 500, 500, 3);
            } else if (action == TransceiveAction.SAVE) {
                dgram = this.connection.setValueById(address, valueInfo.getValueIndex(), value, true, 500, 500, 3);
            } else {
                throw new UnsupportedOperationException("Unsupported TransceiveAction value");
            }
            if (dgram == null) continue;
            result = dgram;
        }
        return result;
    }

    private void checkTransceiveValueState(TransceiveState state) throws IOException {
        long now = System.currentTimeMillis();
        if (now - state.valueStartedAt >= this.timeoutPerValue) {
            throw new IOException("Exceeded the timeout per value");
        }
    }

    public void releaseBusIfTaken(TransceiveState state) throws IOException {
        if (state.isBusTaken) {
            state.isBusTaken = false;
            this.connection.releaseBus(state.masterAddress, 1500, 0, 1);
        }
    }

    public static enum TransceiveAction {
        GET,
        SET,
        SAVE;

    }

    public static interface ConfigurationValueFilter {
        public ConfigurationValue[] filterConfigurationValues(ConfigurationValue[] var1, int var2);
    }

    public static class TransceiveState {
        private long valueStartedAt;
        private boolean isBusTaken;
        private int masterAddress;
        private long masterLastContactedAt;
    }
}

