/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Header;
import de.resol.vbus.HeaderSet;
import de.resol.vbus.HeaderSetConsolidatorListener;
import de.resol.vbus.HeaderSetListener;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HeaderSetConsolidator<T extends Header>
extends HeaderSet<T> {
    protected static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    protected long minTimestamp;
    protected long maxTimestamp;
    protected int sieveInterval;
    protected int timeToLive;
    protected long lastTimerTimestamp;
    protected long lastSieveTimestamp;
    protected ScheduledFuture<?> future;

    public HeaderSetConsolidator(long timestamp, long minTimestamp, long maxTimestamp, int sieveInterval, int timeToLive) {
        super(timestamp);
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.sieveInterval = sieveInterval;
        this.timeToLive = timeToLive;
    }

    public void startTimer(final int interval) {
        final HeaderSetConsolidator that = this;
        this.stopTimer();
        this.lastTimerTimestamp = System.currentTimeMillis();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    that.handleTimerInterval(interval);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        int futureInterval = Math.min(interval / 2, 500);
        this.future = scheduler.scheduleAtFixedRate(command, 0L, futureInterval, TimeUnit.MILLISECONDS);
    }

    public void stopTimer() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    public void processHeaderSet(HeaderSet<T> headerSet) {
        long timestamp = headerSet.timestamp;
        Iterator<T> headerIterator = headerSet.getHeaderIterator();
        while (headerIterator.hasNext()) {
            this.addHeader((Header)headerIterator.next());
        }
        this.processHeaderSetInternal(timestamp);
    }

    private void handleTimerInterval(int interval) {
        boolean include;
        long lastInterval;
        long timestamp = System.currentTimeMillis();
        long currentInterval = timestamp / (long)interval;
        long diff = currentInterval - (lastInterval = this.lastTimerTimestamp / (long)interval);
        boolean bl = include = diff < -1L || diff > 0L;
        if (include) {
            this.processHeaderSetInternal(timestamp);
            this.lastTimerTimestamp = timestamp;
        }
    }

    private void processHeaderSetInternal(long timestamp) {
        boolean include;
        if (timestamp < this.minTimestamp) {
            include = false;
        } else if (timestamp > this.maxTimestamp) {
            include = false;
        } else if (this.sieveInterval <= 0) {
            include = true;
        } else {
            long currentInterval = timestamp / (long)this.sieveInterval;
            long lastInterval = this.lastSieveTimestamp / (long)this.sieveInterval;
            long diff = currentInterval - lastInterval;
            boolean bl = include = diff < -1L || diff > 0L;
        }
        if (this.timeToLive > 0) {
            this.removeHeadersOlderThan(timestamp - (long)this.timeToLive);
        }
        if (include) {
            this.timestamp = timestamp;
            for (HeaderSetListener listener : this.listeners) {
                if (!(listener instanceof HeaderSetConsolidatorListener)) continue;
                HeaderSetConsolidatorListener hscListener = (HeaderSetConsolidatorListener)listener;
                hscListener.headerSetProcessed(this);
            }
            this.lastSieveTimestamp = timestamp;
        }
    }
}

