/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.ConnectionAdapter;
import de.resol.vbus.ConnectionListener;
import de.resol.vbus.Datagram;
import de.resol.vbus.Header;
import de.resol.vbus.HeaderFilter;
import de.resol.vbus.Packet;
import de.resol.vbus.Telegram;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Connection {
    protected int selfAddress;
    protected List<ConnectionListener> listeners;
    protected ConnectionState connectionState;

    protected Connection(int selfAddress) {
        this.selfAddress = selfAddress;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.connectionState = ConnectionState.DISCONNECTED;
    }

    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    protected synchronized void setConnectionState(ConnectionState newConnectionState) {
        ConnectionListener[] listenersCopy;
        this.connectionState = newConnectionState;
        for (ConnectionListener listener : listenersCopy = this.listeners.toArray(new ConnectionListener[this.listeners.size()])) {
            listener.connectionStateChanged(this);
        }
    }

    protected void checkAndSetConnectionState(ConnectionState currentConnectionState, ConnectionState newConnectionState) {
        if (this.connectionState == currentConnectionState) {
            this.setConnectionState(newConnectionState);
        }
    }

    public abstract void connect() throws IOException;

    public abstract void disconnect() throws IOException;

    public abstract void send(Header var1) throws IOException;

    protected void sendOrTick(Header header) throws IOException {
        if (header != null) {
            this.send(header);
        }
    }

    protected void emitHeaderReceived(Header header) {
        ConnectionListener[] listenersCopy;
        for (ConnectionListener listener : listenersCopy = this.listeners.toArray(new ConnectionListener[this.listeners.size()])) {
            if (header instanceof Packet) {
                listener.packetReceived(this, (Packet)header);
                continue;
            }
            if (header instanceof Datagram) {
                listener.datagramReceived(this, (Datagram)header);
                continue;
            }
            if (!(header instanceof Telegram)) continue;
            listener.telegramReceived(this, (Telegram)header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Header transceive(Header txHeader, int initialTimeout, int timeoutIncr, int tries, final HeaderFilter filter) throws IOException {
        final Header[] rxHeader = new Header[1];
        ConnectionAdapter listener = new ConnectionAdapter(){

            @Override
            public void packetReceived(Connection connection, Packet packet) {
                this.headerReceived(packet);
            }

            @Override
            public void datagramReceived(Connection connection, Datagram dgram) {
                this.headerReceived(dgram);
            }

            @Override
            public void telegramReceived(Connection connection, Telegram tgram) {
                this.headerReceived(tgram);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void headerReceived(Header header) {
                if (filter == null || !filter.filterHeader(header)) return;
                Header[] headerArray = rxHeader;
                synchronized (rxHeader) {
                    rxHeader[0] = header;
                    rxHeader.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        this.addListener(listener);
        try {
            int timeout = initialTimeout;
            Header[] headerArray = rxHeader;
            synchronized (rxHeader) {
                for (int currentTry = 0; currentTry < tries; ++currentTry) {
                    this.sendOrTick(txHeader);
                    if (rxHeader[0] == null) {
                        try {
                            rxHeader.wait(timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (rxHeader[0] != null) break;
                    timeout += timeoutIncr;
                }
                // ** MonitorExit[var9_9] (shouldn't be in output)
            }
        }
        finally {
            this.removeListener(listener);
        }
        {
            return rxHeader[0];
        }
    }

    public Datagram waitForFreeBus(int timeout) throws IOException {
        Header rxHeader = this.transceive(null, timeout, 0, 1, new HeaderFilter(){

            @Override
            public boolean filterHeader(Header header) {
                Datagram dgram;
                return header instanceof Datagram && (dgram = (Datagram)header).getCommand() == 1280;
            }
        });
        return (Datagram)rxHeader;
    }

    public Packet releaseBus(int address, int timeout, int timeoutIncr, int tries) throws IOException {
        Datagram txDgram = new Datagram(0L, 0, address, this.selfAddress, 1536, 0, 0);
        Header rxHeader = this.transceive(txDgram, timeout, timeoutIncr, tries, new HeaderFilter(){

            @Override
            public boolean filterHeader(Header header) {
                return header instanceof Packet;
            }
        });
        return (Packet)rxHeader;
    }

    public Datagram getValueById(final int address, final int valueId, int timeout, int timeoutIncr, int tries) throws IOException {
        Datagram txDgram = new Datagram(0L, 0, address, this.selfAddress, 768, valueId, 0);
        Header rxHeader = this.transceive(txDgram, timeout, timeoutIncr, tries, new HeaderFilter(){

            @Override
            public boolean filterHeader(Header header) {
                Datagram dgram;
                return header instanceof Datagram && (dgram = (Datagram)header).getDestinationAddress() == Connection.this.selfAddress && dgram.getSourceAddress() == address && dgram.getCommand() == 256 && dgram.getValueId() == valueId;
                {
                }
            }
        });
        return (Datagram)rxHeader;
    }

    public Datagram setValueById(final int address, final int valueId, int value, boolean save, int timeout, int timeoutIncr, int tries) throws IOException {
        Datagram txDgram = new Datagram(0L, 0, address, this.selfAddress, save ? 1024 : 512, valueId, value);
        Header rxHeader = this.transceive(txDgram, timeout, timeoutIncr, tries, new HeaderFilter(){

            @Override
            public boolean filterHeader(Header header) {
                Datagram dgram;
                return header instanceof Datagram && (dgram = (Datagram)header).getDestinationAddress() == Connection.this.selfAddress && dgram.getSourceAddress() == address && dgram.getCommand() == 256 && dgram.getValueId() == valueId;
                {
                }
            }
        });
        return (Datagram)rxHeader;
    }

    public Datagram getValueIdHashById(final int address, final int valueId, int timeout, int timeoutIncr, int tries) throws IOException {
        Datagram txDgram = new Datagram(0L, 0, address, this.selfAddress, 4096, valueId, 0);
        Header rxHeader = this.transceive(txDgram, timeout, timeoutIncr, tries, new HeaderFilter(){

            @Override
            public boolean filterHeader(Header header) {
                Datagram dgram;
                return header instanceof Datagram && (dgram = (Datagram)header).getDestinationAddress() == Connection.this.selfAddress && dgram.getSourceAddress() == address && (dgram.getCommand() == 256 || dgram.getCommand() == 4097) && dgram.getValueId() == valueId;
                {
                }
            }
        });
        return (Datagram)rxHeader;
    }

    public Datagram getValueIdByIdHash(final int address, final int valueIdHash, int timeout, int timeoutIncr, int tries) throws IOException {
        Datagram txDgram = new Datagram(0L, 0, address, this.selfAddress, 4352, 0, valueIdHash);
        Header rxHeader = this.transceive(txDgram, timeout, timeoutIncr, tries, new HeaderFilter(){

            @Override
            public boolean filterHeader(Header header) {
                Datagram dgram;
                return header instanceof Datagram && (dgram = (Datagram)header).getDestinationAddress() == Connection.this.selfAddress && dgram.getSourceAddress() == address && (dgram.getCommand() == 256 || dgram.getCommand() == 4353) && dgram.getValue() == valueIdHash;
                {
                }
            }
        });
        return (Datagram)rxHeader;
    }

    public static enum ConnectionState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        INTERRUPTED,
        RECONNECTING,
        DISCONNECTING;

    }
}

