/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionTypeParser;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.TypeValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class OutputValuesTypeValidator
extends TypeValidator<Output> {
    public boolean isApplicable(Output output, ValidationContext validationContext) {
        String expressionType = output.getTypeRef();
        return output.getOutputValues() != null && ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(parseError -> false, parseResult -> true) != false;
    }

    public List<ValidationResult> validate(Output output, ValidationContext validationContext) {
        String expressionType = output.getTypeRef();
        return ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(validationResult -> Collections.singletonList(validationResult.element((ModelElementInstance)output).build()), inputType -> this.typecheck((DmnElement)output, Stream.of(output.getOutputValues()).map(this.toplevelExpressionLanguage::toExpression), Stream.of(inputType)).collect(Collectors.toList()));
    }

    protected Class<Output> getClassUnderValidation() {
        return Output.class;
    }

    @Override
    String errorMessage() {
        return "Type of predefined output values does not match type of output expression";
    }
}

