/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionTypeParser;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.validators.TypeValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.OutputClause;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class OutputEntryTypeValidator
extends TypeValidator<DecisionTable> {
    public boolean isApplicable(DecisionTable decisionTable, ValidationContext validationContext) {
        return decisionTable.getOutputs().stream().allMatch(output -> {
            String expressionType = output.getTypeRef();
            return ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(parseError -> false, parseResult -> true);
        });
    }

    public List<ValidationResult> validate(DecisionTable decisionTable, ValidationContext validationContext) {
        Either eitherOutputTypes = decisionTable.getOutputs().stream().map(OutputClause::getTypeRef).map(typeRef -> ExpressionTypeParser.parse(typeRef, validationContext.getItemDefinitions())).collect(Either.reduce());
        return decisionTable.getRules().stream().flatMap(rule -> eitherOutputTypes.match(validationResult -> Stream.of(validationResult.element((ModelElementInstance)rule).build()), outputTypes -> this.typecheck((DmnElement)rule, rule.getOutputEntries().stream().map(this.toplevelExpressionLanguage::toExpression), outputTypes.stream()))).collect(Collectors.toList());
    }

    protected Class<DecisionTable> getClassUnderValidation() {
        return DecisionTable.class;
    }

    @Override
    public String errorMessage() {
        return "Type of output entry does not match type of output expression";
    }
}

