/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionTypeParser;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.TypeValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class InputValuesTypeValidator
extends TypeValidator<Input> {
    public boolean isApplicable(Input input, ValidationContext validationContext) {
        String expressionType = input.getInputExpression().getTypeRef();
        return input.getInputValues() != null && ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(parseError -> false, parseResult -> true) != false;
    }

    public List<ValidationResult> validate(Input input, ValidationContext validationContext) {
        String expressionType = input.getInputExpression().getTypeRef();
        return ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(validationResult -> Collections.singletonList(validationResult.element((ModelElementInstance)input).build()), inputType -> this.typecheck((DmnElement)input, Stream.of(input.getInputValues()).map(this.toplevelExpressionLanguage::toExpression), Stream.of(inputType)).collect(Collectors.toList()));
    }

    protected Class<Input> getClassUnderValidation() {
        return Input.class;
    }

    @Override
    String errorMessage() {
        return "Type of predefined input values does not match type of input expression";
    }
}

