/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionTypeParser;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.validators.TypeValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.InputClause;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class InputEntryTypeValidator
extends TypeValidator<DecisionTable> {
    public boolean isApplicable(DecisionTable decisionTable, ValidationContext validationContext) {
        return decisionTable.getInputs().stream().allMatch(input -> {
            String expressionType = input.getInputExpression().getTypeRef();
            return ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(parseError -> false, parseResult -> true);
        });
    }

    public List<ValidationResult> validate(DecisionTable decisionTable, ValidationContext validationContext) {
        Either eitherInputTypes = decisionTable.getInputs().stream().map(input -> input.getInputExpression().getTypeRef()).map(typeRef -> ExpressionTypeParser.parse(typeRef, validationContext.getItemDefinitions())).collect(Either.reduce());
        return decisionTable.getRules().stream().flatMap(rule -> {
            Stream<String> inputVariables = decisionTable.getInputs().stream().map(InputClause::getCamundaInputVariable);
            return eitherInputTypes.match(validationResult -> Stream.of(validationResult.element((ModelElementInstance)rule).build()), inputTypes -> this.typecheck((DmnElement)rule, rule.getInputEntries().stream().map(this.toplevelExpressionLanguage::toExpression), inputVariables, inputTypes.stream()));
        }).collect(Collectors.toList());
    }

    protected Class<DecisionTable> getClassUnderValidation() {
        return DecisionTable.class;
    }

    @Override
    public String errorMessage() {
        return "Type of input entry does not match type of input expression";
    }
}

