/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.util;

import java.util.Objects;
import org.camunda.bpm.model.dmn.instance.LiteralExpression;
import org.camunda.bpm.model.dmn.instance.UnaryTests;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Expression {
    public final String textContent;
    public final String expressionLanguage;

    public Expression(UnaryTests unaryTests, @Nullable String toplevelExpressionLanguage) {
        this.textContent = unaryTests.getTextContent();
        this.expressionLanguage = Expression.decideExpressionLanguage(unaryTests.getExpressionLanguage(), toplevelExpressionLanguage);
    }

    public Expression(LiteralExpression literalExpression, @Nullable String toplevelExpressionLanguage) {
        this.textContent = literalExpression.getTextContent();
        this.expressionLanguage = Expression.decideExpressionLanguage(literalExpression.getExpressionLanguage(), toplevelExpressionLanguage);
    }

    private static String decideExpressionLanguage(String localExpressionLanguage, @Nullable String toplevelExpressionLanguage) {
        return Objects.requireNonNullElseGet(localExpressionLanguage, () -> Objects.requireNonNullElse(toplevelExpressionLanguage, "http://www.omg.org/spec/FEEL/20140401"));
    }
}

