/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.FeelExpression;
import de.redsix.dmncheck.feel.FeelParser;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.util.Eithers;
import de.redsix.dmncheck.util.Util;
import de.redsix.dmncheck.validators.core.SimpleValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.HitPolicy;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.InputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ShadowedRuleValidator
extends SimpleValidator<DecisionTable> {
    public Class<DecisionTable> getClassUnderValidation() {
        return DecisionTable.class;
    }

    public boolean isApplicable(DecisionTable decisionTable, ValidationContext validationContext) {
        return !Arrays.asList(HitPolicy.COLLECT, HitPolicy.RULE_ORDER).contains(decisionTable.getHitPolicy());
    }

    public List<ValidationResult> validate(DecisionTable decisionTable, ValidationContext validationContext) {
        ArrayList rules = new ArrayList(decisionTable.getRules());
        Collections.reverse(rules);
        return Util.zip(IntStream.range(1, rules.size()).boxed(), rules.stream(), (n, rule) -> this.identifySubsumedRules((Integer)n, (Rule)rule, rules)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private Stream<ValidationResult> identifySubsumedRules(Integer n, Rule rule, ArrayList<Rule> rules) {
        return rules.stream().skip(n.intValue()).flatMap(potentiallySubsumingRule -> this.collectSubsumptionResults(rule, (Rule)potentiallySubsumingRule).match(validationResultElementStep -> Stream.of(validationResultElementStep.element((ModelElementInstance)rule).build()), subsumptionResults -> this.isRuleSubsumed((List<Optional<Boolean>>)subsumptionResults, rule, (Rule)potentiallySubsumingRule)));
    }

    private Either<ValidationResult.Builder.ElementStep, List<Optional<Boolean>>> collectSubsumptionResults(Rule rule, Rule potentiallySubsumingRule) {
        return Util.zip(rule.getInputEntries().stream(), potentiallySubsumingRule.getInputEntries().stream(), this::checkInputsForSubsumption).collect(Either.reduce());
    }

    private Either<ValidationResult.Builder.ElementStep, Optional<Boolean>> checkInputsForSubsumption(InputEntry input, InputEntry potentiallySubsumingInput) {
        return FeelParser.parse(input.getTextContent()).bind(inputExpression -> FeelParser.parse(potentiallySubsumingInput.getTextContent()).bind(potentiallySubsumingInputExpression -> Eithers.right(potentiallySubsumingInputExpression.subsumes((FeelExpression)inputExpression))));
    }

    private Stream<ValidationResult> isRuleSubsumed(List<Optional<Boolean>> subsumptionResults, Rule rule, Rule potentiallySubsumingRule) {
        if (this.subsumptionCheckIsPossible(subsumptionResults) && this.everythingIsSubsumed(subsumptionResults)) {
            return Stream.of(ValidationResult.init.message("Rule is shadowed by rule " + potentiallySubsumingRule.getId()).element((ModelElementInstance)rule).build());
        }
        return Stream.empty();
    }

    private boolean everythingIsSubsumed(List<Optional<Boolean>> subsumptionResults) {
        return subsumptionResults.stream().allMatch(result -> result.orElse(false));
    }

    private boolean subsumptionCheckIsPossible(List<Optional<Boolean>> subsumptionResults) {
        return !subsumptionResults.contains(Optional.empty());
    }
}

