/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionType;
import de.redsix.dmncheck.feel.ExpressionTypeParser;
import de.redsix.dmncheck.feel.ExpressionTypes;
import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.validators.core.SimpleValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class ElementTypeDeclarationValidator<T extends DmnElement>
extends SimpleValidator<T> {
    abstract String getTypeRef(T var1);

    public boolean isApplicable(T expression, ValidationContext validationContext) {
        return true;
    }

    public List<ValidationResult> validate(T expression, ValidationContext validationContext) {
        String expressionType = this.getTypeRef(expression);
        if (Objects.isNull(expressionType)) {
            return Collections.singletonList(ValidationResult.init.message(this.getClassUnderValidation().getSimpleName() + " has no type").severity(Severity.WARNING).element(expression).build());
        }
        Either<ValidationResult.Builder.ElementStep, ExpressionType> eitherType = ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions());
        return eitherType.match(validationResult -> Collections.singletonList(validationResult.element((ModelElementInstance)expression).build()), type -> {
            if (ExpressionTypes.TOP().equals(type)) {
                return Collections.singletonList(ValidationResult.init.message("TOP is an internal type and cannot be used in declarations.").severity(Severity.ERROR).element((ModelElementInstance)expression).build());
            }
            return Collections.emptyList();
        });
    }
}

