/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.feel;

import de.redsix.dmncheck.feel.FeelExpression;
import de.redsix.dmncheck.feel.Operator;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

final class FeelExpressions {
    private static FeelExpression Empty;
    private static FeelExpression Null;
    private static final FeelExpression.Cases<Optional<Boolean>> aBooleanGetter;
    private static final FeelExpression.Cases<Optional<LocalDateTime>> dateTimeGetter;
    private static final FeelExpression.Cases<Optional<Double>> aDoubleGetter;
    private static final FeelExpression.Cases<Optional<Integer>> aIntegerGetter;
    private static final FeelExpression.Cases<Optional<String>> stringGetter;
    private static final FeelExpression.Cases<Optional<String>> nameGetter;
    private static final FeelExpression.Cases<Optional<Boolean>> isLeftInclusiveGetter;
    private static final FeelExpression.Cases<Optional<FeelExpression>> lowerBoundGetter;
    private static final FeelExpression.Cases<Optional<FeelExpression>> upperBoundGetter;
    private static final FeelExpression.Cases<Optional<Boolean>> isRightInclusiveGetter;
    private static final FeelExpression.Cases<Optional<Operator>> operatorGetter;
    private static final FeelExpression.Cases<Optional<FeelExpression>> expressionGetter;
    private static final FeelExpression.Cases<Optional<FeelExpression>> leftGetter;
    private static final FeelExpression.Cases<Optional<FeelExpression>> rightGetter;
    private static final FeelExpression.Cases<Optional<FeelExpression>> headGetter;
    private static final FeelExpression.Cases<Optional<FeelExpression>> tailGetter;

    private FeelExpressions() {
    }

    public static <R> FeelExpression.Cases<R> cases(Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2, UnaryExpressionMapper<R> UnaryExpression2, BinaryExpressionMapper<R> BinaryExpression2, DisjunctionExpressionMapper<R> DisjunctionExpression2) {
        return new LambdaCases<R>(Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, RangeExpression2, UnaryExpression2, BinaryExpression2, DisjunctionExpression2);
    }

    public static FeelExpression Empty() {
        FeelExpression _Empty = Empty;
        if (_Empty == null) {
            Empty = _Empty = new Empty();
        }
        return _Empty;
    }

    public static FeelExpression Null() {
        FeelExpression _Null = Null;
        if (_Null == null) {
            Null = _Null = new Null();
        }
        return _Null;
    }

    public static FeelExpression BooleanLiteral(Boolean aBoolean) {
        return new BooleanLiteral(aBoolean);
    }

    public static FeelExpression DateLiteral(LocalDateTime dateTime) {
        return new DateLiteral(dateTime);
    }

    public static FeelExpression DoubleLiteral(Double aDouble) {
        return new DoubleLiteral(aDouble);
    }

    public static FeelExpression IntegerLiteral(Integer aInteger) {
        return new IntegerLiteral(aInteger);
    }

    public static FeelExpression StringLiteral(String string) {
        return new StringLiteral(string);
    }

    public static FeelExpression VariableLiteral(String name) {
        return new VariableLiteral(name);
    }

    public static FeelExpression RangeExpression(boolean isLeftInclusive, FeelExpression lowerBound, FeelExpression upperBound, boolean isRightInclusive) {
        return new RangeExpression(isLeftInclusive, lowerBound, upperBound, isRightInclusive);
    }

    public static FeelExpression UnaryExpression(Operator operator, FeelExpression expression) {
        return new UnaryExpression(operator, expression);
    }

    public static FeelExpression BinaryExpression(FeelExpression left, Operator operator, FeelExpression right) {
        return new BinaryExpression(left, operator, right);
    }

    public static FeelExpression DisjunctionExpression(FeelExpression head, FeelExpression tail) {
        return new DisjunctionExpression(head, tail);
    }

    public static CaseOfMatchers.TotalMatcher_Empty caseOf(FeelExpression feelExpression) {
        return new CaseOfMatchers.TotalMatcher_Empty(feelExpression);
    }

    public static Optional<Boolean> getABoolean(FeelExpression feelExpression) {
        return feelExpression.match(aBooleanGetter);
    }

    public static Optional<LocalDateTime> getDateTime(FeelExpression feelExpression) {
        return feelExpression.match(dateTimeGetter);
    }

    public static Optional<Double> getADouble(FeelExpression feelExpression) {
        return feelExpression.match(aDoubleGetter);
    }

    public static Optional<Integer> getAInteger(FeelExpression feelExpression) {
        return feelExpression.match(aIntegerGetter);
    }

    public static Optional<String> getString(FeelExpression feelExpression) {
        return feelExpression.match(stringGetter);
    }

    public static Optional<String> getName(FeelExpression feelExpression) {
        return feelExpression.match(nameGetter);
    }

    public static Optional<Boolean> getIsLeftInclusive(FeelExpression feelExpression) {
        return feelExpression.match(isLeftInclusiveGetter);
    }

    public static Optional<FeelExpression> getLowerBound(FeelExpression feelExpression) {
        return feelExpression.match(lowerBoundGetter);
    }

    public static Optional<FeelExpression> getUpperBound(FeelExpression feelExpression) {
        return feelExpression.match(upperBoundGetter);
    }

    public static Optional<Boolean> getIsRightInclusive(FeelExpression feelExpression) {
        return feelExpression.match(isRightInclusiveGetter);
    }

    public static Optional<Operator> getOperator(FeelExpression feelExpression) {
        return feelExpression.match(operatorGetter);
    }

    public static Optional<FeelExpression> getExpression(FeelExpression feelExpression) {
        return feelExpression.match(expressionGetter);
    }

    public static Optional<FeelExpression> getLeft(FeelExpression feelExpression) {
        return feelExpression.match(leftGetter);
    }

    public static Optional<FeelExpression> getRight(FeelExpression feelExpression) {
        return feelExpression.match(rightGetter);
    }

    public static Optional<FeelExpression> getHead(FeelExpression feelExpression) {
        return feelExpression.match(headGetter);
    }

    public static Optional<FeelExpression> getTail(FeelExpression feelExpression) {
        return feelExpression.match(tailGetter);
    }

    static {
        aBooleanGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.of(aBoolean), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        dateTimeGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.of(dateTime), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        aDoubleGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.of(aDouble), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        aIntegerGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.of(aInteger), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        stringGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.of(string), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        nameGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.of(name), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        isLeftInclusiveGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(isLeftInclusive), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        lowerBoundGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(lowerBound), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        upperBoundGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(upperBound), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        isRightInclusiveGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(isRightInclusive), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        operatorGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.of(operator), (left, operator, right) -> Optional.of(operator), (head, tail) -> Optional.empty());
        expressionGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.of(expression), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.empty());
        leftGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.of(left), (head, tail) -> Optional.empty());
        rightGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.of(right), (head, tail) -> Optional.empty());
        headGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.of(head));
        tailGetter = FeelExpressions.cases(() -> Optional.empty(), () -> Optional.empty(), aBoolean -> Optional.empty(), dateTime -> Optional.empty(), aDouble -> Optional.empty(), aInteger -> Optional.empty(), string -> Optional.empty(), name -> Optional.empty(), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), (operator, expression) -> Optional.empty(), (left, operator, right) -> Optional.empty(), (head, tail) -> Optional.of(tail));
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<R> {
            private final FeelExpression _feelExpression;
            private final Supplier<R> Empty;
            private final Supplier<R> Null;
            private final Function<Boolean, R> BooleanLiteral;
            private final Function<LocalDateTime, R> DateLiteral;
            private final Function<Double, R> DoubleLiteral;
            private final Function<Integer, R> IntegerLiteral;
            private final Function<String, R> StringLiteral;
            private final Function<String, R> VariableLiteral;
            private final RangeExpressionMapper<R> RangeExpression;
            private final UnaryExpressionMapper<R> UnaryExpression;
            private final BinaryExpressionMapper<R> BinaryExpression;
            private final DisjunctionExpressionMapper<R> DisjunctionExpression;

            PartialMatcher(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2, UnaryExpressionMapper<R> UnaryExpression2, BinaryExpressionMapper<R> BinaryExpression2, DisjunctionExpressionMapper<R> DisjunctionExpression2) {
                this._feelExpression = _feelExpression;
                this.Empty = Empty2;
                this.Null = Null2;
                this.BooleanLiteral = BooleanLiteral2;
                this.DateLiteral = DateLiteral2;
                this.DoubleLiteral = DoubleLiteral2;
                this.IntegerLiteral = IntegerLiteral2;
                this.StringLiteral = StringLiteral2;
                this.VariableLiteral = VariableLiteral2;
                this.RangeExpression = RangeExpression2;
                this.UnaryExpression = UnaryExpression2;
                this.BinaryExpression = BinaryExpression2;
                this.DisjunctionExpression = DisjunctionExpression2;
            }

            public final R otherwise(Supplier<R> otherwise) {
                FeelExpression.Cases<R> cases = FeelExpressions.cases(this.Empty != null ? this.Empty : () -> otherwise.get(), this.Null != null ? this.Null : () -> otherwise.get(), this.BooleanLiteral != null ? this.BooleanLiteral : aBoolean -> otherwise.get(), this.DateLiteral != null ? this.DateLiteral : dateTime -> otherwise.get(), this.DoubleLiteral != null ? this.DoubleLiteral : aDouble -> otherwise.get(), this.IntegerLiteral != null ? this.IntegerLiteral : aInteger -> otherwise.get(), this.StringLiteral != null ? this.StringLiteral : string -> otherwise.get(), this.VariableLiteral != null ? this.VariableLiteral : name -> otherwise.get(), this.RangeExpression != null ? this.RangeExpression : (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> otherwise.get(), this.UnaryExpression != null ? this.UnaryExpression : (operator, expression) -> otherwise.get(), this.BinaryExpression != null ? this.BinaryExpression : (left, operator, right) -> otherwise.get(), this.DisjunctionExpression != null ? this.DisjunctionExpression : (head, tail) -> otherwise.get());
                return this._feelExpression.match(cases);
            }

            public final R otherwise_(R r) {
                return (R)this.otherwise(() -> r);
            }

            public final Optional<R> otherwiseEmpty() {
                FeelExpression.Cases<Optional> cases = FeelExpressions.cases(this.Empty != null ? () -> Optional.of(this.Empty.get()) : () -> Optional.empty(), this.Null != null ? () -> Optional.of(this.Null.get()) : () -> Optional.empty(), this.BooleanLiteral != null ? aBoolean -> Optional.of(this.BooleanLiteral.apply((Boolean)aBoolean)) : aBoolean -> Optional.empty(), this.DateLiteral != null ? dateTime -> Optional.of(this.DateLiteral.apply((LocalDateTime)dateTime)) : dateTime -> Optional.empty(), this.DoubleLiteral != null ? aDouble -> Optional.of(this.DoubleLiteral.apply((Double)aDouble)) : aDouble -> Optional.empty(), this.IntegerLiteral != null ? aInteger -> Optional.of(this.IntegerLiteral.apply((Integer)aInteger)) : aInteger -> Optional.empty(), this.StringLiteral != null ? string -> Optional.of(this.StringLiteral.apply((String)string)) : string -> Optional.empty(), this.VariableLiteral != null ? name -> Optional.of(this.VariableLiteral.apply((String)name)) : name -> Optional.empty(), this.RangeExpression != null ? (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(this.RangeExpression.RangeExpression(isLeftInclusive, lowerBound, upperBound, isRightInclusive)) : (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(), this.UnaryExpression != null ? (operator, expression) -> Optional.of(this.UnaryExpression.UnaryExpression(operator, expression)) : (operator, expression) -> Optional.empty(), this.BinaryExpression != null ? (left, operator, right) -> Optional.of(this.BinaryExpression.BinaryExpression(left, operator, right)) : (left, operator, right) -> Optional.empty(), this.DisjunctionExpression != null ? (head, tail) -> Optional.of(this.DisjunctionExpression.DisjunctionExpression(head, tail)) : (head, tail) -> Optional.empty());
                return this._feelExpression.match(cases);
            }
        }

        public static class PartialMatcher_DisjunctionExpression<R>
        extends PartialMatcher<R> {
            PartialMatcher_DisjunctionExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2, UnaryExpressionMapper<R> UnaryExpression2, BinaryExpressionMapper<R> BinaryExpression2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, RangeExpression2, UnaryExpression2, BinaryExpression2, null);
            }

            public final PartialMatcher<R> DisjunctionExpression(DisjunctionExpressionMapper<R> DisjunctionExpression2) {
                return new PartialMatcher(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, this.RangeExpression, this.UnaryExpression, this.BinaryExpression, DisjunctionExpression2);
            }

            public final PartialMatcher<R> DisjunctionExpression_(R r) {
                return this.DisjunctionExpression((head, tail) -> r);
            }
        }

        public static class PartialMatcher_BinaryExpression<R>
        extends PartialMatcher_DisjunctionExpression<R> {
            PartialMatcher_BinaryExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2, UnaryExpressionMapper<R> UnaryExpression2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, RangeExpression2, UnaryExpression2, null);
            }

            public final PartialMatcher_DisjunctionExpression<R> BinaryExpression(BinaryExpressionMapper<R> BinaryExpression2) {
                return new PartialMatcher_DisjunctionExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, this.RangeExpression, this.UnaryExpression, BinaryExpression2);
            }

            public final PartialMatcher_DisjunctionExpression<R> BinaryExpression_(R r) {
                return this.BinaryExpression((left, operator, right) -> r);
            }
        }

        public static class PartialMatcher_UnaryExpression<R>
        extends PartialMatcher_BinaryExpression<R> {
            PartialMatcher_UnaryExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, RangeExpression2, null);
            }

            public final PartialMatcher_BinaryExpression<R> UnaryExpression(UnaryExpressionMapper<R> UnaryExpression2) {
                return new PartialMatcher_BinaryExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, this.RangeExpression, UnaryExpression2);
            }

            public final PartialMatcher_BinaryExpression<R> UnaryExpression_(R r) {
                return this.UnaryExpression((operator, expression) -> r);
            }
        }

        public static class PartialMatcher_RangeExpression<R>
        extends PartialMatcher_UnaryExpression<R> {
            PartialMatcher_RangeExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, null);
            }

            public final PartialMatcher_UnaryExpression<R> RangeExpression(RangeExpressionMapper<R> RangeExpression2) {
                return new PartialMatcher_UnaryExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, RangeExpression2);
            }

            public final PartialMatcher_UnaryExpression<R> RangeExpression_(R r) {
                return this.RangeExpression((isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> r);
            }
        }

        public static class PartialMatcher_VariableLiteral<R>
        extends PartialMatcher_RangeExpression<R> {
            PartialMatcher_VariableLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, null);
            }

            public final PartialMatcher_RangeExpression<R> VariableLiteral(Function<String, R> VariableLiteral2) {
                return new PartialMatcher_RangeExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, VariableLiteral2);
            }

            public final PartialMatcher_RangeExpression<R> VariableLiteral_(R r) {
                return this.VariableLiteral(name -> r);
            }
        }

        public static class PartialMatcher_StringLiteral<R>
        extends PartialMatcher_VariableLiteral<R> {
            PartialMatcher_StringLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, null);
            }

            public final PartialMatcher_VariableLiteral<R> StringLiteral(Function<String, R> StringLiteral2) {
                return new PartialMatcher_VariableLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, StringLiteral2);
            }

            public final PartialMatcher_VariableLiteral<R> StringLiteral_(R r) {
                return this.StringLiteral(string -> r);
            }
        }

        public static class PartialMatcher_IntegerLiteral<R>
        extends PartialMatcher_StringLiteral<R> {
            PartialMatcher_IntegerLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, null);
            }

            public final PartialMatcher_StringLiteral<R> IntegerLiteral(Function<Integer, R> IntegerLiteral2) {
                return new PartialMatcher_StringLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, IntegerLiteral2);
            }

            public final PartialMatcher_StringLiteral<R> IntegerLiteral_(R r) {
                return this.IntegerLiteral(aInteger -> r);
            }
        }

        public static class PartialMatcher_DoubleLiteral<R>
        extends PartialMatcher_IntegerLiteral<R> {
            PartialMatcher_DoubleLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, null);
            }

            public final PartialMatcher_IntegerLiteral<R> DoubleLiteral(Function<Double, R> DoubleLiteral2) {
                return new PartialMatcher_IntegerLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, DoubleLiteral2);
            }

            public final PartialMatcher_IntegerLiteral<R> DoubleLiteral_(R r) {
                return this.DoubleLiteral(aDouble -> r);
            }
        }

        public static class PartialMatcher_DateLiteral<R>
        extends PartialMatcher_DoubleLiteral<R> {
            PartialMatcher_DateLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, null);
            }

            public final PartialMatcher_DoubleLiteral<R> DateLiteral(Function<LocalDateTime, R> DateLiteral2) {
                return new PartialMatcher_DoubleLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, DateLiteral2);
            }

            public final PartialMatcher_DoubleLiteral<R> DateLiteral_(R r) {
                return this.DateLiteral(dateTime -> r);
            }
        }

        public static class PartialMatcher_BooleanLiteral<R>
        extends PartialMatcher_DateLiteral<R> {
            PartialMatcher_BooleanLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2) {
                super(_feelExpression, Empty2, Null2, null);
            }

            public final PartialMatcher_DateLiteral<R> BooleanLiteral(Function<Boolean, R> BooleanLiteral2) {
                return new PartialMatcher_DateLiteral(this._feelExpression, this.Empty, this.Null, BooleanLiteral2);
            }

            public final PartialMatcher_DateLiteral<R> BooleanLiteral_(R r) {
                return this.BooleanLiteral(aBoolean -> r);
            }
        }

        public static final class TotalMatcher_DisjunctionExpression<R>
        extends PartialMatcher<R> {
            TotalMatcher_DisjunctionExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2, UnaryExpressionMapper<R> UnaryExpression2, BinaryExpressionMapper<R> BinaryExpression2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, RangeExpression2, UnaryExpression2, BinaryExpression2, null);
            }

            public final R DisjunctionExpression(DisjunctionExpressionMapper<R> DisjunctionExpression2) {
                FeelExpression.Cases cases = FeelExpressions.cases(this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, this.RangeExpression, this.UnaryExpression, this.BinaryExpression, DisjunctionExpression2);
                return this._feelExpression.match(cases);
            }

            public final R DisjunctionExpression_(R r) {
                return (R)this.DisjunctionExpression((head, tail) -> r);
            }
        }

        public static final class TotalMatcher_BinaryExpression<R>
        extends PartialMatcher_DisjunctionExpression<R> {
            TotalMatcher_BinaryExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2, UnaryExpressionMapper<R> UnaryExpression2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, RangeExpression2, UnaryExpression2, null);
            }

            public final TotalMatcher_DisjunctionExpression<R> BinaryExpression(BinaryExpressionMapper<R> BinaryExpression2) {
                return new TotalMatcher_DisjunctionExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, this.RangeExpression, this.UnaryExpression, BinaryExpression2);
            }

            public final TotalMatcher_DisjunctionExpression<R> BinaryExpression_(R r) {
                return this.BinaryExpression((left, operator, right) -> r);
            }
        }

        public static final class TotalMatcher_UnaryExpression<R>
        extends PartialMatcher_BinaryExpression<R> {
            TotalMatcher_UnaryExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, RangeExpression2, null);
            }

            public final TotalMatcher_BinaryExpression<R> UnaryExpression(UnaryExpressionMapper<R> UnaryExpression2) {
                return new TotalMatcher_BinaryExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, this.RangeExpression, UnaryExpression2);
            }

            public final TotalMatcher_BinaryExpression<R> UnaryExpression_(R r) {
                return this.UnaryExpression((operator, expression) -> r);
            }
        }

        public static final class TotalMatcher_RangeExpression<R>
        extends PartialMatcher_UnaryExpression<R> {
            TotalMatcher_RangeExpression(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, VariableLiteral2, null);
            }

            public final TotalMatcher_UnaryExpression<R> RangeExpression(RangeExpressionMapper<R> RangeExpression2) {
                return new TotalMatcher_UnaryExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, this.VariableLiteral, RangeExpression2);
            }

            public final TotalMatcher_UnaryExpression<R> RangeExpression_(R r) {
                return this.RangeExpression((isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> r);
            }
        }

        public static final class TotalMatcher_VariableLiteral<R>
        extends PartialMatcher_RangeExpression<R> {
            TotalMatcher_VariableLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, StringLiteral2, null);
            }

            public final TotalMatcher_RangeExpression<R> VariableLiteral(Function<String, R> VariableLiteral2) {
                return new TotalMatcher_RangeExpression(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, this.StringLiteral, VariableLiteral2);
            }

            public final TotalMatcher_RangeExpression<R> VariableLiteral_(R r) {
                return this.VariableLiteral(name -> r);
            }
        }

        public static final class TotalMatcher_StringLiteral<R>
        extends PartialMatcher_VariableLiteral<R> {
            TotalMatcher_StringLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, IntegerLiteral2, null);
            }

            public final TotalMatcher_VariableLiteral<R> StringLiteral(Function<String, R> StringLiteral2) {
                return new TotalMatcher_VariableLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, this.IntegerLiteral, StringLiteral2);
            }

            public final TotalMatcher_VariableLiteral<R> StringLiteral_(R r) {
                return this.StringLiteral(string -> r);
            }
        }

        public static final class TotalMatcher_IntegerLiteral<R>
        extends PartialMatcher_StringLiteral<R> {
            TotalMatcher_IntegerLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, DoubleLiteral2, null);
            }

            public final TotalMatcher_StringLiteral<R> IntegerLiteral(Function<Integer, R> IntegerLiteral2) {
                return new TotalMatcher_StringLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, this.DoubleLiteral, IntegerLiteral2);
            }

            public final TotalMatcher_StringLiteral<R> IntegerLiteral_(R r) {
                return this.IntegerLiteral(aInteger -> r);
            }
        }

        public static final class TotalMatcher_DoubleLiteral<R>
        extends PartialMatcher_IntegerLiteral<R> {
            TotalMatcher_DoubleLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, DateLiteral2, null);
            }

            public final TotalMatcher_IntegerLiteral<R> DoubleLiteral(Function<Double, R> DoubleLiteral2) {
                return new TotalMatcher_IntegerLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, this.DateLiteral, DoubleLiteral2);
            }

            public final TotalMatcher_IntegerLiteral<R> DoubleLiteral_(R r) {
                return this.DoubleLiteral(aDouble -> r);
            }
        }

        public static final class TotalMatcher_DateLiteral<R>
        extends PartialMatcher_DoubleLiteral<R> {
            TotalMatcher_DateLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2) {
                super(_feelExpression, Empty2, Null2, BooleanLiteral2, null);
            }

            public final TotalMatcher_DoubleLiteral<R> DateLiteral(Function<LocalDateTime, R> DateLiteral2) {
                return new TotalMatcher_DoubleLiteral(this._feelExpression, this.Empty, this.Null, this.BooleanLiteral, DateLiteral2);
            }

            public final TotalMatcher_DoubleLiteral<R> DateLiteral_(R r) {
                return this.DateLiteral(dateTime -> r);
            }
        }

        public static final class TotalMatcher_BooleanLiteral<R>
        extends PartialMatcher_DateLiteral<R> {
            TotalMatcher_BooleanLiteral(FeelExpression _feelExpression, Supplier<R> Empty2, Supplier<R> Null2) {
                super(_feelExpression, Empty2, Null2, null);
            }

            public final TotalMatcher_DateLiteral<R> BooleanLiteral(Function<Boolean, R> BooleanLiteral2) {
                return new TotalMatcher_DateLiteral(this._feelExpression, this.Empty, this.Null, BooleanLiteral2);
            }

            public final TotalMatcher_DateLiteral<R> BooleanLiteral_(R r) {
                return this.BooleanLiteral(aBoolean -> r);
            }
        }

        public static final class TotalMatcher_Null<R>
        extends PartialMatcher_BooleanLiteral<R> {
            TotalMatcher_Null(FeelExpression _feelExpression, Supplier<R> Empty2) {
                super(_feelExpression, Empty2, null);
            }

            public final TotalMatcher_BooleanLiteral<R> Null(Supplier<R> Null2) {
                return new TotalMatcher_BooleanLiteral(this._feelExpression, this.Empty, Null2);
            }

            public final TotalMatcher_BooleanLiteral<R> Null_(R r) {
                return this.Null(() -> r);
            }
        }

        public static final class TotalMatcher_Empty {
            private final FeelExpression _feelExpression;

            TotalMatcher_Empty(FeelExpression _feelExpression) {
                this._feelExpression = _feelExpression;
            }

            public final <R> TotalMatcher_Null<R> Empty(Supplier<R> Empty2) {
                return new TotalMatcher_Null<R>(this._feelExpression, Empty2);
            }

            public final <R> TotalMatcher_Null<R> Empty_(R r) {
                return this.Empty(() -> r);
            }

            public final <R> PartialMatcher_BooleanLiteral<R> Null(Supplier<R> Null2) {
                return new PartialMatcher_BooleanLiteral<R>(this._feelExpression, null, Null2);
            }

            public final <R> PartialMatcher_BooleanLiteral<R> Null_(R r) {
                return this.Null(() -> r);
            }

            public final <R> PartialMatcher_DateLiteral<R> BooleanLiteral(Function<Boolean, R> BooleanLiteral2) {
                return new PartialMatcher_DateLiteral<R>(this._feelExpression, null, null, BooleanLiteral2);
            }

            public final <R> PartialMatcher_DateLiteral<R> BooleanLiteral_(R r) {
                return this.BooleanLiteral(aBoolean -> r);
            }

            public final <R> PartialMatcher_DoubleLiteral<R> DateLiteral(Function<LocalDateTime, R> DateLiteral2) {
                return new PartialMatcher_DoubleLiteral<R>(this._feelExpression, null, null, null, DateLiteral2);
            }

            public final <R> PartialMatcher_DoubleLiteral<R> DateLiteral_(R r) {
                return this.DateLiteral(dateTime -> r);
            }

            public final <R> PartialMatcher_IntegerLiteral<R> DoubleLiteral(Function<Double, R> DoubleLiteral2) {
                return new PartialMatcher_IntegerLiteral<R>(this._feelExpression, null, null, null, null, DoubleLiteral2);
            }

            public final <R> PartialMatcher_IntegerLiteral<R> DoubleLiteral_(R r) {
                return this.DoubleLiteral(aDouble -> r);
            }

            public final <R> PartialMatcher_StringLiteral<R> IntegerLiteral(Function<Integer, R> IntegerLiteral2) {
                return new PartialMatcher_StringLiteral<R>(this._feelExpression, null, null, null, null, null, IntegerLiteral2);
            }

            public final <R> PartialMatcher_StringLiteral<R> IntegerLiteral_(R r) {
                return this.IntegerLiteral(aInteger -> r);
            }

            public final <R> PartialMatcher_VariableLiteral<R> StringLiteral(Function<String, R> StringLiteral2) {
                return new PartialMatcher_VariableLiteral<R>(this._feelExpression, null, null, null, null, null, null, StringLiteral2);
            }

            public final <R> PartialMatcher_VariableLiteral<R> StringLiteral_(R r) {
                return this.StringLiteral(string -> r);
            }

            public final <R> PartialMatcher_RangeExpression<R> VariableLiteral(Function<String, R> VariableLiteral2) {
                return new PartialMatcher_RangeExpression<R>(this._feelExpression, null, null, null, null, null, null, null, VariableLiteral2);
            }

            public final <R> PartialMatcher_RangeExpression<R> VariableLiteral_(R r) {
                return this.VariableLiteral(name -> r);
            }

            public final <R> PartialMatcher_UnaryExpression<R> RangeExpression(RangeExpressionMapper<R> RangeExpression2) {
                return new PartialMatcher_UnaryExpression<R>(this._feelExpression, null, null, null, null, null, null, null, null, RangeExpression2);
            }

            public final <R> PartialMatcher_UnaryExpression<R> RangeExpression_(R r) {
                return this.RangeExpression((isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> r);
            }

            public final <R> PartialMatcher_BinaryExpression<R> UnaryExpression(UnaryExpressionMapper<R> UnaryExpression2) {
                return new PartialMatcher_BinaryExpression<R>(this._feelExpression, null, null, null, null, null, null, null, null, null, UnaryExpression2);
            }

            public final <R> PartialMatcher_BinaryExpression<R> UnaryExpression_(R r) {
                return this.UnaryExpression((operator, expression) -> r);
            }

            public final <R> PartialMatcher_DisjunctionExpression<R> BinaryExpression(BinaryExpressionMapper<R> BinaryExpression2) {
                return new PartialMatcher_DisjunctionExpression<R>(this._feelExpression, null, null, null, null, null, null, null, null, null, null, BinaryExpression2);
            }

            public final <R> PartialMatcher_DisjunctionExpression<R> BinaryExpression_(R r) {
                return this.BinaryExpression((left, operator, right) -> r);
            }

            public final <R> PartialMatcher<R> DisjunctionExpression(DisjunctionExpressionMapper<R> DisjunctionExpression2) {
                return new PartialMatcher<R>(this._feelExpression, null, null, null, null, null, null, null, null, null, null, null, DisjunctionExpression2);
            }

            public final <R> PartialMatcher<R> DisjunctionExpression_(R r) {
                return this.DisjunctionExpression((head, tail) -> r);
            }
        }
    }

    private static final class DisjunctionExpression
    extends FeelExpression {
        private final FeelExpression head;
        private final FeelExpression tail;

        DisjunctionExpression(FeelExpression head, FeelExpression tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.DisjunctionExpression(this.head, this.tail);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> this.head.equals(head) && this.tail.equals(tail))) != false;
        }

        @Override
        public int hashCode() {
            return (71 + this.head.hashCode()) * 71 + this.tail.hashCode();
        }

        @Override
        public String toString() {
            return "DisjunctionExpression(" + this.head + ", " + this.tail + ")";
        }
    }

    private static final class BinaryExpression
    extends FeelExpression {
        private final FeelExpression left;
        private final Operator operator;
        private final FeelExpression right;

        BinaryExpression(FeelExpression left, Operator operator, FeelExpression right) {
            this.left = left;
            this.operator = operator;
            this.right = right;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.BinaryExpression(this.left, this.operator, this.right);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> this.left.equals(left) && this.operator == operator && this.right.equals(right), (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return ((67 + this.left.hashCode()) * 67 + this.operator.hashCode()) * 67 + this.right.hashCode();
        }

        @Override
        public String toString() {
            return "BinaryExpression(" + this.left + ", " + this.operator + ", " + this.right + ")";
        }
    }

    private static final class UnaryExpression
    extends FeelExpression {
        private final Operator operator;
        private final FeelExpression expression;

        UnaryExpression(Operator operator, FeelExpression expression) {
            this.operator = operator;
            this.expression = expression;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.UnaryExpression(this.operator, this.expression);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> this.operator == operator && this.expression.equals(expression), (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return (61 + this.operator.hashCode()) * 61 + this.expression.hashCode();
        }

        @Override
        public String toString() {
            return "UnaryExpression(" + this.operator + ", " + this.expression + ")";
        }
    }

    private static final class RangeExpression
    extends FeelExpression {
        private final boolean isLeftInclusive;
        private final FeelExpression lowerBound;
        private final FeelExpression upperBound;
        private final boolean isRightInclusive;

        RangeExpression(boolean isLeftInclusive, FeelExpression lowerBound, FeelExpression upperBound, boolean isRightInclusive) {
            this.isLeftInclusive = isLeftInclusive;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.isRightInclusive = isRightInclusive;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.RangeExpression(this.isLeftInclusive, this.lowerBound, this.upperBound, this.isRightInclusive);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> this.isLeftInclusive == isLeftInclusive && this.lowerBound.equals(lowerBound) && this.upperBound.equals(upperBound) && this.isRightInclusive == isRightInclusive, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return (((59 + Boolean.hashCode(this.isLeftInclusive)) * 59 + this.lowerBound.hashCode()) * 59 + this.upperBound.hashCode()) * 59 + Boolean.hashCode(this.isRightInclusive);
        }

        @Override
        public String toString() {
            return "RangeExpression(" + this.isLeftInclusive + ", " + this.lowerBound + ", " + this.upperBound + ", " + this.isRightInclusive + ")";
        }
    }

    private static final class VariableLiteral
    extends FeelExpression {
        private final String name;

        VariableLiteral(String name) {
            this.name = name;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.VariableLiteral(this.name);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> this.name.equals(name), (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 53 + this.name.hashCode();
        }

        @Override
        public String toString() {
            return "VariableLiteral(" + this.name + ")";
        }
    }

    private static final class StringLiteral
    extends FeelExpression {
        private final String string;

        StringLiteral(String string) {
            this.string = string;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.StringLiteral(this.string);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> this.string.equals(string), name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 47 + this.string.hashCode();
        }

        @Override
        public String toString() {
            return "StringLiteral(" + this.string + ")";
        }
    }

    private static final class IntegerLiteral
    extends FeelExpression {
        private final Integer aInteger;

        IntegerLiteral(Integer aInteger) {
            this.aInteger = aInteger;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.IntegerLiteral(this.aInteger);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> this.aInteger.equals(aInteger), string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 43 + this.aInteger.hashCode();
        }

        @Override
        public String toString() {
            return "IntegerLiteral(" + this.aInteger + ")";
        }
    }

    private static final class DoubleLiteral
    extends FeelExpression {
        private final Double aDouble;

        DoubleLiteral(Double aDouble) {
            this.aDouble = aDouble;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.DoubleLiteral(this.aDouble);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> false, aDouble -> this.aDouble.equals(aDouble), aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 41 + this.aDouble.hashCode();
        }

        @Override
        public String toString() {
            return "DoubleLiteral(" + this.aDouble + ")";
        }
    }

    private static final class DateLiteral
    extends FeelExpression {
        private final LocalDateTime dateTime;

        DateLiteral(LocalDateTime dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.DateLiteral(this.dateTime);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> false, dateTime -> this.dateTime.equals(dateTime), aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 37 + this.dateTime.hashCode();
        }

        @Override
        public String toString() {
            return "DateLiteral(" + this.dateTime + ")";
        }
    }

    private static final class BooleanLiteral
    extends FeelExpression {
        private final Boolean aBoolean;

        BooleanLiteral(Boolean aBoolean) {
            this.aBoolean = aBoolean;
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.BooleanLiteral(this.aBoolean);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> false, aBoolean -> this.aBoolean.equals(aBoolean), dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 31 + this.aBoolean.hashCode();
        }

        @Override
        public String toString() {
            return "BooleanLiteral(" + this.aBoolean + ")";
        }
    }

    private static final class Null
    extends FeelExpression {
        Null() {
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.Null();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> false, () -> true, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 29;
        }

        @Override
        public String toString() {
            return "Null()";
        }
    }

    private static final class Empty
    extends FeelExpression {
        Empty() {
        }

        @Override
        public <R> R match(FeelExpression.Cases<R> cases) {
            return cases.Empty();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FeelExpression && ((FeelExpression)obj).match(FeelExpressions.cases(() -> true, () -> false, aBoolean -> false, dateTime -> false, aDouble -> false, aInteger -> false, string -> false, name -> false, (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false, (operator, expression) -> false, (left, operator, right) -> false, (head, tail) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 23;
        }

        @Override
        public String toString() {
            return "Empty()";
        }
    }

    private static final class LambdaCases<R>
    implements FeelExpression.Cases<R> {
        private final Supplier<R> Empty;
        private final Supplier<R> Null;
        private final Function<Boolean, R> BooleanLiteral;
        private final Function<LocalDateTime, R> DateLiteral;
        private final Function<Double, R> DoubleLiteral;
        private final Function<Integer, R> IntegerLiteral;
        private final Function<String, R> StringLiteral;
        private final Function<String, R> VariableLiteral;
        private final RangeExpressionMapper<R> RangeExpression;
        private final UnaryExpressionMapper<R> UnaryExpression;
        private final BinaryExpressionMapper<R> BinaryExpression;
        private final DisjunctionExpressionMapper<R> DisjunctionExpression;

        LambdaCases(Supplier<R> Empty2, Supplier<R> Null2, Function<Boolean, R> BooleanLiteral2, Function<LocalDateTime, R> DateLiteral2, Function<Double, R> DoubleLiteral2, Function<Integer, R> IntegerLiteral2, Function<String, R> StringLiteral2, Function<String, R> VariableLiteral2, RangeExpressionMapper<R> RangeExpression2, UnaryExpressionMapper<R> UnaryExpression2, BinaryExpressionMapper<R> BinaryExpression2, DisjunctionExpressionMapper<R> DisjunctionExpression2) {
            this.Empty = Empty2;
            this.Null = Null2;
            this.BooleanLiteral = BooleanLiteral2;
            this.DateLiteral = DateLiteral2;
            this.DoubleLiteral = DoubleLiteral2;
            this.IntegerLiteral = IntegerLiteral2;
            this.StringLiteral = StringLiteral2;
            this.VariableLiteral = VariableLiteral2;
            this.RangeExpression = RangeExpression2;
            this.UnaryExpression = UnaryExpression2;
            this.BinaryExpression = BinaryExpression2;
            this.DisjunctionExpression = DisjunctionExpression2;
        }

        @Override
        public R Empty() {
            return this.Empty.get();
        }

        @Override
        public R Null() {
            return this.Null.get();
        }

        @Override
        public R BooleanLiteral(Boolean aBoolean) {
            return this.BooleanLiteral.apply(aBoolean);
        }

        @Override
        public R DateLiteral(LocalDateTime dateTime) {
            return this.DateLiteral.apply(dateTime);
        }

        @Override
        public R DoubleLiteral(Double aDouble) {
            return this.DoubleLiteral.apply(aDouble);
        }

        @Override
        public R IntegerLiteral(Integer aInteger) {
            return this.IntegerLiteral.apply(aInteger);
        }

        @Override
        public R StringLiteral(String string) {
            return this.StringLiteral.apply(string);
        }

        @Override
        public R VariableLiteral(String name) {
            return this.VariableLiteral.apply(name);
        }

        @Override
        public R RangeExpression(boolean isLeftInclusive, FeelExpression lowerBound, FeelExpression upperBound, boolean isRightInclusive) {
            return this.RangeExpression.RangeExpression(isLeftInclusive, lowerBound, upperBound, isRightInclusive);
        }

        @Override
        public R UnaryExpression(Operator operator, FeelExpression expression) {
            return this.UnaryExpression.UnaryExpression(operator, expression);
        }

        @Override
        public R BinaryExpression(FeelExpression left, Operator operator, FeelExpression right) {
            return this.BinaryExpression.BinaryExpression(left, operator, right);
        }

        @Override
        public R DisjunctionExpression(FeelExpression head, FeelExpression tail) {
            return this.DisjunctionExpression.DisjunctionExpression(head, tail);
        }
    }

    public static interface DisjunctionExpressionMapper<R> {
        public R DisjunctionExpression(FeelExpression var1, FeelExpression var2);
    }

    public static interface BinaryExpressionMapper<R> {
        public R BinaryExpression(FeelExpression var1, Operator var2, FeelExpression var3);
    }

    public static interface UnaryExpressionMapper<R> {
        public R UnaryExpression(Operator var1, FeelExpression var2);
    }

    public static interface RangeExpressionMapper<R> {
        public R RangeExpression(boolean var1, FeelExpression var2, FeelExpression var3, boolean var4);
    }
}

