/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.feel;

import de.redsix.dmncheck.feel.ExpressionTypes;
import java.util.Arrays;
import org.camunda.bpm.model.dmn.instance.ItemDefinition;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.derive4j.Data;

@Data
public abstract class ExpressionType {
    public abstract <R> R match(Cases<R> var1);

    public abstract int hashCode();

    public abstract boolean equals(@Nullable Object var1);

    public abstract String toString();

    public static boolean isNumeric(ExpressionType givenType) {
        return !ExpressionTypes.TOP().equals(givenType) && Arrays.asList(ExpressionTypes.INTEGER(), ExpressionTypes.LONG(), ExpressionTypes.DOUBLE()).contains(givenType);
    }

    public boolean isSubtypeOf(ExpressionType supertype) {
        return this.reflexivity(this, supertype) || this.TOPisTopElement(supertype) || this.INTEGERsubtypeOfLONG(this, supertype) || this.INTEGERsubtypeOfDOUBLE(this, supertype);
    }

    private boolean reflexivity(ExpressionType subtype, ExpressionType supertype) {
        return subtype.equals(supertype);
    }

    private boolean TOPisTopElement(ExpressionType supertype) {
        return ExpressionTypes.TOP().equals(supertype);
    }

    private boolean INTEGERsubtypeOfLONG(ExpressionType subtype, ExpressionType supertype) {
        return ExpressionTypes.INTEGER().equals(subtype) && ExpressionTypes.LONG().equals(supertype);
    }

    private boolean INTEGERsubtypeOfDOUBLE(ExpressionType subtype, ExpressionType supertype) {
        return ExpressionTypes.INTEGER().equals(subtype) && ExpressionTypes.DOUBLE().equals(supertype);
    }

    public static interface Cases<R> {
        public R TOP();

        public R STRING();

        public R BOOLEAN();

        public R INTEGER();

        public R LONG();

        public R DOUBLE();

        public R DATE();

        public R ENUM(String var1);

        public R ITEMDEFINITION(ItemDefinition var1);
    }
}

