package de.redsix.dmncheck.feel;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

final class FeelExpressions {
  private static FeelExpression Empty;

  private static FeelExpression Null;

  private static final FeelExpression.Cases<Optional<Boolean>> aBooleanGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.of(aBoolean),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<LocalDateTime>> dateTimeGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.of(dateTime),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<Double>> aDoubleGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.of(aDouble),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<Integer>> aIntegerGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.of(aInteger),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<String>> stringGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.of(string),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<String>> nameGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.of(name),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<Boolean>> isLeftInclusiveGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(isLeftInclusive),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<FeelExpression>> lowerBoundGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(lowerBound),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<FeelExpression>> upperBoundGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(upperBound),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<Boolean>> isRightInclusiveGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(isRightInclusive),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<Operator>> operatorGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.of(operator),
  (left, operator, right) -> Optional.of(operator),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<FeelExpression>> expressionGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.of(expression),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<FeelExpression>> leftGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.of(left),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<FeelExpression>> rightGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.of(right),
  (head, tail) -> Optional.empty());

  private static final FeelExpression.Cases<Optional<FeelExpression>> headGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.of(head));

  private static final FeelExpression.Cases<Optional<FeelExpression>> tailGetter = FeelExpressions.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  (aBoolean) -> Optional.empty(),
  (dateTime) -> Optional.empty(),
  (aDouble) -> Optional.empty(),
  (aInteger) -> Optional.empty(),
  (string) -> Optional.empty(),
  (name) -> Optional.empty(),
  (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
  (operator, expression) -> Optional.empty(),
  (left, operator, right) -> Optional.empty(),
  (head, tail) -> Optional.of(tail));

  private FeelExpressions() {
  }

  public static <R> FeelExpression.Cases<R> cases(Supplier<R> Empty, Supplier<R> Null,
      Function<Boolean, R> BooleanLiteral, Function<LocalDateTime, R> DateLiteral,
      Function<Double, R> DoubleLiteral, Function<Integer, R> IntegerLiteral,
      Function<String, R> StringLiteral, Function<String, R> VariableLiteral,
      RangeExpressionMapper<R> RangeExpression, UnaryExpressionMapper<R> UnaryExpression,
      BinaryExpressionMapper<R> BinaryExpression,
      DisjunctionExpressionMapper<R> DisjunctionExpression) {
    return new LambdaCases<>(Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, RangeExpression, UnaryExpression, BinaryExpression, DisjunctionExpression);
  }

  public static FeelExpression Empty() {
    FeelExpression _Empty = Empty;
    if (_Empty == null) {
      Empty = _Empty = new Empty();
    }
    return _Empty;
  }

  public static FeelExpression Null() {
    FeelExpression _Null = Null;
    if (_Null == null) {
      Null = _Null = new Null();
    }
    return _Null;
  }

  public static FeelExpression BooleanLiteral(Boolean aBoolean) {
    return new BooleanLiteral(aBoolean);
  }

  public static FeelExpression DateLiteral(LocalDateTime dateTime) {
    return new DateLiteral(dateTime);
  }

  public static FeelExpression DoubleLiteral(Double aDouble) {
    return new DoubleLiteral(aDouble);
  }

  public static FeelExpression IntegerLiteral(Integer aInteger) {
    return new IntegerLiteral(aInteger);
  }

  public static FeelExpression StringLiteral(String string) {
    return new StringLiteral(string);
  }

  public static FeelExpression VariableLiteral(String name) {
    return new VariableLiteral(name);
  }

  public static FeelExpression RangeExpression(boolean isLeftInclusive, FeelExpression lowerBound,
      FeelExpression upperBound, boolean isRightInclusive) {
    return new RangeExpression(isLeftInclusive, lowerBound, upperBound, isRightInclusive);
  }

  public static FeelExpression UnaryExpression(Operator operator, FeelExpression expression) {
    return new UnaryExpression(operator, expression);
  }

  public static FeelExpression BinaryExpression(FeelExpression left, Operator operator,
      FeelExpression right) {
    return new BinaryExpression(left, operator, right);
  }

  public static FeelExpression DisjunctionExpression(FeelExpression head, FeelExpression tail) {
    return new DisjunctionExpression(head, tail);
  }

  public static CaseOfMatchers.TotalMatcher_Empty caseOf(FeelExpression feelExpression) {
    return new CaseOfMatchers.TotalMatcher_Empty(feelExpression);
  }

  public static Optional<Boolean> getABoolean(FeelExpression feelExpression) {
    return feelExpression.match(aBooleanGetter);
  }

  public static Optional<LocalDateTime> getDateTime(FeelExpression feelExpression) {
    return feelExpression.match(dateTimeGetter);
  }

  public static Optional<Double> getADouble(FeelExpression feelExpression) {
    return feelExpression.match(aDoubleGetter);
  }

  public static Optional<Integer> getAInteger(FeelExpression feelExpression) {
    return feelExpression.match(aIntegerGetter);
  }

  public static Optional<String> getString(FeelExpression feelExpression) {
    return feelExpression.match(stringGetter);
  }

  public static Optional<String> getName(FeelExpression feelExpression) {
    return feelExpression.match(nameGetter);
  }

  public static Optional<Boolean> getIsLeftInclusive(FeelExpression feelExpression) {
    return feelExpression.match(isLeftInclusiveGetter);
  }

  public static Optional<FeelExpression> getLowerBound(FeelExpression feelExpression) {
    return feelExpression.match(lowerBoundGetter);
  }

  public static Optional<FeelExpression> getUpperBound(FeelExpression feelExpression) {
    return feelExpression.match(upperBoundGetter);
  }

  public static Optional<Boolean> getIsRightInclusive(FeelExpression feelExpression) {
    return feelExpression.match(isRightInclusiveGetter);
  }

  public static Optional<Operator> getOperator(FeelExpression feelExpression) {
    return feelExpression.match(operatorGetter);
  }

  public static Optional<FeelExpression> getExpression(FeelExpression feelExpression) {
    return feelExpression.match(expressionGetter);
  }

  public static Optional<FeelExpression> getLeft(FeelExpression feelExpression) {
    return feelExpression.match(leftGetter);
  }

  public static Optional<FeelExpression> getRight(FeelExpression feelExpression) {
    return feelExpression.match(rightGetter);
  }

  public static Optional<FeelExpression> getHead(FeelExpression feelExpression) {
    return feelExpression.match(headGetter);
  }

  public static Optional<FeelExpression> getTail(FeelExpression feelExpression) {
    return feelExpression.match(tailGetter);
  }

  public interface RangeExpressionMapper<R> {
    R RangeExpression(boolean isLeftInclusive, FeelExpression lowerBound, FeelExpression upperBound,
        boolean isRightInclusive);
  }

  public interface UnaryExpressionMapper<R> {
    R UnaryExpression(Operator operator, FeelExpression expression);
  }

  public interface BinaryExpressionMapper<R> {
    R BinaryExpression(FeelExpression left, Operator operator, FeelExpression right);
  }

  public interface DisjunctionExpressionMapper<R> {
    R DisjunctionExpression(FeelExpression head, FeelExpression tail);
  }

  private static final class LambdaCases<R> implements FeelExpression.Cases<R> {
    private final Supplier<R> Empty;

    private final Supplier<R> Null;

    private final Function<Boolean, R> BooleanLiteral;

    private final Function<LocalDateTime, R> DateLiteral;

    private final Function<Double, R> DoubleLiteral;

    private final Function<Integer, R> IntegerLiteral;

    private final Function<String, R> StringLiteral;

    private final Function<String, R> VariableLiteral;

    private final RangeExpressionMapper<R> RangeExpression;

    private final UnaryExpressionMapper<R> UnaryExpression;

    private final BinaryExpressionMapper<R> BinaryExpression;

    private final DisjunctionExpressionMapper<R> DisjunctionExpression;

    LambdaCases(Supplier<R> Empty, Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
        Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
        Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
        Function<String, R> VariableLiteral, RangeExpressionMapper<R> RangeExpression,
        UnaryExpressionMapper<R> UnaryExpression, BinaryExpressionMapper<R> BinaryExpression,
        DisjunctionExpressionMapper<R> DisjunctionExpression) {
      this.Empty = Empty;
      this.Null = Null;
      this.BooleanLiteral = BooleanLiteral;
      this.DateLiteral = DateLiteral;
      this.DoubleLiteral = DoubleLiteral;
      this.IntegerLiteral = IntegerLiteral;
      this.StringLiteral = StringLiteral;
      this.VariableLiteral = VariableLiteral;
      this.RangeExpression = RangeExpression;
      this.UnaryExpression = UnaryExpression;
      this.BinaryExpression = BinaryExpression;
      this.DisjunctionExpression = DisjunctionExpression;
    }

    @Override
    public R Empty() {
      return this.Empty.get();
    }

    @Override
    public R Null() {
      return this.Null.get();
    }

    @Override
    public R BooleanLiteral(Boolean aBoolean) {
      return this.BooleanLiteral.apply(aBoolean);
    }

    @Override
    public R DateLiteral(LocalDateTime dateTime) {
      return this.DateLiteral.apply(dateTime);
    }

    @Override
    public R DoubleLiteral(Double aDouble) {
      return this.DoubleLiteral.apply(aDouble);
    }

    @Override
    public R IntegerLiteral(Integer aInteger) {
      return this.IntegerLiteral.apply(aInteger);
    }

    @Override
    public R StringLiteral(String string) {
      return this.StringLiteral.apply(string);
    }

    @Override
    public R VariableLiteral(String name) {
      return this.VariableLiteral.apply(name);
    }

    @Override
    public R RangeExpression(boolean isLeftInclusive, FeelExpression lowerBound,
        FeelExpression upperBound, boolean isRightInclusive) {
      return this.RangeExpression.RangeExpression(isLeftInclusive, lowerBound, upperBound, isRightInclusive);
    }

    @Override
    public R UnaryExpression(Operator operator, FeelExpression expression) {
      return this.UnaryExpression.UnaryExpression(operator, expression);
    }

    @Override
    public R BinaryExpression(FeelExpression left, Operator operator, FeelExpression right) {
      return this.BinaryExpression.BinaryExpression(left, operator, right);
    }

    @Override
    public R DisjunctionExpression(FeelExpression head, FeelExpression tail) {
      return this.DisjunctionExpression.DisjunctionExpression(head, tail);
    }
  }

  private static final class Empty extends FeelExpression {
    Empty() {
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.Empty();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> true,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 23;
    }

    @Override
    public String toString() {
      return "Empty()";
    }
  }

  private static final class Null extends FeelExpression {
    Null() {
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.Null();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> true,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 29;
    }

    @Override
    public String toString() {
      return "Null()";
    }
  }

  private static final class BooleanLiteral extends FeelExpression {
    private final Boolean aBoolean;

    BooleanLiteral(Boolean aBoolean) {
      this.aBoolean = aBoolean;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.BooleanLiteral(this.aBoolean);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> this.aBoolean.equals(aBoolean),
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 31 + this.aBoolean.hashCode();
    }

    @Override
    public String toString() {
      return "BooleanLiteral(" + this.aBoolean + ")";
    }
  }

  private static final class DateLiteral extends FeelExpression {
    private final LocalDateTime dateTime;

    DateLiteral(LocalDateTime dateTime) {
      this.dateTime = dateTime;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.DateLiteral(this.dateTime);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> this.dateTime.equals(dateTime),
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 37 + this.dateTime.hashCode();
    }

    @Override
    public String toString() {
      return "DateLiteral(" + this.dateTime + ")";
    }
  }

  private static final class DoubleLiteral extends FeelExpression {
    private final Double aDouble;

    DoubleLiteral(Double aDouble) {
      this.aDouble = aDouble;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.DoubleLiteral(this.aDouble);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> this.aDouble.equals(aDouble),
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 41 + this.aDouble.hashCode();
    }

    @Override
    public String toString() {
      return "DoubleLiteral(" + this.aDouble + ")";
    }
  }

  private static final class IntegerLiteral extends FeelExpression {
    private final Integer aInteger;

    IntegerLiteral(Integer aInteger) {
      this.aInteger = aInteger;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.IntegerLiteral(this.aInteger);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> this.aInteger.equals(aInteger),
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 43 + this.aInteger.hashCode();
    }

    @Override
    public String toString() {
      return "IntegerLiteral(" + this.aInteger + ")";
    }
  }

  private static final class StringLiteral extends FeelExpression {
    private final String string;

    StringLiteral(String string) {
      this.string = string;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.StringLiteral(this.string);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> this.string.equals(string),
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 47 + this.string.hashCode();
    }

    @Override
    public String toString() {
      return "StringLiteral(" + this.string + ")";
    }
  }

  private static final class VariableLiteral extends FeelExpression {
    private final String name;

    VariableLiteral(String name) {
      this.name = name;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.VariableLiteral(this.name);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> this.name.equals(name),
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return 53 + this.name.hashCode();
    }

    @Override
    public String toString() {
      return "VariableLiteral(" + this.name + ")";
    }
  }

  private static final class RangeExpression extends FeelExpression {
    private final boolean isLeftInclusive;

    private final FeelExpression lowerBound;

    private final FeelExpression upperBound;

    private final boolean isRightInclusive;

    RangeExpression(boolean isLeftInclusive, FeelExpression lowerBound, FeelExpression upperBound,
        boolean isRightInclusive) {
      this.isLeftInclusive = isLeftInclusive;
      this.lowerBound = lowerBound;
      this.upperBound = upperBound;
      this.isRightInclusive = isRightInclusive;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.RangeExpression(this.isLeftInclusive, this.lowerBound, this.upperBound, this.isRightInclusive);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> (this.isLeftInclusive == isLeftInclusive) && this.lowerBound.equals(lowerBound) && this.upperBound.equals(upperBound) && (this.isRightInclusive == isRightInclusive),
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return (((59 + Boolean.hashCode(this.isLeftInclusive)) * 59 + this.lowerBound.hashCode()) * 59 + this.upperBound.hashCode()) * 59 + Boolean.hashCode(this.isRightInclusive);
    }

    @Override
    public String toString() {
      return "RangeExpression(" + this.isLeftInclusive + ", " + this.lowerBound + ", " + this.upperBound + ", " + this.isRightInclusive + ")";
    }
  }

  private static final class UnaryExpression extends FeelExpression {
    private final Operator operator;

    private final FeelExpression expression;

    UnaryExpression(Operator operator, FeelExpression expression) {
      this.operator = operator;
      this.expression = expression;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.UnaryExpression(this.operator, this.expression);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> (this.operator == operator) && this.expression.equals(expression),
          (left, operator, right) -> false,
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return (61 + this.operator.hashCode()) * 61 + this.expression.hashCode();
    }

    @Override
    public String toString() {
      return "UnaryExpression(" + this.operator + ", " + this.expression + ")";
    }
  }

  private static final class BinaryExpression extends FeelExpression {
    private final FeelExpression left;

    private final Operator operator;

    private final FeelExpression right;

    BinaryExpression(FeelExpression left, Operator operator, FeelExpression right) {
      this.left = left;
      this.operator = operator;
      this.right = right;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.BinaryExpression(this.left, this.operator, this.right);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> this.left.equals(left) && (this.operator == operator) && this.right.equals(right),
          (head, tail) -> false));
    }

    @Override
    public int hashCode() {
      return ((67 + this.left.hashCode()) * 67 + this.operator.hashCode()) * 67 + this.right.hashCode();
    }

    @Override
    public String toString() {
      return "BinaryExpression(" + this.left + ", " + this.operator + ", " + this.right + ")";
    }
  }

  private static final class DisjunctionExpression extends FeelExpression {
    private final FeelExpression head;

    private final FeelExpression tail;

    DisjunctionExpression(FeelExpression head, FeelExpression tail) {
      this.head = head;
      this.tail = tail;
    }

    @Override
    public <R> R match(FeelExpression.Cases<R> cases) {
      return cases.DisjunctionExpression(this.head, this.tail);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof FeelExpression) && ((FeelExpression) obj).match(FeelExpressions.cases(() -> false,
          () -> false,
          (aBoolean) -> false,
          (dateTime) -> false,
          (aDouble) -> false,
          (aInteger) -> false,
          (string) -> false,
          (name) -> false,
          (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> false,
          (operator, expression) -> false,
          (left, operator, right) -> false,
          (head, tail) -> this.head.equals(head) && this.tail.equals(tail)));
    }

    @Override
    public int hashCode() {
      return (71 + this.head.hashCode()) * 71 + this.tail.hashCode();
    }

    @Override
    public String toString() {
      return "DisjunctionExpression(" + this.head + ", " + this.tail + ")";
    }
  }

  public static class CaseOfMatchers {
    private CaseOfMatchers() {
    }

    public static final class TotalMatcher_Empty {
      private final FeelExpression _feelExpression;

      TotalMatcher_Empty(FeelExpression _feelExpression) {
        this._feelExpression = _feelExpression;
      }

      public final <R> TotalMatcher_Null<R> Empty(Supplier<R> Empty) {
        return new TotalMatcher_Null<>(this._feelExpression, Empty);
      }

      public final <R> TotalMatcher_Null<R> Empty_(R r) {
        return this.Empty(() -> r);
      }

      public final <R> PartialMatcher_BooleanLiteral<R> Null(Supplier<R> Null) {
        return new PartialMatcher_BooleanLiteral<>(this._feelExpression, null, Null);
      }

      public final <R> PartialMatcher_BooleanLiteral<R> Null_(R r) {
        return this.Null(() -> r);
      }

      public final <R> PartialMatcher_DateLiteral<R> BooleanLiteral(
          Function<Boolean, R> BooleanLiteral) {
        return new PartialMatcher_DateLiteral<>(this._feelExpression, null, null, BooleanLiteral);
      }

      public final <R> PartialMatcher_DateLiteral<R> BooleanLiteral_(R r) {
        return this.BooleanLiteral((aBoolean) -> r);
      }

      public final <R> PartialMatcher_DoubleLiteral<R> DateLiteral(
          Function<LocalDateTime, R> DateLiteral) {
        return new PartialMatcher_DoubleLiteral<>(this._feelExpression, null, null, null, DateLiteral);
      }

      public final <R> PartialMatcher_DoubleLiteral<R> DateLiteral_(R r) {
        return this.DateLiteral((dateTime) -> r);
      }

      public final <R> PartialMatcher_IntegerLiteral<R> DoubleLiteral(
          Function<Double, R> DoubleLiteral) {
        return new PartialMatcher_IntegerLiteral<>(this._feelExpression, null, null, null, null, DoubleLiteral);
      }

      public final <R> PartialMatcher_IntegerLiteral<R> DoubleLiteral_(R r) {
        return this.DoubleLiteral((aDouble) -> r);
      }

      public final <R> PartialMatcher_StringLiteral<R> IntegerLiteral(
          Function<Integer, R> IntegerLiteral) {
        return new PartialMatcher_StringLiteral<>(this._feelExpression, null, null, null, null, null, IntegerLiteral);
      }

      public final <R> PartialMatcher_StringLiteral<R> IntegerLiteral_(R r) {
        return this.IntegerLiteral((aInteger) -> r);
      }

      public final <R> PartialMatcher_VariableLiteral<R> StringLiteral(
          Function<String, R> StringLiteral) {
        return new PartialMatcher_VariableLiteral<>(this._feelExpression, null, null, null, null, null, null, StringLiteral);
      }

      public final <R> PartialMatcher_VariableLiteral<R> StringLiteral_(R r) {
        return this.StringLiteral((string) -> r);
      }

      public final <R> PartialMatcher_RangeExpression<R> VariableLiteral(
          Function<String, R> VariableLiteral) {
        return new PartialMatcher_RangeExpression<>(this._feelExpression, null, null, null, null, null, null, null, VariableLiteral);
      }

      public final <R> PartialMatcher_RangeExpression<R> VariableLiteral_(R r) {
        return this.VariableLiteral((name) -> r);
      }

      public final <R> PartialMatcher_UnaryExpression<R> RangeExpression(
          RangeExpressionMapper<R> RangeExpression) {
        return new PartialMatcher_UnaryExpression<>(this._feelExpression, null, null, null, null, null, null, null, null, RangeExpression);
      }

      public final <R> PartialMatcher_UnaryExpression<R> RangeExpression_(R r) {
        return this.RangeExpression((isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> r);
      }

      public final <R> PartialMatcher_BinaryExpression<R> UnaryExpression(
          UnaryExpressionMapper<R> UnaryExpression) {
        return new PartialMatcher_BinaryExpression<>(this._feelExpression, null, null, null, null, null, null, null, null, null, UnaryExpression);
      }

      public final <R> PartialMatcher_BinaryExpression<R> UnaryExpression_(R r) {
        return this.UnaryExpression((operator, expression) -> r);
      }

      public final <R> PartialMatcher_DisjunctionExpression<R> BinaryExpression(
          BinaryExpressionMapper<R> BinaryExpression) {
        return new PartialMatcher_DisjunctionExpression<>(this._feelExpression, null, null, null, null, null, null, null, null, null, null, BinaryExpression);
      }

      public final <R> PartialMatcher_DisjunctionExpression<R> BinaryExpression_(R r) {
        return this.BinaryExpression((left, operator, right) -> r);
      }

      public final <R> PartialMatcher<R> DisjunctionExpression(
          DisjunctionExpressionMapper<R> DisjunctionExpression) {
        return new PartialMatcher<>(this._feelExpression, null, null, null, null, null, null, null, null, null, null, null, DisjunctionExpression);
      }

      public final <R> PartialMatcher<R> DisjunctionExpression_(R r) {
        return this.DisjunctionExpression((head, tail) -> r);
      }
    }

    public static final class TotalMatcher_Null<R> extends PartialMatcher_BooleanLiteral<R> {
      TotalMatcher_Null(FeelExpression _feelExpression, Supplier<R> Empty) {
        super(_feelExpression, Empty, null);
      }

      public final TotalMatcher_BooleanLiteral<R> Null(Supplier<R> Null) {
        return new TotalMatcher_BooleanLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, Null);
      }

      public final TotalMatcher_BooleanLiteral<R> Null_(R r) {
        return this.Null(() -> r);
      }
    }

    public static final class TotalMatcher_BooleanLiteral<R> extends PartialMatcher_DateLiteral<R> {
      TotalMatcher_BooleanLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null) {
        super(_feelExpression, Empty, Null, null);
      }

      public final TotalMatcher_DateLiteral<R> BooleanLiteral(Function<Boolean, R> BooleanLiteral) {
        return new TotalMatcher_DateLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, BooleanLiteral);
      }

      public final TotalMatcher_DateLiteral<R> BooleanLiteral_(R r) {
        return this.BooleanLiteral((aBoolean) -> r);
      }
    }

    public static final class TotalMatcher_DateLiteral<R> extends PartialMatcher_DoubleLiteral<R> {
      TotalMatcher_DateLiteral(FeelExpression _feelExpression, Supplier<R> Empty, Supplier<R> Null,
          Function<Boolean, R> BooleanLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, null);
      }

      public final TotalMatcher_DoubleLiteral<R> DateLiteral(
          Function<LocalDateTime, R> DateLiteral) {
        return new TotalMatcher_DoubleLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, DateLiteral);
      }

      public final TotalMatcher_DoubleLiteral<R> DateLiteral_(R r) {
        return this.DateLiteral((dateTime) -> r);
      }
    }

    public static final class TotalMatcher_DoubleLiteral<R> extends PartialMatcher_IntegerLiteral<R> {
      TotalMatcher_DoubleLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, null);
      }

      public final TotalMatcher_IntegerLiteral<R> DoubleLiteral(Function<Double, R> DoubleLiteral) {
        return new TotalMatcher_IntegerLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, DoubleLiteral);
      }

      public final TotalMatcher_IntegerLiteral<R> DoubleLiteral_(R r) {
        return this.DoubleLiteral((aDouble) -> r);
      }
    }

    public static final class TotalMatcher_IntegerLiteral<R> extends PartialMatcher_StringLiteral<R> {
      TotalMatcher_IntegerLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, null);
      }

      public final TotalMatcher_StringLiteral<R> IntegerLiteral(
          Function<Integer, R> IntegerLiteral) {
        return new TotalMatcher_StringLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, IntegerLiteral);
      }

      public final TotalMatcher_StringLiteral<R> IntegerLiteral_(R r) {
        return this.IntegerLiteral((aInteger) -> r);
      }
    }

    public static final class TotalMatcher_StringLiteral<R> extends PartialMatcher_VariableLiteral<R> {
      TotalMatcher_StringLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, null);
      }

      public final TotalMatcher_VariableLiteral<R> StringLiteral(
          Function<String, R> StringLiteral) {
        return new TotalMatcher_VariableLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, StringLiteral);
      }

      public final TotalMatcher_VariableLiteral<R> StringLiteral_(R r) {
        return this.StringLiteral((string) -> r);
      }
    }

    public static final class TotalMatcher_VariableLiteral<R> extends PartialMatcher_RangeExpression<R> {
      TotalMatcher_VariableLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, null);
      }

      public final TotalMatcher_RangeExpression<R> VariableLiteral(
          Function<String, R> VariableLiteral) {
        return new TotalMatcher_RangeExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, VariableLiteral);
      }

      public final TotalMatcher_RangeExpression<R> VariableLiteral_(R r) {
        return this.VariableLiteral((name) -> r);
      }
    }

    public static final class TotalMatcher_RangeExpression<R> extends PartialMatcher_UnaryExpression<R> {
      TotalMatcher_RangeExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, null);
      }

      public final TotalMatcher_UnaryExpression<R> RangeExpression(
          RangeExpressionMapper<R> RangeExpression) {
        return new TotalMatcher_UnaryExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, RangeExpression);
      }

      public final TotalMatcher_UnaryExpression<R> RangeExpression_(R r) {
        return this.RangeExpression((isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> r);
      }
    }

    public static final class TotalMatcher_UnaryExpression<R> extends PartialMatcher_BinaryExpression<R> {
      TotalMatcher_UnaryExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral, RangeExpressionMapper<R> RangeExpression) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, RangeExpression, null);
      }

      public final TotalMatcher_BinaryExpression<R> UnaryExpression(
          UnaryExpressionMapper<R> UnaryExpression) {
        return new TotalMatcher_BinaryExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, ((PartialMatcher<R>) this).RangeExpression, UnaryExpression);
      }

      public final TotalMatcher_BinaryExpression<R> UnaryExpression_(R r) {
        return this.UnaryExpression((operator, expression) -> r);
      }
    }

    public static final class TotalMatcher_BinaryExpression<R> extends PartialMatcher_DisjunctionExpression<R> {
      TotalMatcher_BinaryExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral, RangeExpressionMapper<R> RangeExpression,
          UnaryExpressionMapper<R> UnaryExpression) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, RangeExpression, UnaryExpression, null);
      }

      public final TotalMatcher_DisjunctionExpression<R> BinaryExpression(
          BinaryExpressionMapper<R> BinaryExpression) {
        return new TotalMatcher_DisjunctionExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, ((PartialMatcher<R>) this).RangeExpression, ((PartialMatcher<R>) this).UnaryExpression, BinaryExpression);
      }

      public final TotalMatcher_DisjunctionExpression<R> BinaryExpression_(R r) {
        return this.BinaryExpression((left, operator, right) -> r);
      }
    }

    public static final class TotalMatcher_DisjunctionExpression<R> extends PartialMatcher<R> {
      TotalMatcher_DisjunctionExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral, RangeExpressionMapper<R> RangeExpression,
          UnaryExpressionMapper<R> UnaryExpression, BinaryExpressionMapper<R> BinaryExpression) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, RangeExpression, UnaryExpression, BinaryExpression, null);
      }

      public final R DisjunctionExpression(DisjunctionExpressionMapper<R> DisjunctionExpression) {
        FeelExpression.Cases<R> cases = FeelExpressions.cases(((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, ((PartialMatcher<R>) this).RangeExpression, ((PartialMatcher<R>) this).UnaryExpression, ((PartialMatcher<R>) this).BinaryExpression, DisjunctionExpression);
        return ((PartialMatcher<R>) this)._feelExpression.match(cases);
      }

      public final R DisjunctionExpression_(R r) {
        return this.DisjunctionExpression((head, tail) -> r);
      }
    }

    public static class PartialMatcher_BooleanLiteral<R> extends PartialMatcher_DateLiteral<R> {
      PartialMatcher_BooleanLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null) {
        super(_feelExpression, Empty, Null, null);
      }

      public final PartialMatcher_DateLiteral<R> BooleanLiteral(
          Function<Boolean, R> BooleanLiteral) {
        return new PartialMatcher_DateLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, BooleanLiteral);
      }

      public final PartialMatcher_DateLiteral<R> BooleanLiteral_(R r) {
        return this.BooleanLiteral((aBoolean) -> r);
      }
    }

    public static class PartialMatcher_DateLiteral<R> extends PartialMatcher_DoubleLiteral<R> {
      PartialMatcher_DateLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, null);
      }

      public final PartialMatcher_DoubleLiteral<R> DateLiteral(
          Function<LocalDateTime, R> DateLiteral) {
        return new PartialMatcher_DoubleLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, DateLiteral);
      }

      public final PartialMatcher_DoubleLiteral<R> DateLiteral_(R r) {
        return this.DateLiteral((dateTime) -> r);
      }
    }

    public static class PartialMatcher_DoubleLiteral<R> extends PartialMatcher_IntegerLiteral<R> {
      PartialMatcher_DoubleLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, null);
      }

      public final PartialMatcher_IntegerLiteral<R> DoubleLiteral(
          Function<Double, R> DoubleLiteral) {
        return new PartialMatcher_IntegerLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, DoubleLiteral);
      }

      public final PartialMatcher_IntegerLiteral<R> DoubleLiteral_(R r) {
        return this.DoubleLiteral((aDouble) -> r);
      }
    }

    public static class PartialMatcher_IntegerLiteral<R> extends PartialMatcher_StringLiteral<R> {
      PartialMatcher_IntegerLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, null);
      }

      public final PartialMatcher_StringLiteral<R> IntegerLiteral(
          Function<Integer, R> IntegerLiteral) {
        return new PartialMatcher_StringLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, IntegerLiteral);
      }

      public final PartialMatcher_StringLiteral<R> IntegerLiteral_(R r) {
        return this.IntegerLiteral((aInteger) -> r);
      }
    }

    public static class PartialMatcher_StringLiteral<R> extends PartialMatcher_VariableLiteral<R> {
      PartialMatcher_StringLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, null);
      }

      public final PartialMatcher_VariableLiteral<R> StringLiteral(
          Function<String, R> StringLiteral) {
        return new PartialMatcher_VariableLiteral<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, StringLiteral);
      }

      public final PartialMatcher_VariableLiteral<R> StringLiteral_(R r) {
        return this.StringLiteral((string) -> r);
      }
    }

    public static class PartialMatcher_VariableLiteral<R> extends PartialMatcher_RangeExpression<R> {
      PartialMatcher_VariableLiteral(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, null);
      }

      public final PartialMatcher_RangeExpression<R> VariableLiteral(
          Function<String, R> VariableLiteral) {
        return new PartialMatcher_RangeExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, VariableLiteral);
      }

      public final PartialMatcher_RangeExpression<R> VariableLiteral_(R r) {
        return this.VariableLiteral((name) -> r);
      }
    }

    public static class PartialMatcher_RangeExpression<R> extends PartialMatcher_UnaryExpression<R> {
      PartialMatcher_RangeExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, null);
      }

      public final PartialMatcher_UnaryExpression<R> RangeExpression(
          RangeExpressionMapper<R> RangeExpression) {
        return new PartialMatcher_UnaryExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, RangeExpression);
      }

      public final PartialMatcher_UnaryExpression<R> RangeExpression_(R r) {
        return this.RangeExpression((isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> r);
      }
    }

    public static class PartialMatcher_UnaryExpression<R> extends PartialMatcher_BinaryExpression<R> {
      PartialMatcher_UnaryExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral, RangeExpressionMapper<R> RangeExpression) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, RangeExpression, null);
      }

      public final PartialMatcher_BinaryExpression<R> UnaryExpression(
          UnaryExpressionMapper<R> UnaryExpression) {
        return new PartialMatcher_BinaryExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, ((PartialMatcher<R>) this).RangeExpression, UnaryExpression);
      }

      public final PartialMatcher_BinaryExpression<R> UnaryExpression_(R r) {
        return this.UnaryExpression((operator, expression) -> r);
      }
    }

    public static class PartialMatcher_BinaryExpression<R> extends PartialMatcher_DisjunctionExpression<R> {
      PartialMatcher_BinaryExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral, RangeExpressionMapper<R> RangeExpression,
          UnaryExpressionMapper<R> UnaryExpression) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, RangeExpression, UnaryExpression, null);
      }

      public final PartialMatcher_DisjunctionExpression<R> BinaryExpression(
          BinaryExpressionMapper<R> BinaryExpression) {
        return new PartialMatcher_DisjunctionExpression<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, ((PartialMatcher<R>) this).RangeExpression, ((PartialMatcher<R>) this).UnaryExpression, BinaryExpression);
      }

      public final PartialMatcher_DisjunctionExpression<R> BinaryExpression_(R r) {
        return this.BinaryExpression((left, operator, right) -> r);
      }
    }

    public static class PartialMatcher_DisjunctionExpression<R> extends PartialMatcher<R> {
      PartialMatcher_DisjunctionExpression(FeelExpression _feelExpression, Supplier<R> Empty,
          Supplier<R> Null, Function<Boolean, R> BooleanLiteral,
          Function<LocalDateTime, R> DateLiteral, Function<Double, R> DoubleLiteral,
          Function<Integer, R> IntegerLiteral, Function<String, R> StringLiteral,
          Function<String, R> VariableLiteral, RangeExpressionMapper<R> RangeExpression,
          UnaryExpressionMapper<R> UnaryExpression, BinaryExpressionMapper<R> BinaryExpression) {
        super(_feelExpression, Empty, Null, BooleanLiteral, DateLiteral, DoubleLiteral, IntegerLiteral, StringLiteral, VariableLiteral, RangeExpression, UnaryExpression, BinaryExpression, null);
      }

      public final PartialMatcher<R> DisjunctionExpression(
          DisjunctionExpressionMapper<R> DisjunctionExpression) {
        return new PartialMatcher<>(((PartialMatcher<R>) this)._feelExpression, ((PartialMatcher<R>) this).Empty, ((PartialMatcher<R>) this).Null, ((PartialMatcher<R>) this).BooleanLiteral, ((PartialMatcher<R>) this).DateLiteral, ((PartialMatcher<R>) this).DoubleLiteral, ((PartialMatcher<R>) this).IntegerLiteral, ((PartialMatcher<R>) this).StringLiteral, ((PartialMatcher<R>) this).VariableLiteral, ((PartialMatcher<R>) this).RangeExpression, ((PartialMatcher<R>) this).UnaryExpression, ((PartialMatcher<R>) this).BinaryExpression, DisjunctionExpression);
      }

      public final PartialMatcher<R> DisjunctionExpression_(R r) {
        return this.DisjunctionExpression((head, tail) -> r);
      }
    }

    public static class PartialMatcher<R> {
      private final FeelExpression _feelExpression;

      private final Supplier<R> Empty;

      private final Supplier<R> Null;

      private final Function<Boolean, R> BooleanLiteral;

      private final Function<LocalDateTime, R> DateLiteral;

      private final Function<Double, R> DoubleLiteral;

      private final Function<Integer, R> IntegerLiteral;

      private final Function<String, R> StringLiteral;

      private final Function<String, R> VariableLiteral;

      private final RangeExpressionMapper<R> RangeExpression;

      private final UnaryExpressionMapper<R> UnaryExpression;

      private final BinaryExpressionMapper<R> BinaryExpression;

      private final DisjunctionExpressionMapper<R> DisjunctionExpression;

      PartialMatcher(FeelExpression _feelExpression, Supplier<R> Empty, Supplier<R> Null,
          Function<Boolean, R> BooleanLiteral, Function<LocalDateTime, R> DateLiteral,
          Function<Double, R> DoubleLiteral, Function<Integer, R> IntegerLiteral,
          Function<String, R> StringLiteral, Function<String, R> VariableLiteral,
          RangeExpressionMapper<R> RangeExpression, UnaryExpressionMapper<R> UnaryExpression,
          BinaryExpressionMapper<R> BinaryExpression,
          DisjunctionExpressionMapper<R> DisjunctionExpression) {
        this._feelExpression = _feelExpression;
        this.Empty = Empty;
        this.Null = Null;
        this.BooleanLiteral = BooleanLiteral;
        this.DateLiteral = DateLiteral;
        this.DoubleLiteral = DoubleLiteral;
        this.IntegerLiteral = IntegerLiteral;
        this.StringLiteral = StringLiteral;
        this.VariableLiteral = VariableLiteral;
        this.RangeExpression = RangeExpression;
        this.UnaryExpression = UnaryExpression;
        this.BinaryExpression = BinaryExpression;
        this.DisjunctionExpression = DisjunctionExpression;
      }

      public final R otherwise(Supplier<R> otherwise) {
        FeelExpression.Cases<R> cases = FeelExpressions.<R>cases(this.Empty != null ? this.Empty : () -> otherwise.get(),
            this.Null != null ? this.Null : () -> otherwise.get(),
            this.BooleanLiteral != null ? this.BooleanLiteral : (aBoolean) -> otherwise.get(),
            this.DateLiteral != null ? this.DateLiteral : (dateTime) -> otherwise.get(),
            this.DoubleLiteral != null ? this.DoubleLiteral : (aDouble) -> otherwise.get(),
            this.IntegerLiteral != null ? this.IntegerLiteral : (aInteger) -> otherwise.get(),
            this.StringLiteral != null ? this.StringLiteral : (string) -> otherwise.get(),
            this.VariableLiteral != null ? this.VariableLiteral : (name) -> otherwise.get(),
            this.RangeExpression != null ? this.RangeExpression : (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> otherwise.get(),
            this.UnaryExpression != null ? this.UnaryExpression : (operator, expression) -> otherwise.get(),
            this.BinaryExpression != null ? this.BinaryExpression : (left, operator, right) -> otherwise.get(),
            this.DisjunctionExpression != null ? this.DisjunctionExpression : (head, tail) -> otherwise.get());
        return this._feelExpression.match(cases);
      }

      public final R otherwise_(R r) {
        return this.otherwise(() -> r);
      }

      public final Optional<R> otherwiseEmpty() {
        FeelExpression.Cases<Optional<R>> cases = FeelExpressions.cases((this.Empty != null) ? () -> Optional.of(this.Empty.get())
            : () -> Optional.empty(),
            (this.Null != null) ? () -> Optional.of(this.Null.get())
            : () -> Optional.empty(),
            (this.BooleanLiteral != null) ? (aBoolean) -> Optional.of(this.BooleanLiteral.apply(aBoolean))
            : (aBoolean) -> Optional.empty(),
            (this.DateLiteral != null) ? (dateTime) -> Optional.of(this.DateLiteral.apply(dateTime))
            : (dateTime) -> Optional.empty(),
            (this.DoubleLiteral != null) ? (aDouble) -> Optional.of(this.DoubleLiteral.apply(aDouble))
            : (aDouble) -> Optional.empty(),
            (this.IntegerLiteral != null) ? (aInteger) -> Optional.of(this.IntegerLiteral.apply(aInteger))
            : (aInteger) -> Optional.empty(),
            (this.StringLiteral != null) ? (string) -> Optional.of(this.StringLiteral.apply(string))
            : (string) -> Optional.empty(),
            (this.VariableLiteral != null) ? (name) -> Optional.of(this.VariableLiteral.apply(name))
            : (name) -> Optional.empty(),
            (this.RangeExpression != null) ? (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.of(this.RangeExpression.RangeExpression(isLeftInclusive, lowerBound, upperBound, isRightInclusive))
            : (isLeftInclusive, lowerBound, upperBound, isRightInclusive) -> Optional.empty(),
            (this.UnaryExpression != null) ? (operator, expression) -> Optional.of(this.UnaryExpression.UnaryExpression(operator, expression))
            : (operator, expression) -> Optional.empty(),
            (this.BinaryExpression != null) ? (left, operator, right) -> Optional.of(this.BinaryExpression.BinaryExpression(left, operator, right))
            : (left, operator, right) -> Optional.empty(),
            (this.DisjunctionExpression != null) ? (head, tail) -> Optional.of(this.DisjunctionExpression.DisjunctionExpression(head, tail))
            : (head, tail) -> Optional.empty());
        return this._feelExpression.match(cases);
      }
    }
  }
}
