/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.core.SimpleValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.HitPolicy;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class DuplicateRuleValidator
extends SimpleValidator<DecisionTable> {
    public Class<DecisionTable> getClassUnderValidation() {
        return DecisionTable.class;
    }

    public boolean isApplicable(DecisionTable decisionTable, ValidationContext validationContext) {
        return !HitPolicy.COLLECT.equals((Object)decisionTable.getHitPolicy());
    }

    public List<ValidationResult> validate(DecisionTable decisionTable, ValidationContext validationContext) {
        Collection rules = decisionTable.getRules();
        ArrayList expressions = new ArrayList();
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        for (Rule rule : rules) {
            List rowElements = Stream.concat(rule.getInputEntries().stream(), rule.getOutputEntries().stream()).map(ModelElementInstance::getTextContent).collect(Collectors.toList());
            if (!expressions.contains(rowElements)) {
                expressions.add(rowElements);
                continue;
            }
            result.add(ValidationResult.init.message("Rule is defined more than once").element((ModelElementInstance)rule).build());
        }
        return result;
    }
}

