/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.feel;

import de.redsix.dmncheck.feel.FeelExpression;
import de.redsix.dmncheck.feel.FeelExpressions;
import de.redsix.dmncheck.feel.Operator;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;

final class Subsumption {
    static final Comparison<?> eq = (a, b) -> a.compareTo(b) == 0;
    private static final Comparison<?> nq = (a, b) -> a.compareTo(b) != 0;
    private static final Comparison<?> gt = (a, b) -> a.compareTo(b) > 0;
    private static final Comparison<?> lt = (a, b) -> a.compareTo(b) < 0;
    private static final Comparison<?> ge = (a, b) -> a.compareTo(b) == 0 || a.compareTo(b) > 0;
    private static final Comparison<?> le = (a, b) -> a.compareTo(b) == 0 || a.compareTo(b) < 0;

    Subsumption() {
    }

    static Optional<Boolean> subsumes(FeelExpression expression, FeelExpression otherExpression, Comparison comparison) {
        return FeelExpressions.caseOf(expression).Empty_(Optional.of(true)).Null_(FeelExpressions.caseOf(otherExpression).Null_(Optional.of(true)).otherwise_(Optional.of(false))).BooleanLiteral(aBool -> Subsumption.compareLiterals(aBool, FeelExpressions::getABoolean, otherExpression, comparison)).DateLiteral(dateTime -> Subsumption.compareLiterals(dateTime, FeelExpressions::getDateTime, otherExpression, comparison)).DoubleLiteral(aDouble -> Subsumption.compareLiterals(aDouble, FeelExpressions::getADouble, otherExpression, comparison)).IntegerLiteral(integer -> Subsumption.compareLiterals(integer, FeelExpressions::getAInteger, otherExpression, comparison)).StringLiteral(string -> Subsumption.compareLiterals(string, FeelExpressions::getString, otherExpression, eq)).VariableLiteral_(Optional.of(true)).RangeExpression((leftInc, lowerBound, upperBound, rightInc) -> Subsumption.subsumesRangeExpression(leftInc, lowerBound, upperBound, rightInc, otherExpression)).UnaryExpression((operator, operand) -> Subsumption.subsumesUnaryExpression(operator, operand, otherExpression)).otherwise_(Optional.empty());
    }

    private static Optional<Boolean> subsumesUnaryExpression(Operator operator, FeelExpression operand, FeelExpression otherExpression) {
        return FeelExpressions.caseOf(otherExpression).RangeExpression((leftInc, lowerBound, upperBound, rightInc) -> {
            switch (operator) {
                case LT: {
                    return Subsumption.subsumes(upperBound, operand, rightInc ? lt : le);
                }
                case GT: {
                    return Subsumption.subsumes(operand, lowerBound, leftInc ? lt : le);
                }
                case LE: {
                    return Subsumption.subsumes(upperBound, operand, rightInc ? le : lt);
                }
                case GE: {
                    return Subsumption.subsumes(operand, lowerBound, leftInc ? le : lt);
                }
            }
            return Optional.of(false);
        }).UnaryExpression((otherOperator, otherOperand) -> {
            if (operator.equals((Object)otherOperator) && operand.equals(otherOperand)) {
                return Optional.of(true);
            }
            if (Subsumption.isGreater(Subsumption.fromOperator(operator)) && Subsumption.isGreater(Subsumption.fromOperator(otherOperator))) {
                return Subsumption.subsumes(otherOperand, operand, Subsumption.fromOperator(operator));
            }
            if (Subsumption.isLess(Subsumption.fromOperator(operator)) && Subsumption.isLess(Subsumption.fromOperator(otherOperator))) {
                return Subsumption.subsumes(otherOperand, operand, Subsumption.fromOperator(operator));
            }
            return Optional.of(false);
        }).otherwise(() -> {
            if (operator.equals((Object)Operator.NOT) && otherExpression.isLiteral()) {
                return Subsumption.subsumes(operand, otherExpression, nq);
            }
            return Optional.of(false);
        });
    }

    private static Optional<Boolean> subsumesRangeExpression(boolean leftInc, FeelExpression lowerBound, FeelExpression upperBound, boolean rightInc, FeelExpression otherExpression) {
        return FeelExpressions.caseOf(otherExpression).RangeExpression((otherLeftInc, otherLowerBound, otherUpperBound, otherRightInc) -> Subsumption.subsumes(lowerBound, otherLowerBound, leftInc ? le : lt).flatMap(subsumesLowerBound -> Subsumption.subsumes(otherUpperBound, upperBound, rightInc ? le : lt).flatMap(subsumesUpperBound -> Optional.of(subsumesLowerBound != false && subsumesUpperBound != false)))).otherwise(() -> {
            if (otherExpression.isLiteral()) {
                return Subsumption.subsumes(lowerBound, otherExpression, leftInc ? le : lt).flatMap(subsumedByLowerBound -> Subsumption.subsumes(upperBound, otherExpression, rightInc ? ge : gt).flatMap(subsumedByUpperBound -> Optional.of(subsumedByLowerBound != false && subsumedByUpperBound != false)));
            }
            return Optional.of(false);
        });
    }

    private static <R extends Comparable> Optional<Boolean> compareLiterals(R value, Function<FeelExpression, Optional<R>> extractOtherValue, FeelExpression otherExpression, Comparison comparison) {
        return Optional.of(extractOtherValue.apply(otherExpression).map(otherValue -> comparison.test(value, otherValue)).orElse(false));
    }

    private static Comparison fromOperator(Operator operator) {
        switch (operator) {
            case LE: {
                return le;
            }
            case LT: {
                return lt;
            }
            case GT: {
                return gt;
            }
            case GE: {
                return ge;
            }
        }
        return eq;
    }

    private static boolean isLess(Comparison comparison) {
        return comparison.equals(le) || comparison.equals(lt);
    }

    private static boolean isGreater(Comparison comparison) {
        return comparison.equals(ge) || comparison.equals(gt);
    }

    private static interface Comparison<A extends Comparable>
    extends BiPredicate<A, A> {
    }
}

