/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionTypeParser;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.TypeValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.ItemDefinition;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ItemDefinitionAllowedValuesTypeValidator
extends TypeValidator<ItemDefinition> {
    public boolean isApplicable(ItemDefinition itemDefinition, ValidationContext validationContext) {
        String expressionType = itemDefinition.getTypeRef().getTextContent();
        return itemDefinition.getAllowedValues() != null && ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(parseError -> false, parseResult -> true) != false;
    }

    public List<ValidationResult> validate(ItemDefinition itemDefinition, ValidationContext validationContext) {
        String expressionType = itemDefinition.getTypeRef().getTextContent();
        return ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(validationResult -> Collections.singletonList(validationResult.element((ModelElementInstance)itemDefinition).build()), inputType -> this.typecheck((DmnElement)itemDefinition, Stream.of(itemDefinition.getAllowedValues()), Stream.of(inputType)).collect(Collectors.toList()));
    }

    protected Class<ItemDefinition> getClassUnderValidation() {
        return ItemDefinition.class;
    }

    @Override
    public String errorMessage() {
        return "Type of item definition does not match type of allowed values";
    }
}

