/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.drg.RequirementGraph;
import de.redsix.dmncheck.feel.FeelParser;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.validators.core.RequirementGraphValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.DrgElement;
import org.camunda.bpm.model.dmn.instance.InputClause;
import org.camunda.bpm.model.dmn.instance.OutputClause;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;

public class ConnectedRequirementGraphValidator
extends RequirementGraphValidator {
    public List<ValidationResult> validate(RequirementGraph drg) {
        ConnectivityInspector connectivityInspector = new ConnectivityInspector((Graph)drg);
        if (connectivityInspector.isConnected()) {
            return drg.edgeSet().stream().flatMap(edge -> this.checkInAndOuputs((DrgElement)drg.getEdgeSource(edge), (DrgElement)drg.getEdgeTarget(edge)).stream()).collect(Collectors.toList());
        }
        if (connectivityInspector.connectedSets().isEmpty()) {
            return Collections.emptyList();
        }
        return this.reportUnconnectedComponents(drg, (ConnectivityInspector<DrgElement, DefaultEdge>)connectivityInspector);
    }

    private List<ValidationResult> checkInAndOuputs(DrgElement sourceElement, DrgElement targetElement) {
        if (sourceElement instanceof Decision && targetElement instanceof Decision) {
            Decision sourceDecision = (Decision)sourceElement;
            Decision targetDecision = (Decision)targetElement;
            return this.checkInAndOutputs(sourceDecision, targetDecision);
        }
        return Collections.emptyList();
    }

    private List<ValidationResult> checkInAndOutputs(Decision sourceDecision, Decision targetDecision) {
        return this.applyOnDecsionTable(sourceDecision, sourceDecisionTable -> this.applyOnDecsionTable(targetDecision, targetDecisionTable -> {
            Either eitherInputExpressions = targetDecisionTable.getInputs().stream().map(InputClause::getInputExpression).map(ModelElementInstance::getTextContent).map(FeelParser::parse).collect(Either.reduce());
            Either<ValidationResult.Builder.ElementStep, Boolean> doInAndOutputsMatch = eitherInputExpressions.map(inputExpressions -> {
                Set outputIds = sourceDecisionTable.getOutputs().stream().map(OutputClause::getName).collect(Collectors.toSet());
                return inputExpressions.stream().anyMatch(inputExpression -> outputIds.stream().anyMatch(inputExpression::containsVariable));
            });
            return doInAndOutputsMatch.match(elementStep -> Collections.singletonList(elementStep.element((ModelElementInstance)targetDecision).build()), matching -> {
                if (matching.booleanValue()) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(ValidationResult.init.message("Inputs and outputs do not match in connected decisions.").element((ModelElementInstance)sourceDecision).build());
            });
        }));
    }

    private List<ValidationResult> applyOnDecsionTable(Decision decision, Function<DecisionTable, List<ValidationResult>> validate) {
        Collection decisionTables = decision.getChildElementsByType(DecisionTable.class);
        if (decisionTables.size() == 1) {
            return validate.apply((DecisionTable)decisionTables.iterator().next());
        }
        return Collections.singletonList(ValidationResult.init.message("There is either no or more than one decision table.").element((ModelElementInstance)decision).build());
    }

    private List<ValidationResult> reportUnconnectedComponents(RequirementGraph drg, ConnectivityInspector<DrgElement, DefaultEdge> connectivityInspector) {
        List connectedSetsOfSizeOne = connectivityInspector.connectedSets().stream().filter(connectedSet -> connectedSet.size() == 1).collect(Collectors.toList());
        if (connectedSetsOfSizeOne.isEmpty()) {
            List subgraphs = connectivityInspector.connectedSets().stream().filter(connectedSet -> connectedSet.size() > 1).collect(Collectors.toList());
            return Collections.singletonList(ValidationResult.init.message("Found unconnected requirement graphs: " + subgraphs).element((ModelElementInstance)drg.getDefinitions()).build());
        }
        return connectedSetsOfSizeOne.stream().map(connectedSetOfSizeOne -> ValidationResult.init.message("Element is not connected to requirement graph").element((ModelElementInstance)connectedSetOfSizeOne.iterator().next()).build()).collect(Collectors.toList());
    }
}

