/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.util;

import de.redsix.dmncheck.util.TriFunction;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Util {
    private Util() {
    }

    public static <A, B, C> Stream<C> zip(Stream<? extends A> a, Stream<? extends B> b, final BiFunction<? super A, ? super B, ? extends C> zipper) {
        Objects.requireNonNull(zipper);
        Spliterator aSpliterator = Objects.requireNonNull(a).spliterator();
        Spliterator bSpliterator = Objects.requireNonNull(b).spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & 0xFFFFFFFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), bSpliterator.getExactSizeIfKnown()) : -1L;
        final Iterator aIterator = Spliterators.iterator(aSpliterator);
        final Iterator bIterator = Spliterators.iterator(bSpliterator);
        Iterator cIterator = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return aIterator.hasNext() && bIterator.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(aIterator.next(), bIterator.next());
            }
        };
        Spliterator split = Spliterators.spliterator(cIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.stream(split, true) : StreamSupport.stream(split, false);
    }

    public static <A, B, C, D> Stream<D> zip(Stream<? extends A> a, Stream<? extends B> b, Stream<? extends C> c, final TriFunction<? super A, ? super B, ? super C, ? extends D> zipper) {
        Objects.requireNonNull(zipper);
        Spliterator aSpliterator = Objects.requireNonNull(a).spliterator();
        Spliterator bSpliterator = Objects.requireNonNull(b).spliterator();
        Spliterator cSpliterator = Objects.requireNonNull(c).spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & cSpliterator.characteristics() & 0xFFFFFFFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), Math.min(bSpliterator.getExactSizeIfKnown(), cSpliterator.getExactSizeIfKnown())) : -1L;
        final Iterator aIterator = Spliterators.iterator(aSpliterator);
        final Iterator bIterator = Spliterators.iterator(bSpliterator);
        final Iterator cIterator = Spliterators.iterator(cSpliterator);
        Iterator dIterator = new Iterator<D>(){

            @Override
            public boolean hasNext() {
                return aIterator.hasNext() && bIterator.hasNext() && cIterator.hasNext();
            }

            @Override
            public D next() {
                return zipper.apply(aIterator.next(), bIterator.next(), cIterator.next());
            }
        };
        Spliterator split = Spliterators.spliterator(dIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() || c.isParallel() ? StreamSupport.stream(split, true) : StreamSupport.stream(split, false);
    }
}

