/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.feel;

import de.redsix.dmncheck.feel.ExpressionType;
import de.redsix.dmncheck.feel.ExpressionTypes;
import de.redsix.dmncheck.feel.FeelExpression;
import de.redsix.dmncheck.feel.FeelExpressions;
import de.redsix.dmncheck.feel.Operator;
import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.util.Eithers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class FeelTypecheck {
    private FeelTypecheck() {
    }

    public static Either<ValidationResult.Builder.ElementStep, ExpressionType> typecheck(FeelExpression expression) {
        return FeelTypecheck.typecheck(new Context(), expression);
    }

    public static Either<ValidationResult.Builder.ElementStep, ExpressionType> typecheck(Context context, FeelExpression expression) {
        return FeelExpressions.caseOf(expression).Empty_(Eithers.right(ExpressionTypes.TOP())).BooleanLiteral(bool -> Eithers.right(ExpressionTypes.BOOLEAN())).DateLiteral(dateTime -> Eithers.right(ExpressionTypes.DATE())).DoubleLiteral(aDouble -> Eithers.right(ExpressionTypes.DOUBLE())).IntegerLiteral(integer -> Eithers.right(ExpressionTypes.INTEGER())).StringLiteral(string -> Eithers.right(ExpressionTypes.STRING())).VariableLiteral(name -> {
            if (context.containsKey(name)) {
                return Eithers.right(context.get(name));
            }
            return Eithers.left(ValidationResult.init.message("Variable '" + name + "' has no type.").severity(Severity.WARNING));
        }).RangeExpression((__, lowerBound, upperBound, ___) -> FeelTypecheck.typecheckRangeExpression(context, lowerBound, upperBound)).UnaryExpression((operator, operand) -> FeelTypecheck.typecheckUnaryExpression(context, operator, operand)).BinaryExpression((left, operator, right) -> FeelTypecheck.typecheckBinaryExpression(context, left, operator, right)).DisjunctionExpression((head, tail) -> FeelTypecheck.typecheckDisjunctionExpression(context, head, tail));
    }

    private static Either<ValidationResult.Builder.ElementStep, ExpressionType> typecheckDisjunctionExpression(Context context, FeelExpression head, FeelExpression tail) {
        return FeelTypecheck.typecheck(context, head).bind(headType -> FeelTypecheck.typecheck(context, tail).bind(tailType -> FeelTypecheck.check(headType.equals(tailType), "Types of head and tail do not match.").orElse(Eithers.right(headType))));
    }

    private static Either<ValidationResult.Builder.ElementStep, ExpressionType> typecheckBinaryExpression(Context context, FeelExpression left, Operator operator, FeelExpression right) {
        return FeelTypecheck.typecheck(context, left).bind(leftType -> FeelTypecheck.typecheck(context, right).bind(rightType -> FeelTypecheck.check(leftType.equals(rightType), "Types of left and right operand do not match.").orElse(FeelTypecheck.checkOperatorCompatibility(leftType, operator))));
    }

    private static Either<ValidationResult.Builder.ElementStep, ExpressionType> typecheckUnaryExpression(Context context, Operator operator, FeelExpression operand) {
        Stream<Operator> allowedOperators = Stream.of(Operator.GT, Operator.GE, Operator.LT, Operator.LE, Operator.NOT);
        return FeelTypecheck.typecheck(context, operand).bind(type -> FeelTypecheck.check(allowedOperators.anyMatch(operator::equals), "Operator is not supported in UnaryExpression.").orElse(FeelTypecheck.checkOperatorCompatibility(type, operator)));
    }

    private static Either<ValidationResult.Builder.ElementStep, ExpressionType> checkOperatorCompatibility(ExpressionType type, Operator operator) {
        switch (operator) {
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case DIV: 
            case EXP: 
            case MUL: 
            case ADD: 
            case SUB: {
                return FeelTypecheck.check(ExpressionType.isNumeric(type), "Operator " + (Object)((Object)operator) + " expects numeric type but got " + type).orElse(Eithers.right(type));
            }
            case OR: 
            case AND: {
                return FeelTypecheck.check(ExpressionTypes.BOOLEAN().equals(type), "Operator " + (Object)((Object)operator) + " expects boolean but got " + type).orElse(Eithers.right(type));
            }
            case NOT: {
                return Eithers.right(type);
            }
        }
        return Eithers.left(ValidationResult.init.message("Unexpected operand " + (Object)((Object)operator)));
    }

    private static Either<ValidationResult.Builder.ElementStep, ExpressionType> typecheckRangeExpression(Context context, FeelExpression lowerBound, FeelExpression upperBound) {
        List<ExpressionType> allowedTypes = Arrays.asList(ExpressionTypes.INTEGER(), ExpressionTypes.DOUBLE(), ExpressionTypes.LONG(), ExpressionTypes.DATE());
        return FeelTypecheck.typecheck(context, lowerBound).bind(lowerBoundType -> FeelTypecheck.typecheck(context, upperBound).bind(upperBoundType -> FeelTypecheck.check(lowerBoundType.equals(upperBoundType), "Types of lower and upper bound do not match.").map(Optional::of).orElseGet(() -> FeelTypecheck.check(allowedTypes.contains(lowerBoundType), "Type is unsupported for RangeExpressions.")).orElse(Eithers.right(lowerBoundType))));
    }

    private static Optional<Either<ValidationResult.Builder.ElementStep, ExpressionType>> check(Boolean condition, String errorMessage) {
        if (!condition.booleanValue()) {
            ValidationResult.Builder.SeverityStep validationResult = ValidationResult.init.message(errorMessage);
            return Optional.of(Eithers.left(validationResult));
        }
        return Optional.empty();
    }

    public static final class Context
    extends HashMap<String, ExpressionType> {
    }
}

