/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.core.SimpleValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.NamedElement;

public abstract class IdAndNameValidator<T extends DmnElement & NamedElement>
extends SimpleValidator<T> {
    protected abstract String getName();

    public boolean isApplicable(T element, ValidationContext validationContext) {
        return true;
    }

    public List<ValidationResult> validate(T element, ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (Objects.isNull(element.getId())) {
            validationResults.add(ValidationResult.init.message("A " + this.getName() + " has no id.").element(element).build());
        }
        if (Objects.isNull(((NamedElement)element).getName())) {
            validationResults.add(ValidationResult.init.message("A " + this.getName() + " has no name.").severity(Severity.WARNING).element(element).build());
        }
        return validationResults;
    }
}

