/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.util;

import de.redsix.dmncheck.validators.core.Validator;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ValidatorLoader {
    private static final String VALIDATOR_PACKAGE = "de.redsix.dmncheck.validators";
    private static final String VALIDATOR_CORE_PACKAGE = "de.redsix.dmncheck.validators.core";

    private ValidatorLoader() {
    }

    public static List<Validator> getValidators() {
        return ValidatorLoader.getValidators(null, null);
    }

    public static List<Validator> getValidators(String @Nullable [] packages, String @Nullable [] classes) {
        String[] stringArray;
        ClassGraph classGraph = new ClassGraph().whitelistClasses(new String[]{Validator.class.getName()}).whitelistPackages(new String[]{VALIDATOR_CORE_PACKAGE});
        if (packages == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = VALIDATOR_PACKAGE;
            stringArray = stringArray2;
            stringArray2[1] = VALIDATOR_CORE_PACKAGE;
        } else {
            stringArray = packages;
        }
        ScanResult scanResult = classGraph.whitelistPackagesNonRecursive(stringArray).whitelistClasses(classes == null ? new String[]{} : classes).scan();
        ClassInfoList allValidatorClasses = scanResult.getClassesImplementing(Validator.class.getName());
        return allValidatorClasses.loadClasses(Validator.class).stream().filter(validatorClass -> !Modifier.isAbstract(validatorClass.getModifiers())).filter(validatorClass -> !Modifier.isInterface(validatorClass.getModifiers())).map(ValidatorLoader::instantiateValidator).collect(Collectors.toList());
    }

    private static Validator instantiateValidator(Class<? extends Validator> validator) {
        try {
            return validator.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to load validator " + validator, e);
        }
    }
}

