package de.redsix.dmncheck.feel;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.camunda.bpm.model.dmn.instance.ItemDefinition;

public final class ExpressionTypes {
  private static ExpressionType TOP;

  private static ExpressionType STRING;

  private static ExpressionType BOOLEAN;

  private static ExpressionType INTEGER;

  private static ExpressionType LONG;

  private static ExpressionType DOUBLE;

  private static ExpressionType DATE;

  private static final ExpressionType.Cases<Optional<String>> classNameGetter = ExpressionTypes.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  (className) -> Optional.of(className),
  (itemDefinition) -> Optional.empty());

  private static final ExpressionType.Cases<Optional<ItemDefinition>> itemDefinitionGetter = ExpressionTypes.cases(() -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  () -> Optional.empty(),
  (className) -> Optional.empty(),
  (itemDefinition) -> Optional.of(itemDefinition));

  private ExpressionTypes() {
  }

  public static <R> ExpressionType.Cases<R> cases(Supplier<R> TOP, Supplier<R> STRING,
      Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE,
      Supplier<R> DATE, Function<String, R> ENUM, Function<ItemDefinition, R> ITEMDEFINITION) {
    return new LambdaCases<>(TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, ENUM, ITEMDEFINITION);
  }

  public static ExpressionType TOP() {
    ExpressionType _TOP = TOP;
    if (_TOP == null) {
      TOP = _TOP = new TOP();
    }
    return _TOP;
  }

  public static ExpressionType STRING() {
    ExpressionType _STRING = STRING;
    if (_STRING == null) {
      STRING = _STRING = new STRING();
    }
    return _STRING;
  }

  public static ExpressionType BOOLEAN() {
    ExpressionType _BOOLEAN = BOOLEAN;
    if (_BOOLEAN == null) {
      BOOLEAN = _BOOLEAN = new BOOLEAN();
    }
    return _BOOLEAN;
  }

  public static ExpressionType INTEGER() {
    ExpressionType _INTEGER = INTEGER;
    if (_INTEGER == null) {
      INTEGER = _INTEGER = new INTEGER();
    }
    return _INTEGER;
  }

  public static ExpressionType LONG() {
    ExpressionType _LONG = LONG;
    if (_LONG == null) {
      LONG = _LONG = new LONG();
    }
    return _LONG;
  }

  public static ExpressionType DOUBLE() {
    ExpressionType _DOUBLE = DOUBLE;
    if (_DOUBLE == null) {
      DOUBLE = _DOUBLE = new DOUBLE();
    }
    return _DOUBLE;
  }

  public static ExpressionType DATE() {
    ExpressionType _DATE = DATE;
    if (_DATE == null) {
      DATE = _DATE = new DATE();
    }
    return _DATE;
  }

  public static ExpressionType ENUM(String className) {
    return new ENUM(className);
  }

  public static ExpressionType ITEMDEFINITION(ItemDefinition itemDefinition) {
    return new ITEMDEFINITION(itemDefinition);
  }

  public static ExpressionType lazy(Supplier<ExpressionType> expressionType) {
    return new Lazy(expressionType);
  }

  public static CasesMatchers.TotalMatcher_TOP cases() {
    return CasesMatchers.totalMatcher_TOP;
  }

  public static CaseOfMatchers.TotalMatcher_TOP caseOf(ExpressionType expressionType) {
    return new CaseOfMatchers.TotalMatcher_TOP(expressionType);
  }

  public static Optional<String> getClassName(ExpressionType expressionType) {
    return expressionType.match(classNameGetter);
  }

  public static Optional<ItemDefinition> getItemDefinition(ExpressionType expressionType) {
    return expressionType.match(itemDefinitionGetter);
  }

  public static Function<ExpressionType, ExpressionType> setClassName(String newClassName) {
    return modClassName(__ -> newClassName);
  }

  public static Function<ExpressionType, ExpressionType> modClassName(
      Function<String, String> classNameMod) {
    ExpressionType.Cases<ExpressionType> cases = de.redsix.dmncheck.feel.ExpressionTypes.cases(ExpressionTypes::TOP,
        ExpressionTypes::STRING,
        ExpressionTypes::BOOLEAN,
        ExpressionTypes::INTEGER,
        ExpressionTypes::LONG,
        ExpressionTypes::DOUBLE,
        ExpressionTypes::DATE,
        (className) -> ENUM(classNameMod.apply(className)),
        ExpressionTypes::ITEMDEFINITION);
    return expressionType -> expressionType.match(cases);
  }

  public static Function<ExpressionType, ExpressionType> setItemDefinition(
      ItemDefinition newItemDefinition) {
    return modItemDefinition(__ -> newItemDefinition);
  }

  public static Function<ExpressionType, ExpressionType> modItemDefinition(
      Function<ItemDefinition, ItemDefinition> itemDefinitionMod) {
    ExpressionType.Cases<ExpressionType> cases = de.redsix.dmncheck.feel.ExpressionTypes.cases(ExpressionTypes::TOP,
        ExpressionTypes::STRING,
        ExpressionTypes::BOOLEAN,
        ExpressionTypes::INTEGER,
        ExpressionTypes::LONG,
        ExpressionTypes::DOUBLE,
        ExpressionTypes::DATE,
        ExpressionTypes::ENUM,
        (itemDefinition) -> ITEMDEFINITION(itemDefinitionMod.apply(itemDefinition)));
    return expressionType -> expressionType.match(cases);
  }

  private static final class LambdaCases<R> implements ExpressionType.Cases<R> {
    private final Supplier<R> TOP;

    private final Supplier<R> STRING;

    private final Supplier<R> BOOLEAN;

    private final Supplier<R> INTEGER;

    private final Supplier<R> LONG;

    private final Supplier<R> DOUBLE;

    private final Supplier<R> DATE;

    private final Function<String, R> ENUM;

    private final Function<ItemDefinition, R> ITEMDEFINITION;

    LambdaCases(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN, Supplier<R> INTEGER,
        Supplier<R> LONG, Supplier<R> DOUBLE, Supplier<R> DATE, Function<String, R> ENUM,
        Function<ItemDefinition, R> ITEMDEFINITION) {
      this.TOP = TOP;
      this.STRING = STRING;
      this.BOOLEAN = BOOLEAN;
      this.INTEGER = INTEGER;
      this.LONG = LONG;
      this.DOUBLE = DOUBLE;
      this.DATE = DATE;
      this.ENUM = ENUM;
      this.ITEMDEFINITION = ITEMDEFINITION;
    }

    @Override
    public R TOP() {
      return this.TOP.get();
    }

    @Override
    public R STRING() {
      return this.STRING.get();
    }

    @Override
    public R BOOLEAN() {
      return this.BOOLEAN.get();
    }

    @Override
    public R INTEGER() {
      return this.INTEGER.get();
    }

    @Override
    public R LONG() {
      return this.LONG.get();
    }

    @Override
    public R DOUBLE() {
      return this.DOUBLE.get();
    }

    @Override
    public R DATE() {
      return this.DATE.get();
    }

    @Override
    public R ENUM(String className) {
      return this.ENUM.apply(className);
    }

    @Override
    public R ITEMDEFINITION(ItemDefinition itemDefinition) {
      return this.ITEMDEFINITION.apply(itemDefinition);
    }
  }

  private static final class TOP extends ExpressionType {
    TOP() {
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.TOP();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> true,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          (className) -> false,
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 23;
    }

    @Override
    public String toString() {
      return "TOP()";
    }
  }

  private static final class STRING extends ExpressionType {
    STRING() {
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.STRING();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> true,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          (className) -> false,
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 29;
    }

    @Override
    public String toString() {
      return "STRING()";
    }
  }

  private static final class BOOLEAN extends ExpressionType {
    BOOLEAN() {
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.BOOLEAN();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> false,
          () -> true,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          (className) -> false,
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 31;
    }

    @Override
    public String toString() {
      return "BOOLEAN()";
    }
  }

  private static final class INTEGER extends ExpressionType {
    INTEGER() {
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.INTEGER();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> false,
          () -> false,
          () -> true,
          () -> false,
          () -> false,
          () -> false,
          (className) -> false,
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 37;
    }

    @Override
    public String toString() {
      return "INTEGER()";
    }
  }

  private static final class LONG extends ExpressionType {
    LONG() {
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.LONG();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> true,
          () -> false,
          () -> false,
          (className) -> false,
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 41;
    }

    @Override
    public String toString() {
      return "LONG()";
    }
  }

  private static final class DOUBLE extends ExpressionType {
    DOUBLE() {
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.DOUBLE();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> true,
          () -> false,
          (className) -> false,
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 43;
    }

    @Override
    public String toString() {
      return "DOUBLE()";
    }
  }

  private static final class DATE extends ExpressionType {
    DATE() {
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.DATE();
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> true,
          (className) -> false,
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 47;
    }

    @Override
    public String toString() {
      return "DATE()";
    }
  }

  private static final class ENUM extends ExpressionType {
    private final String className;

    ENUM(String className) {
      this.className = className;
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.ENUM(this.className);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          (className) -> this.className.equals(className),
          (itemDefinition) -> false));
    }

    @Override
    public int hashCode() {
      return 53 + this.className.hashCode();
    }

    @Override
    public String toString() {
      return "ENUM(" + this.className + ")";
    }
  }

  private static final class ITEMDEFINITION extends ExpressionType {
    private final ItemDefinition itemDefinition;

    ITEMDEFINITION(ItemDefinition itemDefinition) {
      this.itemDefinition = itemDefinition;
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return cases.ITEMDEFINITION(this.itemDefinition);
    }

    @Override
    public boolean equals(Object obj) {
      return (obj instanceof ExpressionType) && ((ExpressionType) obj).match(ExpressionTypes.cases(() -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          () -> false,
          (className) -> false,
          (itemDefinition) -> this.itemDefinition.equals(itemDefinition)));
    }

    @Override
    public int hashCode() {
      return 59 + this.itemDefinition.hashCode();
    }

    @Override
    public String toString() {
      return "ITEMDEFINITION(" + this.itemDefinition + ")";
    }
  }

  private static final class Lazy extends ExpressionType {
    private volatile Supplier<ExpressionType> expression;

    private ExpressionType evaluation;

    Lazy(Supplier<ExpressionType> expressionType) {
      this.expression = expressionType;
    }

    private synchronized ExpressionType _evaluate() {
      Lazy lazy = this;
      while (true) {
        Supplier<ExpressionType> expr = lazy.expression;
        if (expr == null) {
          evaluation = lazy.evaluation;
          break;
        }
        else {
          ExpressionType eval = expr.get();
          if (eval instanceof Lazy) {
            lazy = (Lazy) eval;
          }
          else {
            evaluation = eval;
            break;
          }
        }
      }
      expression = null;
      return evaluation;
    }

    @Override
    public <R> R match(ExpressionType.Cases<R> cases) {
      return (this.expression == null ? this.evaluation : _evaluate()).match(cases);
    }

    @Override
    public boolean equals(Object obj) {
      return (this.expression == null ? this.evaluation : _evaluate()).equals(obj);
    }

    @Override
    public int hashCode() {
      return (this.expression == null ? this.evaluation : _evaluate()).hashCode();
    }

    @Override
    public String toString() {
      return (this.expression == null ? this.evaluation : _evaluate()).toString();
    }
  }

  public static class CasesMatchers {
    private static final TotalMatcher_TOP totalMatcher_TOP = new TotalMatcher_TOP();

    private CasesMatchers() {
    }

    public static final class TotalMatcher_TOP {
      TotalMatcher_TOP() {
      }

      public final <R> TotalMatcher_STRING<R> TOP(Supplier<R> TOP) {
        return new TotalMatcher_STRING<>(TOP);
      }

      public final <R> TotalMatcher_STRING<R> TOP_(R r) {
        return this.TOP(() -> r);
      }

      public final <R> PartialMatcher_BOOLEAN<R> STRING(Supplier<R> STRING) {
        return new PartialMatcher_BOOLEAN<>(null, STRING);
      }

      public final <R> PartialMatcher_BOOLEAN<R> STRING_(R r) {
        return this.STRING(() -> r);
      }

      public final <R> PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN) {
        return new PartialMatcher_INTEGER<>(null, null, BOOLEAN);
      }

      public final <R> PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
        return this.BOOLEAN(() -> r);
      }

      public final <R> PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER) {
        return new PartialMatcher_LONG<>(null, null, null, INTEGER);
      }

      public final <R> PartialMatcher_LONG<R> INTEGER_(R r) {
        return this.INTEGER(() -> r);
      }

      public final <R> PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG) {
        return new PartialMatcher_DOUBLE<>(null, null, null, null, LONG);
      }

      public final <R> PartialMatcher_DOUBLE<R> LONG_(R r) {
        return this.LONG(() -> r);
      }

      public final <R> PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE) {
        return new PartialMatcher_DATE<>(null, null, null, null, null, DOUBLE);
      }

      public final <R> PartialMatcher_DATE<R> DOUBLE_(R r) {
        return this.DOUBLE(() -> r);
      }

      public final <R> PartialMatcher_ENUM<R> DATE(Supplier<R> DATE) {
        return new PartialMatcher_ENUM<>(null, null, null, null, null, null, DATE);
      }

      public final <R> PartialMatcher_ENUM<R> DATE_(R r) {
        return this.DATE(() -> r);
      }

      public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM) {
        return new PartialMatcher_ITEMDEFINITION<>(null, null, null, null, null, null, null, ENUM);
      }

      public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
        return this.ENUM((className) -> r);
      }

      public final <R> PartialMatcher<R> ITEMDEFINITION(
          Function<ItemDefinition, R> ITEMDEFINITION) {
        return new PartialMatcher<>(null, null, null, null, null, null, null, null, ITEMDEFINITION);
      }

      public final <R> PartialMatcher<R> ITEMDEFINITION_(R r) {
        return this.ITEMDEFINITION((itemDefinition) -> r);
      }
    }

    public static final class TotalMatcher_STRING<R> extends PartialMatcher_BOOLEAN<R> {
      TotalMatcher_STRING(Supplier<R> TOP) {
        super(TOP, null);
      }

      public final TotalMatcher_BOOLEAN<R> STRING(Supplier<R> STRING) {
        return new TotalMatcher_BOOLEAN<>(((PartialMatcher<R>) this).TOP, STRING);
      }

      public final TotalMatcher_BOOLEAN<R> STRING_(R r) {
        return this.STRING(() -> r);
      }
    }

    public static final class TotalMatcher_BOOLEAN<R> extends PartialMatcher_INTEGER<R> {
      TotalMatcher_BOOLEAN(Supplier<R> TOP, Supplier<R> STRING) {
        super(TOP, STRING, null);
      }

      public final TotalMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN) {
        return new TotalMatcher_INTEGER<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, BOOLEAN);
      }

      public final TotalMatcher_INTEGER<R> BOOLEAN_(R r) {
        return this.BOOLEAN(() -> r);
      }
    }

    public static final class TotalMatcher_INTEGER<R> extends PartialMatcher_LONG<R> {
      TotalMatcher_INTEGER(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN) {
        super(TOP, STRING, BOOLEAN, null);
      }

      public final TotalMatcher_LONG<R> INTEGER(Supplier<R> INTEGER) {
        return new TotalMatcher_LONG<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, INTEGER);
      }

      public final TotalMatcher_LONG<R> INTEGER_(R r) {
        return this.INTEGER(() -> r);
      }
    }

    public static final class TotalMatcher_LONG<R> extends PartialMatcher_DOUBLE<R> {
      TotalMatcher_LONG(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER) {
        super(TOP, STRING, BOOLEAN, INTEGER, null);
      }

      public final TotalMatcher_DOUBLE<R> LONG(Supplier<R> LONG) {
        return new TotalMatcher_DOUBLE<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, LONG);
      }

      public final TotalMatcher_DOUBLE<R> LONG_(R r) {
        return this.LONG(() -> r);
      }
    }

    public static final class TotalMatcher_DOUBLE<R> extends PartialMatcher_DATE<R> {
      TotalMatcher_DOUBLE(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, null);
      }

      public final TotalMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE) {
        return new TotalMatcher_DATE<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, DOUBLE);
      }

      public final TotalMatcher_DATE<R> DOUBLE_(R r) {
        return this.DOUBLE(() -> r);
      }
    }

    public static final class TotalMatcher_DATE<R> extends PartialMatcher_ENUM<R> {
      TotalMatcher_DATE(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, null);
      }

      public final TotalMatcher_ENUM<R> DATE(Supplier<R> DATE) {
        return new TotalMatcher_ENUM<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, DATE);
      }

      public final TotalMatcher_ENUM<R> DATE_(R r) {
        return this.DATE(() -> r);
      }
    }

    public static final class TotalMatcher_ENUM<R> extends PartialMatcher_ITEMDEFINITION<R> {
      TotalMatcher_ENUM(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE, Supplier<R> DATE) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, null);
      }

      public final TotalMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM) {
        return new TotalMatcher_ITEMDEFINITION<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ENUM);
      }

      public final TotalMatcher_ITEMDEFINITION<R> ENUM_(R r) {
        return this.ENUM((className) -> r);
      }
    }

    public static final class TotalMatcher_ITEMDEFINITION<R> extends PartialMatcher<R> {
      TotalMatcher_ITEMDEFINITION(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE, Supplier<R> DATE,
          Function<String, R> ENUM) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, ENUM, null);
      }

      public final Function<ExpressionType, R> ITEMDEFINITION(
          Function<ItemDefinition, R> ITEMDEFINITION) {
        ExpressionType.Cases<R> cases = ExpressionTypes.cases(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ((PartialMatcher<R>) this).ENUM, ITEMDEFINITION);
        return expressionType -> expressionType.match(cases);
      }

      public final Function<ExpressionType, R> ITEMDEFINITION_(R r) {
        return this.ITEMDEFINITION((itemDefinition) -> r);
      }
    }

    public static class PartialMatcher_BOOLEAN<R> extends PartialMatcher_INTEGER<R> {
      PartialMatcher_BOOLEAN(Supplier<R> TOP, Supplier<R> STRING) {
        super(TOP, STRING, null);
      }

      public final PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN) {
        return new PartialMatcher_INTEGER<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, BOOLEAN);
      }

      public final PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
        return this.BOOLEAN(() -> r);
      }
    }

    public static class PartialMatcher_INTEGER<R> extends PartialMatcher_LONG<R> {
      PartialMatcher_INTEGER(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN) {
        super(TOP, STRING, BOOLEAN, null);
      }

      public final PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER) {
        return new PartialMatcher_LONG<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, INTEGER);
      }

      public final PartialMatcher_LONG<R> INTEGER_(R r) {
        return this.INTEGER(() -> r);
      }
    }

    public static class PartialMatcher_LONG<R> extends PartialMatcher_DOUBLE<R> {
      PartialMatcher_LONG(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER) {
        super(TOP, STRING, BOOLEAN, INTEGER, null);
      }

      public final PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG) {
        return new PartialMatcher_DOUBLE<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, LONG);
      }

      public final PartialMatcher_DOUBLE<R> LONG_(R r) {
        return this.LONG(() -> r);
      }
    }

    public static class PartialMatcher_DOUBLE<R> extends PartialMatcher_DATE<R> {
      PartialMatcher_DOUBLE(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, null);
      }

      public final PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE) {
        return new PartialMatcher_DATE<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, DOUBLE);
      }

      public final PartialMatcher_DATE<R> DOUBLE_(R r) {
        return this.DOUBLE(() -> r);
      }
    }

    public static class PartialMatcher_DATE<R> extends PartialMatcher_ENUM<R> {
      PartialMatcher_DATE(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, null);
      }

      public final PartialMatcher_ENUM<R> DATE(Supplier<R> DATE) {
        return new PartialMatcher_ENUM<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, DATE);
      }

      public final PartialMatcher_ENUM<R> DATE_(R r) {
        return this.DATE(() -> r);
      }
    }

    public static class PartialMatcher_ENUM<R> extends PartialMatcher_ITEMDEFINITION<R> {
      PartialMatcher_ENUM(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE, Supplier<R> DATE) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, null);
      }

      public final PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM) {
        return new PartialMatcher_ITEMDEFINITION<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ENUM);
      }

      public final PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
        return this.ENUM((className) -> r);
      }
    }

    public static class PartialMatcher_ITEMDEFINITION<R> extends PartialMatcher<R> {
      PartialMatcher_ITEMDEFINITION(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN,
          Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE, Supplier<R> DATE,
          Function<String, R> ENUM) {
        super(TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, ENUM, null);
      }

      public final PartialMatcher<R> ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION) {
        return new PartialMatcher<>(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ((PartialMatcher<R>) this).ENUM, ITEMDEFINITION);
      }

      public final PartialMatcher<R> ITEMDEFINITION_(R r) {
        return this.ITEMDEFINITION((itemDefinition) -> r);
      }
    }

    public static class PartialMatcher<R> {
      private final Supplier<R> TOP;

      private final Supplier<R> STRING;

      private final Supplier<R> BOOLEAN;

      private final Supplier<R> INTEGER;

      private final Supplier<R> LONG;

      private final Supplier<R> DOUBLE;

      private final Supplier<R> DATE;

      private final Function<String, R> ENUM;

      private final Function<ItemDefinition, R> ITEMDEFINITION;

      PartialMatcher(Supplier<R> TOP, Supplier<R> STRING, Supplier<R> BOOLEAN, Supplier<R> INTEGER,
          Supplier<R> LONG, Supplier<R> DOUBLE, Supplier<R> DATE, Function<String, R> ENUM,
          Function<ItemDefinition, R> ITEMDEFINITION) {
        this.TOP = TOP;
        this.STRING = STRING;
        this.BOOLEAN = BOOLEAN;
        this.INTEGER = INTEGER;
        this.LONG = LONG;
        this.DOUBLE = DOUBLE;
        this.DATE = DATE;
        this.ENUM = ENUM;
        this.ITEMDEFINITION = ITEMDEFINITION;
      }

      public final Function<ExpressionType, R> otherwise(Supplier<R> otherwise) {
        ExpressionType.Cases<R> cases = ExpressionTypes.<R>cases(this.TOP != null ? this.TOP : () -> otherwise.get(),
            this.STRING != null ? this.STRING : () -> otherwise.get(),
            this.BOOLEAN != null ? this.BOOLEAN : () -> otherwise.get(),
            this.INTEGER != null ? this.INTEGER : () -> otherwise.get(),
            this.LONG != null ? this.LONG : () -> otherwise.get(),
            this.DOUBLE != null ? this.DOUBLE : () -> otherwise.get(),
            this.DATE != null ? this.DATE : () -> otherwise.get(),
            this.ENUM != null ? this.ENUM : (className) -> otherwise.get(),
            this.ITEMDEFINITION != null ? this.ITEMDEFINITION : (itemDefinition) -> otherwise.get());
        return expressionType -> expressionType.match(cases);
      }

      public final Function<ExpressionType, R> otherwise_(R r) {
        return this.otherwise(() -> r);
      }

      public final Function<ExpressionType, Optional<R>> otherwiseEmpty() {
        ExpressionType.Cases<Optional<R>> cases = ExpressionTypes.cases((this.TOP != null) ? () -> Optional.of(this.TOP.get())
            : () -> Optional.empty(),
            (this.STRING != null) ? () -> Optional.of(this.STRING.get())
            : () -> Optional.empty(),
            (this.BOOLEAN != null) ? () -> Optional.of(this.BOOLEAN.get())
            : () -> Optional.empty(),
            (this.INTEGER != null) ? () -> Optional.of(this.INTEGER.get())
            : () -> Optional.empty(),
            (this.LONG != null) ? () -> Optional.of(this.LONG.get())
            : () -> Optional.empty(),
            (this.DOUBLE != null) ? () -> Optional.of(this.DOUBLE.get())
            : () -> Optional.empty(),
            (this.DATE != null) ? () -> Optional.of(this.DATE.get())
            : () -> Optional.empty(),
            (this.ENUM != null) ? (className) -> Optional.of(this.ENUM.apply(className))
            : (className) -> Optional.empty(),
            (this.ITEMDEFINITION != null) ? (itemDefinition) -> Optional.of(this.ITEMDEFINITION.apply(itemDefinition))
            : (itemDefinition) -> Optional.empty());
        return expressionType -> expressionType.match(cases);
      }
    }
  }

  public static class CaseOfMatchers {
    private CaseOfMatchers() {
    }

    public static final class TotalMatcher_TOP {
      private final ExpressionType _expressionType;

      TotalMatcher_TOP(ExpressionType _expressionType) {
        this._expressionType = _expressionType;
      }

      public final <R> TotalMatcher_STRING<R> TOP(Supplier<R> TOP) {
        return new TotalMatcher_STRING<>(this._expressionType, TOP);
      }

      public final <R> TotalMatcher_STRING<R> TOP_(R r) {
        return this.TOP(() -> r);
      }

      public final <R> PartialMatcher_BOOLEAN<R> STRING(Supplier<R> STRING) {
        return new PartialMatcher_BOOLEAN<>(this._expressionType, null, STRING);
      }

      public final <R> PartialMatcher_BOOLEAN<R> STRING_(R r) {
        return this.STRING(() -> r);
      }

      public final <R> PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN) {
        return new PartialMatcher_INTEGER<>(this._expressionType, null, null, BOOLEAN);
      }

      public final <R> PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
        return this.BOOLEAN(() -> r);
      }

      public final <R> PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER) {
        return new PartialMatcher_LONG<>(this._expressionType, null, null, null, INTEGER);
      }

      public final <R> PartialMatcher_LONG<R> INTEGER_(R r) {
        return this.INTEGER(() -> r);
      }

      public final <R> PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG) {
        return new PartialMatcher_DOUBLE<>(this._expressionType, null, null, null, null, LONG);
      }

      public final <R> PartialMatcher_DOUBLE<R> LONG_(R r) {
        return this.LONG(() -> r);
      }

      public final <R> PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE) {
        return new PartialMatcher_DATE<>(this._expressionType, null, null, null, null, null, DOUBLE);
      }

      public final <R> PartialMatcher_DATE<R> DOUBLE_(R r) {
        return this.DOUBLE(() -> r);
      }

      public final <R> PartialMatcher_ENUM<R> DATE(Supplier<R> DATE) {
        return new PartialMatcher_ENUM<>(this._expressionType, null, null, null, null, null, null, DATE);
      }

      public final <R> PartialMatcher_ENUM<R> DATE_(R r) {
        return this.DATE(() -> r);
      }

      public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM) {
        return new PartialMatcher_ITEMDEFINITION<>(this._expressionType, null, null, null, null, null, null, null, ENUM);
      }

      public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
        return this.ENUM((className) -> r);
      }

      public final <R> PartialMatcher<R> ITEMDEFINITION(
          Function<ItemDefinition, R> ITEMDEFINITION) {
        return new PartialMatcher<>(this._expressionType, null, null, null, null, null, null, null, null, ITEMDEFINITION);
      }

      public final <R> PartialMatcher<R> ITEMDEFINITION_(R r) {
        return this.ITEMDEFINITION((itemDefinition) -> r);
      }
    }

    public static final class TotalMatcher_STRING<R> extends PartialMatcher_BOOLEAN<R> {
      TotalMatcher_STRING(ExpressionType _expressionType, Supplier<R> TOP) {
        super(_expressionType, TOP, null);
      }

      public final TotalMatcher_BOOLEAN<R> STRING(Supplier<R> STRING) {
        return new TotalMatcher_BOOLEAN<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, STRING);
      }

      public final TotalMatcher_BOOLEAN<R> STRING_(R r) {
        return this.STRING(() -> r);
      }
    }

    public static final class TotalMatcher_BOOLEAN<R> extends PartialMatcher_INTEGER<R> {
      TotalMatcher_BOOLEAN(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING) {
        super(_expressionType, TOP, STRING, null);
      }

      public final TotalMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN) {
        return new TotalMatcher_INTEGER<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, BOOLEAN);
      }

      public final TotalMatcher_INTEGER<R> BOOLEAN_(R r) {
        return this.BOOLEAN(() -> r);
      }
    }

    public static final class TotalMatcher_INTEGER<R> extends PartialMatcher_LONG<R> {
      TotalMatcher_INTEGER(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN) {
        super(_expressionType, TOP, STRING, BOOLEAN, null);
      }

      public final TotalMatcher_LONG<R> INTEGER(Supplier<R> INTEGER) {
        return new TotalMatcher_LONG<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, INTEGER);
      }

      public final TotalMatcher_LONG<R> INTEGER_(R r) {
        return this.INTEGER(() -> r);
      }
    }

    public static final class TotalMatcher_LONG<R> extends PartialMatcher_DOUBLE<R> {
      TotalMatcher_LONG(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, null);
      }

      public final TotalMatcher_DOUBLE<R> LONG(Supplier<R> LONG) {
        return new TotalMatcher_DOUBLE<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, LONG);
      }

      public final TotalMatcher_DOUBLE<R> LONG_(R r) {
        return this.LONG(() -> r);
      }
    }

    public static final class TotalMatcher_DOUBLE<R> extends PartialMatcher_DATE<R> {
      TotalMatcher_DOUBLE(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, null);
      }

      public final TotalMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE) {
        return new TotalMatcher_DATE<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, DOUBLE);
      }

      public final TotalMatcher_DATE<R> DOUBLE_(R r) {
        return this.DOUBLE(() -> r);
      }
    }

    public static final class TotalMatcher_DATE<R> extends PartialMatcher_ENUM<R> {
      TotalMatcher_DATE(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, null);
      }

      public final TotalMatcher_ENUM<R> DATE(Supplier<R> DATE) {
        return new TotalMatcher_ENUM<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, DATE);
      }

      public final TotalMatcher_ENUM<R> DATE_(R r) {
        return this.DATE(() -> r);
      }
    }

    public static final class TotalMatcher_ENUM<R> extends PartialMatcher_ITEMDEFINITION<R> {
      TotalMatcher_ENUM(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE,
          Supplier<R> DATE) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, null);
      }

      public final TotalMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM) {
        return new TotalMatcher_ITEMDEFINITION<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ENUM);
      }

      public final TotalMatcher_ITEMDEFINITION<R> ENUM_(R r) {
        return this.ENUM((className) -> r);
      }
    }

    public static final class TotalMatcher_ITEMDEFINITION<R> extends PartialMatcher<R> {
      TotalMatcher_ITEMDEFINITION(ExpressionType _expressionType, Supplier<R> TOP,
          Supplier<R> STRING, Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG,
          Supplier<R> DOUBLE, Supplier<R> DATE, Function<String, R> ENUM) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, ENUM, null);
      }

      public final R ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION) {
        ExpressionType.Cases<R> cases = ExpressionTypes.cases(((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ((PartialMatcher<R>) this).ENUM, ITEMDEFINITION);
        return ((PartialMatcher<R>) this)._expressionType.match(cases);
      }

      public final R ITEMDEFINITION_(R r) {
        return this.ITEMDEFINITION((itemDefinition) -> r);
      }
    }

    public static class PartialMatcher_BOOLEAN<R> extends PartialMatcher_INTEGER<R> {
      PartialMatcher_BOOLEAN(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING) {
        super(_expressionType, TOP, STRING, null);
      }

      public final PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN) {
        return new PartialMatcher_INTEGER<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, BOOLEAN);
      }

      public final PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
        return this.BOOLEAN(() -> r);
      }
    }

    public static class PartialMatcher_INTEGER<R> extends PartialMatcher_LONG<R> {
      PartialMatcher_INTEGER(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN) {
        super(_expressionType, TOP, STRING, BOOLEAN, null);
      }

      public final PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER) {
        return new PartialMatcher_LONG<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, INTEGER);
      }

      public final PartialMatcher_LONG<R> INTEGER_(R r) {
        return this.INTEGER(() -> r);
      }
    }

    public static class PartialMatcher_LONG<R> extends PartialMatcher_DOUBLE<R> {
      PartialMatcher_LONG(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, null);
      }

      public final PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG) {
        return new PartialMatcher_DOUBLE<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, LONG);
      }

      public final PartialMatcher_DOUBLE<R> LONG_(R r) {
        return this.LONG(() -> r);
      }
    }

    public static class PartialMatcher_DOUBLE<R> extends PartialMatcher_DATE<R> {
      PartialMatcher_DOUBLE(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, null);
      }

      public final PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE) {
        return new PartialMatcher_DATE<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, DOUBLE);
      }

      public final PartialMatcher_DATE<R> DOUBLE_(R r) {
        return this.DOUBLE(() -> r);
      }
    }

    public static class PartialMatcher_DATE<R> extends PartialMatcher_ENUM<R> {
      PartialMatcher_DATE(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, null);
      }

      public final PartialMatcher_ENUM<R> DATE(Supplier<R> DATE) {
        return new PartialMatcher_ENUM<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, DATE);
      }

      public final PartialMatcher_ENUM<R> DATE_(R r) {
        return this.DATE(() -> r);
      }
    }

    public static class PartialMatcher_ENUM<R> extends PartialMatcher_ITEMDEFINITION<R> {
      PartialMatcher_ENUM(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE,
          Supplier<R> DATE) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, null);
      }

      public final PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM) {
        return new PartialMatcher_ITEMDEFINITION<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ENUM);
      }

      public final PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
        return this.ENUM((className) -> r);
      }
    }

    public static class PartialMatcher_ITEMDEFINITION<R> extends PartialMatcher<R> {
      PartialMatcher_ITEMDEFINITION(ExpressionType _expressionType, Supplier<R> TOP,
          Supplier<R> STRING, Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG,
          Supplier<R> DOUBLE, Supplier<R> DATE, Function<String, R> ENUM) {
        super(_expressionType, TOP, STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, ENUM, null);
      }

      public final PartialMatcher<R> ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION) {
        return new PartialMatcher<>(((PartialMatcher<R>) this)._expressionType, ((PartialMatcher<R>) this).TOP, ((PartialMatcher<R>) this).STRING, ((PartialMatcher<R>) this).BOOLEAN, ((PartialMatcher<R>) this).INTEGER, ((PartialMatcher<R>) this).LONG, ((PartialMatcher<R>) this).DOUBLE, ((PartialMatcher<R>) this).DATE, ((PartialMatcher<R>) this).ENUM, ITEMDEFINITION);
      }

      public final PartialMatcher<R> ITEMDEFINITION_(R r) {
        return this.ITEMDEFINITION((itemDefinition) -> r);
      }
    }

    public static class PartialMatcher<R> {
      private final ExpressionType _expressionType;

      private final Supplier<R> TOP;

      private final Supplier<R> STRING;

      private final Supplier<R> BOOLEAN;

      private final Supplier<R> INTEGER;

      private final Supplier<R> LONG;

      private final Supplier<R> DOUBLE;

      private final Supplier<R> DATE;

      private final Function<String, R> ENUM;

      private final Function<ItemDefinition, R> ITEMDEFINITION;

      PartialMatcher(ExpressionType _expressionType, Supplier<R> TOP, Supplier<R> STRING,
          Supplier<R> BOOLEAN, Supplier<R> INTEGER, Supplier<R> LONG, Supplier<R> DOUBLE,
          Supplier<R> DATE, Function<String, R> ENUM, Function<ItemDefinition, R> ITEMDEFINITION) {
        this._expressionType = _expressionType;
        this.TOP = TOP;
        this.STRING = STRING;
        this.BOOLEAN = BOOLEAN;
        this.INTEGER = INTEGER;
        this.LONG = LONG;
        this.DOUBLE = DOUBLE;
        this.DATE = DATE;
        this.ENUM = ENUM;
        this.ITEMDEFINITION = ITEMDEFINITION;
      }

      public final R otherwise(Supplier<R> otherwise) {
        ExpressionType.Cases<R> cases = ExpressionTypes.<R>cases(this.TOP != null ? this.TOP : () -> otherwise.get(),
            this.STRING != null ? this.STRING : () -> otherwise.get(),
            this.BOOLEAN != null ? this.BOOLEAN : () -> otherwise.get(),
            this.INTEGER != null ? this.INTEGER : () -> otherwise.get(),
            this.LONG != null ? this.LONG : () -> otherwise.get(),
            this.DOUBLE != null ? this.DOUBLE : () -> otherwise.get(),
            this.DATE != null ? this.DATE : () -> otherwise.get(),
            this.ENUM != null ? this.ENUM : (className) -> otherwise.get(),
            this.ITEMDEFINITION != null ? this.ITEMDEFINITION : (itemDefinition) -> otherwise.get());
        return this._expressionType.match(cases);
      }

      public final R otherwise_(R r) {
        return this.otherwise(() -> r);
      }

      public final Optional<R> otherwiseEmpty() {
        ExpressionType.Cases<Optional<R>> cases = ExpressionTypes.cases((this.TOP != null) ? () -> Optional.of(this.TOP.get())
            : () -> Optional.empty(),
            (this.STRING != null) ? () -> Optional.of(this.STRING.get())
            : () -> Optional.empty(),
            (this.BOOLEAN != null) ? () -> Optional.of(this.BOOLEAN.get())
            : () -> Optional.empty(),
            (this.INTEGER != null) ? () -> Optional.of(this.INTEGER.get())
            : () -> Optional.empty(),
            (this.LONG != null) ? () -> Optional.of(this.LONG.get())
            : () -> Optional.empty(),
            (this.DOUBLE != null) ? () -> Optional.of(this.DOUBLE.get())
            : () -> Optional.empty(),
            (this.DATE != null) ? () -> Optional.of(this.DATE.get())
            : () -> Optional.empty(),
            (this.ENUM != null) ? (className) -> Optional.of(this.ENUM.apply(className))
            : (className) -> Optional.empty(),
            (this.ITEMDEFINITION != null) ? (itemDefinition) -> Optional.of(this.ITEMDEFINITION.apply(itemDefinition))
            : (itemDefinition) -> Optional.empty());
        return this._expressionType.match(cases);
      }
    }
  }
}
