/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.feel;

import de.redsix.dmncheck.feel.ExpressionType;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.camunda.bpm.model.dmn.instance.ItemDefinition;

public final class ExpressionTypes {
    private static ExpressionType TOP;
    private static ExpressionType STRING;
    private static ExpressionType BOOLEAN;
    private static ExpressionType INTEGER;
    private static ExpressionType LONG;
    private static ExpressionType DOUBLE;
    private static ExpressionType DATE;
    private static final ExpressionType.Cases<Optional<String>> classNameGetter;
    private static final ExpressionType.Cases<Optional<ItemDefinition>> itemDefinitionGetter;

    private ExpressionTypes() {
    }

    public static <R> ExpressionType.Cases<R> cases(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2, Function<ItemDefinition, R> ITEMDEFINITION2) {
        return new LambdaCases<R>(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, ENUM2, ITEMDEFINITION2);
    }

    public static ExpressionType TOP() {
        ExpressionType _TOP = TOP;
        if (_TOP == null) {
            TOP = _TOP = new TOP();
        }
        return _TOP;
    }

    public static ExpressionType STRING() {
        ExpressionType _STRING = STRING;
        if (_STRING == null) {
            STRING = _STRING = new STRING();
        }
        return _STRING;
    }

    public static ExpressionType BOOLEAN() {
        ExpressionType _BOOLEAN = BOOLEAN;
        if (_BOOLEAN == null) {
            BOOLEAN = _BOOLEAN = new BOOLEAN();
        }
        return _BOOLEAN;
    }

    public static ExpressionType INTEGER() {
        ExpressionType _INTEGER = INTEGER;
        if (_INTEGER == null) {
            INTEGER = _INTEGER = new INTEGER();
        }
        return _INTEGER;
    }

    public static ExpressionType LONG() {
        ExpressionType _LONG = LONG;
        if (_LONG == null) {
            LONG = _LONG = new LONG();
        }
        return _LONG;
    }

    public static ExpressionType DOUBLE() {
        ExpressionType _DOUBLE = DOUBLE;
        if (_DOUBLE == null) {
            DOUBLE = _DOUBLE = new DOUBLE();
        }
        return _DOUBLE;
    }

    public static ExpressionType DATE() {
        ExpressionType _DATE = DATE;
        if (_DATE == null) {
            DATE = _DATE = new DATE();
        }
        return _DATE;
    }

    public static ExpressionType ENUM(String className) {
        return new ENUM(className);
    }

    public static ExpressionType ITEMDEFINITION(ItemDefinition itemDefinition) {
        return new ITEMDEFINITION(itemDefinition);
    }

    public static ExpressionType lazy(Supplier<ExpressionType> expressionType) {
        return new Lazy(expressionType);
    }

    public static CasesMatchers.TotalMatcher_TOP cases() {
        return CasesMatchers.totalMatcher_TOP;
    }

    public static CaseOfMatchers.TotalMatcher_TOP caseOf(ExpressionType expressionType) {
        return new CaseOfMatchers.TotalMatcher_TOP(expressionType);
    }

    public static Optional<String> getClassName(ExpressionType expressionType) {
        return expressionType.match(classNameGetter);
    }

    public static Optional<ItemDefinition> getItemDefinition(ExpressionType expressionType) {
        return expressionType.match(itemDefinitionGetter);
    }

    public static Function<ExpressionType, ExpressionType> setClassName(String newClassName) {
        return ExpressionTypes.modClassName(__ -> newClassName);
    }

    public static Function<ExpressionType, ExpressionType> modClassName(Function<String, String> classNameMod) {
        ExpressionType.Cases<ExpressionType> cases = ExpressionTypes.cases(ExpressionTypes::TOP, ExpressionTypes::STRING, ExpressionTypes::BOOLEAN, ExpressionTypes::INTEGER, ExpressionTypes::LONG, ExpressionTypes::DOUBLE, ExpressionTypes::DATE, className -> ExpressionTypes.ENUM((String)classNameMod.apply((String)className)), ExpressionTypes::ITEMDEFINITION);
        return expressionType -> (ExpressionType)expressionType.match(cases);
    }

    public static Function<ExpressionType, ExpressionType> setItemDefinition(ItemDefinition newItemDefinition) {
        return ExpressionTypes.modItemDefinition(__ -> newItemDefinition);
    }

    public static Function<ExpressionType, ExpressionType> modItemDefinition(Function<ItemDefinition, ItemDefinition> itemDefinitionMod) {
        ExpressionType.Cases<ExpressionType> cases = ExpressionTypes.cases(ExpressionTypes::TOP, ExpressionTypes::STRING, ExpressionTypes::BOOLEAN, ExpressionTypes::INTEGER, ExpressionTypes::LONG, ExpressionTypes::DOUBLE, ExpressionTypes::DATE, ExpressionTypes::ENUM, itemDefinition -> ExpressionTypes.ITEMDEFINITION((ItemDefinition)itemDefinitionMod.apply((ItemDefinition)itemDefinition)));
        return expressionType -> (ExpressionType)expressionType.match(cases);
    }

    static {
        classNameGetter = ExpressionTypes.cases(() -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), className -> Optional.of(className), itemDefinition -> Optional.empty());
        itemDefinitionGetter = ExpressionTypes.cases(() -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), () -> Optional.empty(), className -> Optional.empty(), itemDefinition -> Optional.of(itemDefinition));
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<R> {
            private final ExpressionType _expressionType;
            private final Supplier<R> TOP;
            private final Supplier<R> STRING;
            private final Supplier<R> BOOLEAN;
            private final Supplier<R> INTEGER;
            private final Supplier<R> LONG;
            private final Supplier<R> DOUBLE;
            private final Supplier<R> DATE;
            private final Function<String, R> ENUM;
            private final Function<ItemDefinition, R> ITEMDEFINITION;

            PartialMatcher(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2, Function<ItemDefinition, R> ITEMDEFINITION2) {
                this._expressionType = _expressionType;
                this.TOP = TOP2;
                this.STRING = STRING2;
                this.BOOLEAN = BOOLEAN2;
                this.INTEGER = INTEGER2;
                this.LONG = LONG2;
                this.DOUBLE = DOUBLE2;
                this.DATE = DATE2;
                this.ENUM = ENUM2;
                this.ITEMDEFINITION = ITEMDEFINITION2;
            }

            public final R otherwise(Supplier<R> otherwise) {
                ExpressionType.Cases<R> cases = ExpressionTypes.cases(this.TOP != null ? this.TOP : () -> otherwise.get(), this.STRING != null ? this.STRING : () -> otherwise.get(), this.BOOLEAN != null ? this.BOOLEAN : () -> otherwise.get(), this.INTEGER != null ? this.INTEGER : () -> otherwise.get(), this.LONG != null ? this.LONG : () -> otherwise.get(), this.DOUBLE != null ? this.DOUBLE : () -> otherwise.get(), this.DATE != null ? this.DATE : () -> otherwise.get(), this.ENUM != null ? this.ENUM : className -> otherwise.get(), this.ITEMDEFINITION != null ? this.ITEMDEFINITION : itemDefinition -> otherwise.get());
                return this._expressionType.match(cases);
            }

            public final R otherwise_(R r) {
                return (R)this.otherwise(() -> r);
            }

            public final Optional<R> otherwiseEmpty() {
                ExpressionType.Cases<Optional> cases = ExpressionTypes.cases(this.TOP != null ? () -> Optional.of(this.TOP.get()) : () -> Optional.empty(), this.STRING != null ? () -> Optional.of(this.STRING.get()) : () -> Optional.empty(), this.BOOLEAN != null ? () -> Optional.of(this.BOOLEAN.get()) : () -> Optional.empty(), this.INTEGER != null ? () -> Optional.of(this.INTEGER.get()) : () -> Optional.empty(), this.LONG != null ? () -> Optional.of(this.LONG.get()) : () -> Optional.empty(), this.DOUBLE != null ? () -> Optional.of(this.DOUBLE.get()) : () -> Optional.empty(), this.DATE != null ? () -> Optional.of(this.DATE.get()) : () -> Optional.empty(), this.ENUM != null ? className -> Optional.of(this.ENUM.apply((String)className)) : className -> Optional.empty(), this.ITEMDEFINITION != null ? itemDefinition -> Optional.of(this.ITEMDEFINITION.apply((ItemDefinition)itemDefinition)) : itemDefinition -> Optional.empty());
                return this._expressionType.match(cases);
            }
        }

        public static class PartialMatcher_ITEMDEFINITION<R>
        extends PartialMatcher<R> {
            PartialMatcher_ITEMDEFINITION(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, ENUM2, null);
            }

            public final PartialMatcher<R> ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION2) {
                return new PartialMatcher<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ((PartialMatcher)this).ENUM, ITEMDEFINITION2);
            }

            public final PartialMatcher<R> ITEMDEFINITION_(R r) {
                return this.ITEMDEFINITION(itemDefinition -> r);
            }
        }

        public static class PartialMatcher_ENUM<R>
        extends PartialMatcher_ITEMDEFINITION<R> {
            PartialMatcher_ENUM(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, null);
            }

            public final PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM2) {
                return new PartialMatcher_ITEMDEFINITION<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ENUM2);
            }

            public final PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
                return this.ENUM(className -> r);
            }
        }

        public static class PartialMatcher_DATE<R>
        extends PartialMatcher_ENUM<R> {
            PartialMatcher_DATE(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, null);
            }

            public final PartialMatcher_ENUM<R> DATE(Supplier<R> DATE2) {
                return new PartialMatcher_ENUM<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, DATE2);
            }

            public final PartialMatcher_ENUM<R> DATE_(R r) {
                return this.DATE(() -> r);
            }
        }

        public static class PartialMatcher_DOUBLE<R>
        extends PartialMatcher_DATE<R> {
            PartialMatcher_DOUBLE(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, null);
            }

            public final PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE2) {
                return new PartialMatcher_DATE<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, DOUBLE2);
            }

            public final PartialMatcher_DATE<R> DOUBLE_(R r) {
                return this.DOUBLE(() -> r);
            }
        }

        public static class PartialMatcher_LONG<R>
        extends PartialMatcher_DOUBLE<R> {
            PartialMatcher_LONG(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, null);
            }

            public final PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG2) {
                return new PartialMatcher_DOUBLE<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, LONG2);
            }

            public final PartialMatcher_DOUBLE<R> LONG_(R r) {
                return this.LONG(() -> r);
            }
        }

        public static class PartialMatcher_INTEGER<R>
        extends PartialMatcher_LONG<R> {
            PartialMatcher_INTEGER(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, null);
            }

            public final PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER2) {
                return new PartialMatcher_LONG<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, INTEGER2);
            }

            public final PartialMatcher_LONG<R> INTEGER_(R r) {
                return this.INTEGER(() -> r);
            }
        }

        public static class PartialMatcher_BOOLEAN<R>
        extends PartialMatcher_INTEGER<R> {
            PartialMatcher_BOOLEAN(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2) {
                super(_expressionType, TOP2, STRING2, null);
            }

            public final PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN2) {
                return new PartialMatcher_INTEGER<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, BOOLEAN2);
            }

            public final PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
                return this.BOOLEAN(() -> r);
            }
        }

        public static final class TotalMatcher_ITEMDEFINITION<R>
        extends PartialMatcher<R> {
            TotalMatcher_ITEMDEFINITION(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, ENUM2, null);
            }

            public final R ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION2) {
                ExpressionType.Cases<R> cases = ExpressionTypes.cases(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ((PartialMatcher)this).ENUM, ITEMDEFINITION2);
                return ((PartialMatcher)this)._expressionType.match(cases);
            }

            public final R ITEMDEFINITION_(R r) {
                return (R)this.ITEMDEFINITION(itemDefinition -> r);
            }
        }

        public static final class TotalMatcher_ENUM<R>
        extends PartialMatcher_ITEMDEFINITION<R> {
            TotalMatcher_ENUM(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, null);
            }

            public final TotalMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM2) {
                return new TotalMatcher_ITEMDEFINITION<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ENUM2);
            }

            public final TotalMatcher_ITEMDEFINITION<R> ENUM_(R r) {
                return this.ENUM(className -> r);
            }
        }

        public static final class TotalMatcher_DATE<R>
        extends PartialMatcher_ENUM<R> {
            TotalMatcher_DATE(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, null);
            }

            public final TotalMatcher_ENUM<R> DATE(Supplier<R> DATE2) {
                return new TotalMatcher_ENUM<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, DATE2);
            }

            public final TotalMatcher_ENUM<R> DATE_(R r) {
                return this.DATE(() -> r);
            }
        }

        public static final class TotalMatcher_DOUBLE<R>
        extends PartialMatcher_DATE<R> {
            TotalMatcher_DOUBLE(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, null);
            }

            public final TotalMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE2) {
                return new TotalMatcher_DATE<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, DOUBLE2);
            }

            public final TotalMatcher_DATE<R> DOUBLE_(R r) {
                return this.DOUBLE(() -> r);
            }
        }

        public static final class TotalMatcher_LONG<R>
        extends PartialMatcher_DOUBLE<R> {
            TotalMatcher_LONG(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, INTEGER2, null);
            }

            public final TotalMatcher_DOUBLE<R> LONG(Supplier<R> LONG2) {
                return new TotalMatcher_DOUBLE<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, LONG2);
            }

            public final TotalMatcher_DOUBLE<R> LONG_(R r) {
                return this.LONG(() -> r);
            }
        }

        public static final class TotalMatcher_INTEGER<R>
        extends PartialMatcher_LONG<R> {
            TotalMatcher_INTEGER(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2) {
                super(_expressionType, TOP2, STRING2, BOOLEAN2, null);
            }

            public final TotalMatcher_LONG<R> INTEGER(Supplier<R> INTEGER2) {
                return new TotalMatcher_LONG<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, INTEGER2);
            }

            public final TotalMatcher_LONG<R> INTEGER_(R r) {
                return this.INTEGER(() -> r);
            }
        }

        public static final class TotalMatcher_BOOLEAN<R>
        extends PartialMatcher_INTEGER<R> {
            TotalMatcher_BOOLEAN(ExpressionType _expressionType, Supplier<R> TOP2, Supplier<R> STRING2) {
                super(_expressionType, TOP2, STRING2, null);
            }

            public final TotalMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN2) {
                return new TotalMatcher_INTEGER<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, BOOLEAN2);
            }

            public final TotalMatcher_INTEGER<R> BOOLEAN_(R r) {
                return this.BOOLEAN(() -> r);
            }
        }

        public static final class TotalMatcher_STRING<R>
        extends PartialMatcher_BOOLEAN<R> {
            TotalMatcher_STRING(ExpressionType _expressionType, Supplier<R> TOP2) {
                super(_expressionType, TOP2, null);
            }

            public final TotalMatcher_BOOLEAN<R> STRING(Supplier<R> STRING2) {
                return new TotalMatcher_BOOLEAN<R>(((PartialMatcher)this)._expressionType, ((PartialMatcher)this).TOP, STRING2);
            }

            public final TotalMatcher_BOOLEAN<R> STRING_(R r) {
                return this.STRING(() -> r);
            }
        }

        public static final class TotalMatcher_TOP {
            private final ExpressionType _expressionType;

            TotalMatcher_TOP(ExpressionType _expressionType) {
                this._expressionType = _expressionType;
            }

            public final <R> TotalMatcher_STRING<R> TOP(Supplier<R> TOP2) {
                return new TotalMatcher_STRING<R>(this._expressionType, TOP2);
            }

            public final <R> TotalMatcher_STRING<R> TOP_(R r) {
                return this.TOP(() -> r);
            }

            public final <R> PartialMatcher_BOOLEAN<R> STRING(Supplier<R> STRING2) {
                return new PartialMatcher_BOOLEAN<R>(this._expressionType, null, STRING2);
            }

            public final <R> PartialMatcher_BOOLEAN<R> STRING_(R r) {
                return this.STRING(() -> r);
            }

            public final <R> PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN2) {
                return new PartialMatcher_INTEGER<R>(this._expressionType, null, null, BOOLEAN2);
            }

            public final <R> PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
                return this.BOOLEAN(() -> r);
            }

            public final <R> PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER2) {
                return new PartialMatcher_LONG<R>(this._expressionType, null, null, null, INTEGER2);
            }

            public final <R> PartialMatcher_LONG<R> INTEGER_(R r) {
                return this.INTEGER(() -> r);
            }

            public final <R> PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG2) {
                return new PartialMatcher_DOUBLE<R>(this._expressionType, null, null, null, null, LONG2);
            }

            public final <R> PartialMatcher_DOUBLE<R> LONG_(R r) {
                return this.LONG(() -> r);
            }

            public final <R> PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE2) {
                return new PartialMatcher_DATE<R>(this._expressionType, null, null, null, null, null, DOUBLE2);
            }

            public final <R> PartialMatcher_DATE<R> DOUBLE_(R r) {
                return this.DOUBLE(() -> r);
            }

            public final <R> PartialMatcher_ENUM<R> DATE(Supplier<R> DATE2) {
                return new PartialMatcher_ENUM<R>(this._expressionType, null, null, null, null, null, null, DATE2);
            }

            public final <R> PartialMatcher_ENUM<R> DATE_(R r) {
                return this.DATE(() -> r);
            }

            public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM2) {
                return new PartialMatcher_ITEMDEFINITION<R>(this._expressionType, null, null, null, null, null, null, null, ENUM2);
            }

            public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
                return this.ENUM(className -> r);
            }

            public final <R> PartialMatcher<R> ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION2) {
                return new PartialMatcher<R>(this._expressionType, null, null, null, null, null, null, null, null, ITEMDEFINITION2);
            }

            public final <R> PartialMatcher<R> ITEMDEFINITION_(R r) {
                return this.ITEMDEFINITION(itemDefinition -> r);
            }
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_TOP totalMatcher_TOP = new TotalMatcher_TOP();

        private CasesMatchers() {
        }

        public static class PartialMatcher<R> {
            private final Supplier<R> TOP;
            private final Supplier<R> STRING;
            private final Supplier<R> BOOLEAN;
            private final Supplier<R> INTEGER;
            private final Supplier<R> LONG;
            private final Supplier<R> DOUBLE;
            private final Supplier<R> DATE;
            private final Function<String, R> ENUM;
            private final Function<ItemDefinition, R> ITEMDEFINITION;

            PartialMatcher(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2, Function<ItemDefinition, R> ITEMDEFINITION2) {
                this.TOP = TOP2;
                this.STRING = STRING2;
                this.BOOLEAN = BOOLEAN2;
                this.INTEGER = INTEGER2;
                this.LONG = LONG2;
                this.DOUBLE = DOUBLE2;
                this.DATE = DATE2;
                this.ENUM = ENUM2;
                this.ITEMDEFINITION = ITEMDEFINITION2;
            }

            public final Function<ExpressionType, R> otherwise(Supplier<R> otherwise) {
                ExpressionType.Cases cases = ExpressionTypes.cases(this.TOP != null ? this.TOP : () -> otherwise.get(), this.STRING != null ? this.STRING : () -> otherwise.get(), this.BOOLEAN != null ? this.BOOLEAN : () -> otherwise.get(), this.INTEGER != null ? this.INTEGER : () -> otherwise.get(), this.LONG != null ? this.LONG : () -> otherwise.get(), this.DOUBLE != null ? this.DOUBLE : () -> otherwise.get(), this.DATE != null ? this.DATE : () -> otherwise.get(), this.ENUM != null ? this.ENUM : className -> otherwise.get(), this.ITEMDEFINITION != null ? this.ITEMDEFINITION : itemDefinition -> otherwise.get());
                return expressionType -> expressionType.match(cases);
            }

            public final Function<ExpressionType, R> otherwise_(R r) {
                return this.otherwise(() -> r);
            }

            public final Function<ExpressionType, Optional<R>> otherwiseEmpty() {
                ExpressionType.Cases<Optional> cases = ExpressionTypes.cases(this.TOP != null ? () -> Optional.of(this.TOP.get()) : () -> Optional.empty(), this.STRING != null ? () -> Optional.of(this.STRING.get()) : () -> Optional.empty(), this.BOOLEAN != null ? () -> Optional.of(this.BOOLEAN.get()) : () -> Optional.empty(), this.INTEGER != null ? () -> Optional.of(this.INTEGER.get()) : () -> Optional.empty(), this.LONG != null ? () -> Optional.of(this.LONG.get()) : () -> Optional.empty(), this.DOUBLE != null ? () -> Optional.of(this.DOUBLE.get()) : () -> Optional.empty(), this.DATE != null ? () -> Optional.of(this.DATE.get()) : () -> Optional.empty(), this.ENUM != null ? className -> Optional.of(this.ENUM.apply((String)className)) : className -> Optional.empty(), this.ITEMDEFINITION != null ? itemDefinition -> Optional.of(this.ITEMDEFINITION.apply((ItemDefinition)itemDefinition)) : itemDefinition -> Optional.empty());
                return expressionType -> (Optional)expressionType.match(cases);
            }
        }

        public static class PartialMatcher_ITEMDEFINITION<R>
        extends PartialMatcher<R> {
            PartialMatcher_ITEMDEFINITION(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, ENUM2, null);
            }

            public final PartialMatcher<R> ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION2) {
                return new PartialMatcher<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ((PartialMatcher)this).ENUM, ITEMDEFINITION2);
            }

            public final PartialMatcher<R> ITEMDEFINITION_(R r) {
                return this.ITEMDEFINITION(itemDefinition -> r);
            }
        }

        public static class PartialMatcher_ENUM<R>
        extends PartialMatcher_ITEMDEFINITION<R> {
            PartialMatcher_ENUM(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, null);
            }

            public final PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM2) {
                return new PartialMatcher_ITEMDEFINITION<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ENUM2);
            }

            public final PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
                return this.ENUM(className -> r);
            }
        }

        public static class PartialMatcher_DATE<R>
        extends PartialMatcher_ENUM<R> {
            PartialMatcher_DATE(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, null);
            }

            public final PartialMatcher_ENUM<R> DATE(Supplier<R> DATE2) {
                return new PartialMatcher_ENUM<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, DATE2);
            }

            public final PartialMatcher_ENUM<R> DATE_(R r) {
                return this.DATE(() -> r);
            }
        }

        public static class PartialMatcher_DOUBLE<R>
        extends PartialMatcher_DATE<R> {
            PartialMatcher_DOUBLE(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, null);
            }

            public final PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE2) {
                return new PartialMatcher_DATE<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, DOUBLE2);
            }

            public final PartialMatcher_DATE<R> DOUBLE_(R r) {
                return this.DOUBLE(() -> r);
            }
        }

        public static class PartialMatcher_LONG<R>
        extends PartialMatcher_DOUBLE<R> {
            PartialMatcher_LONG(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, null);
            }

            public final PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG2) {
                return new PartialMatcher_DOUBLE<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, LONG2);
            }

            public final PartialMatcher_DOUBLE<R> LONG_(R r) {
                return this.LONG(() -> r);
            }
        }

        public static class PartialMatcher_INTEGER<R>
        extends PartialMatcher_LONG<R> {
            PartialMatcher_INTEGER(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2) {
                super(TOP2, STRING2, BOOLEAN2, null);
            }

            public final PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER2) {
                return new PartialMatcher_LONG<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, INTEGER2);
            }

            public final PartialMatcher_LONG<R> INTEGER_(R r) {
                return this.INTEGER(() -> r);
            }
        }

        public static class PartialMatcher_BOOLEAN<R>
        extends PartialMatcher_INTEGER<R> {
            PartialMatcher_BOOLEAN(Supplier<R> TOP2, Supplier<R> STRING2) {
                super(TOP2, STRING2, null);
            }

            public final PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN2) {
                return new PartialMatcher_INTEGER<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, BOOLEAN2);
            }

            public final PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
                return this.BOOLEAN(() -> r);
            }
        }

        public static final class TotalMatcher_ITEMDEFINITION<R>
        extends PartialMatcher<R> {
            TotalMatcher_ITEMDEFINITION(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, ENUM2, null);
            }

            public final Function<ExpressionType, R> ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION2) {
                ExpressionType.Cases cases = ExpressionTypes.cases(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ((PartialMatcher)this).ENUM, ITEMDEFINITION2);
                return expressionType -> expressionType.match(cases);
            }

            public final Function<ExpressionType, R> ITEMDEFINITION_(R r) {
                return this.ITEMDEFINITION(itemDefinition -> r);
            }
        }

        public static final class TotalMatcher_ENUM<R>
        extends PartialMatcher_ITEMDEFINITION<R> {
            TotalMatcher_ENUM(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, DATE2, null);
            }

            public final TotalMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM2) {
                return new TotalMatcher_ITEMDEFINITION<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, ((PartialMatcher)this).DATE, ENUM2);
            }

            public final TotalMatcher_ITEMDEFINITION<R> ENUM_(R r) {
                return this.ENUM(className -> r);
            }
        }

        public static final class TotalMatcher_DATE<R>
        extends PartialMatcher_ENUM<R> {
            TotalMatcher_DATE(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, DOUBLE2, null);
            }

            public final TotalMatcher_ENUM<R> DATE(Supplier<R> DATE2) {
                return new TotalMatcher_ENUM<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, ((PartialMatcher)this).DOUBLE, DATE2);
            }

            public final TotalMatcher_ENUM<R> DATE_(R r) {
                return this.DATE(() -> r);
            }
        }

        public static final class TotalMatcher_DOUBLE<R>
        extends PartialMatcher_DATE<R> {
            TotalMatcher_DOUBLE(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, LONG2, null);
            }

            public final TotalMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE2) {
                return new TotalMatcher_DATE<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, ((PartialMatcher)this).LONG, DOUBLE2);
            }

            public final TotalMatcher_DATE<R> DOUBLE_(R r) {
                return this.DOUBLE(() -> r);
            }
        }

        public static final class TotalMatcher_LONG<R>
        extends PartialMatcher_DOUBLE<R> {
            TotalMatcher_LONG(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2) {
                super(TOP2, STRING2, BOOLEAN2, INTEGER2, null);
            }

            public final TotalMatcher_DOUBLE<R> LONG(Supplier<R> LONG2) {
                return new TotalMatcher_DOUBLE<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, ((PartialMatcher)this).INTEGER, LONG2);
            }

            public final TotalMatcher_DOUBLE<R> LONG_(R r) {
                return this.LONG(() -> r);
            }
        }

        public static final class TotalMatcher_INTEGER<R>
        extends PartialMatcher_LONG<R> {
            TotalMatcher_INTEGER(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2) {
                super(TOP2, STRING2, BOOLEAN2, null);
            }

            public final TotalMatcher_LONG<R> INTEGER(Supplier<R> INTEGER2) {
                return new TotalMatcher_LONG<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, ((PartialMatcher)this).BOOLEAN, INTEGER2);
            }

            public final TotalMatcher_LONG<R> INTEGER_(R r) {
                return this.INTEGER(() -> r);
            }
        }

        public static final class TotalMatcher_BOOLEAN<R>
        extends PartialMatcher_INTEGER<R> {
            TotalMatcher_BOOLEAN(Supplier<R> TOP2, Supplier<R> STRING2) {
                super(TOP2, STRING2, null);
            }

            public final TotalMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN2) {
                return new TotalMatcher_INTEGER<R>(((PartialMatcher)this).TOP, ((PartialMatcher)this).STRING, BOOLEAN2);
            }

            public final TotalMatcher_INTEGER<R> BOOLEAN_(R r) {
                return this.BOOLEAN(() -> r);
            }
        }

        public static final class TotalMatcher_STRING<R>
        extends PartialMatcher_BOOLEAN<R> {
            TotalMatcher_STRING(Supplier<R> TOP2) {
                super(TOP2, null);
            }

            public final TotalMatcher_BOOLEAN<R> STRING(Supplier<R> STRING2) {
                return new TotalMatcher_BOOLEAN<R>(((PartialMatcher)this).TOP, STRING2);
            }

            public final TotalMatcher_BOOLEAN<R> STRING_(R r) {
                return this.STRING(() -> r);
            }
        }

        public static final class TotalMatcher_TOP {
            TotalMatcher_TOP() {
            }

            public final <R> TotalMatcher_STRING<R> TOP(Supplier<R> TOP2) {
                return new TotalMatcher_STRING<R>(TOP2);
            }

            public final <R> TotalMatcher_STRING<R> TOP_(R r) {
                return this.TOP(() -> r);
            }

            public final <R> PartialMatcher_BOOLEAN<R> STRING(Supplier<R> STRING2) {
                return new PartialMatcher_BOOLEAN<R>(null, STRING2);
            }

            public final <R> PartialMatcher_BOOLEAN<R> STRING_(R r) {
                return this.STRING(() -> r);
            }

            public final <R> PartialMatcher_INTEGER<R> BOOLEAN(Supplier<R> BOOLEAN2) {
                return new PartialMatcher_INTEGER<R>(null, null, BOOLEAN2);
            }

            public final <R> PartialMatcher_INTEGER<R> BOOLEAN_(R r) {
                return this.BOOLEAN(() -> r);
            }

            public final <R> PartialMatcher_LONG<R> INTEGER(Supplier<R> INTEGER2) {
                return new PartialMatcher_LONG<R>(null, null, null, INTEGER2);
            }

            public final <R> PartialMatcher_LONG<R> INTEGER_(R r) {
                return this.INTEGER(() -> r);
            }

            public final <R> PartialMatcher_DOUBLE<R> LONG(Supplier<R> LONG2) {
                return new PartialMatcher_DOUBLE<R>(null, null, null, null, LONG2);
            }

            public final <R> PartialMatcher_DOUBLE<R> LONG_(R r) {
                return this.LONG(() -> r);
            }

            public final <R> PartialMatcher_DATE<R> DOUBLE(Supplier<R> DOUBLE2) {
                return new PartialMatcher_DATE<R>(null, null, null, null, null, DOUBLE2);
            }

            public final <R> PartialMatcher_DATE<R> DOUBLE_(R r) {
                return this.DOUBLE(() -> r);
            }

            public final <R> PartialMatcher_ENUM<R> DATE(Supplier<R> DATE2) {
                return new PartialMatcher_ENUM<R>(null, null, null, null, null, null, DATE2);
            }

            public final <R> PartialMatcher_ENUM<R> DATE_(R r) {
                return this.DATE(() -> r);
            }

            public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM(Function<String, R> ENUM2) {
                return new PartialMatcher_ITEMDEFINITION<R>(null, null, null, null, null, null, null, ENUM2);
            }

            public final <R> PartialMatcher_ITEMDEFINITION<R> ENUM_(R r) {
                return this.ENUM(className -> r);
            }

            public final <R> PartialMatcher<R> ITEMDEFINITION(Function<ItemDefinition, R> ITEMDEFINITION2) {
                return new PartialMatcher<R>(null, null, null, null, null, null, null, null, ITEMDEFINITION2);
            }

            public final <R> PartialMatcher<R> ITEMDEFINITION_(R r) {
                return this.ITEMDEFINITION(itemDefinition -> r);
            }
        }
    }

    private static final class Lazy
    extends ExpressionType {
        private volatile Supplier<ExpressionType> expression;
        private ExpressionType evaluation;

        Lazy(Supplier<ExpressionType> expressionType) {
            this.expression = expressionType;
        }

        private synchronized ExpressionType _evaluate() {
            block2: {
                ExpressionType eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<ExpressionType> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(cases);
        }

        @Override
        public boolean equals(Object obj) {
            return (this.expression == null ? this.evaluation : this._evaluate()).equals(obj);
        }

        @Override
        public int hashCode() {
            return (this.expression == null ? this.evaluation : this._evaluate()).hashCode();
        }

        @Override
        public String toString() {
            return (this.expression == null ? this.evaluation : this._evaluate()).toString();
        }
    }

    private static final class ITEMDEFINITION
    extends ExpressionType {
        private final ItemDefinition itemDefinition;

        ITEMDEFINITION(ItemDefinition itemDefinition) {
            this.itemDefinition = itemDefinition;
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.ITEMDEFINITION(this.itemDefinition);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> false, () -> false, () -> false, () -> false, () -> false, () -> false, className -> false, itemDefinition -> this.itemDefinition.equals(itemDefinition))) != false;
        }

        @Override
        public int hashCode() {
            return 59 + this.itemDefinition.hashCode();
        }

        @Override
        public String toString() {
            return "ITEMDEFINITION(" + this.itemDefinition + ")";
        }
    }

    private static final class ENUM
    extends ExpressionType {
        private final String className;

        ENUM(String className) {
            this.className = className;
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.ENUM(this.className);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> false, () -> false, () -> false, () -> false, () -> false, () -> false, className -> this.className.equals(className), itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 53 + this.className.hashCode();
        }

        @Override
        public String toString() {
            return "ENUM(" + this.className + ")";
        }
    }

    private static final class DATE
    extends ExpressionType {
        DATE() {
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.DATE();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> false, () -> false, () -> false, () -> false, () -> false, () -> true, className -> false, itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 47;
        }

        @Override
        public String toString() {
            return "DATE()";
        }
    }

    private static final class DOUBLE
    extends ExpressionType {
        DOUBLE() {
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.DOUBLE();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> false, () -> false, () -> false, () -> false, () -> true, () -> false, className -> false, itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 43;
        }

        @Override
        public String toString() {
            return "DOUBLE()";
        }
    }

    private static final class LONG
    extends ExpressionType {
        LONG() {
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.LONG();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> false, () -> false, () -> false, () -> true, () -> false, () -> false, className -> false, itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 41;
        }

        @Override
        public String toString() {
            return "LONG()";
        }
    }

    private static final class INTEGER
    extends ExpressionType {
        INTEGER() {
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.INTEGER();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> false, () -> false, () -> true, () -> false, () -> false, () -> false, className -> false, itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 37;
        }

        @Override
        public String toString() {
            return "INTEGER()";
        }
    }

    private static final class BOOLEAN
    extends ExpressionType {
        BOOLEAN() {
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.BOOLEAN();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> false, () -> true, () -> false, () -> false, () -> false, () -> false, className -> false, itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 31;
        }

        @Override
        public String toString() {
            return "BOOLEAN()";
        }
    }

    private static final class STRING
    extends ExpressionType {
        STRING() {
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.STRING();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> false, () -> true, () -> false, () -> false, () -> false, () -> false, () -> false, className -> false, itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 29;
        }

        @Override
        public String toString() {
            return "STRING()";
        }
    }

    private static final class TOP
    extends ExpressionType {
        TOP() {
        }

        @Override
        public <R> R match(ExpressionType.Cases<R> cases) {
            return cases.TOP();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExpressionType && ((ExpressionType)obj).match(ExpressionTypes.cases(() -> true, () -> false, () -> false, () -> false, () -> false, () -> false, () -> false, className -> false, itemDefinition -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 23;
        }

        @Override
        public String toString() {
            return "TOP()";
        }
    }

    private static final class LambdaCases<R>
    implements ExpressionType.Cases<R> {
        private final Supplier<R> TOP;
        private final Supplier<R> STRING;
        private final Supplier<R> BOOLEAN;
        private final Supplier<R> INTEGER;
        private final Supplier<R> LONG;
        private final Supplier<R> DOUBLE;
        private final Supplier<R> DATE;
        private final Function<String, R> ENUM;
        private final Function<ItemDefinition, R> ITEMDEFINITION;

        LambdaCases(Supplier<R> TOP2, Supplier<R> STRING2, Supplier<R> BOOLEAN2, Supplier<R> INTEGER2, Supplier<R> LONG2, Supplier<R> DOUBLE2, Supplier<R> DATE2, Function<String, R> ENUM2, Function<ItemDefinition, R> ITEMDEFINITION2) {
            this.TOP = TOP2;
            this.STRING = STRING2;
            this.BOOLEAN = BOOLEAN2;
            this.INTEGER = INTEGER2;
            this.LONG = LONG2;
            this.DOUBLE = DOUBLE2;
            this.DATE = DATE2;
            this.ENUM = ENUM2;
            this.ITEMDEFINITION = ITEMDEFINITION2;
        }

        @Override
        public R TOP() {
            return this.TOP.get();
        }

        @Override
        public R STRING() {
            return this.STRING.get();
        }

        @Override
        public R BOOLEAN() {
            return this.BOOLEAN.get();
        }

        @Override
        public R INTEGER() {
            return this.INTEGER.get();
        }

        @Override
        public R LONG() {
            return this.LONG.get();
        }

        @Override
        public R DOUBLE() {
            return this.DOUBLE.get();
        }

        @Override
        public R DATE() {
            return this.DATE.get();
        }

        @Override
        public R ENUM(String className) {
            return this.ENUM.apply(className);
        }

        @Override
        public R ITEMDEFINITION(ItemDefinition itemDefinition) {
            return this.ITEMDEFINITION.apply(itemDefinition);
        }
    }
}

