/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck;

import de.redsix.dmncheck.plugin.PluginBase;
import de.redsix.dmncheck.plugin.PrettyPrintValidationResults;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check-dmn", requiresProject=false, requiresDependencyResolution=ResolutionScope.TEST)
public class CheckerMain
extends AbstractMojo
implements PluginBase {
    @Parameter
    String[] excludes;
    @Parameter
    String[] searchPaths;
    @Parameter
    String[] validatorPackages;
    @Parameter
    String[] validatorClasses;
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="false", readonly=true)
    Boolean failOnWarning;
    @Parameter(defaultValue="${classpaths}")
    String[] classpath;

    public void execute() throws MojoExecutionException {
        this.loadClasspath();
        if (this.validate()) {
            throw new MojoExecutionException("Some files are not valid, see previous logs.");
        }
    }

    public PrettyPrintValidationResults.PluginLogger getPluginLogger() {
        return new PrettyPrintValidationResults.PluginLogger(arg_0 -> ((Log)this.getLog()).info(arg_0), arg_0 -> ((Log)this.getLog()).warn(arg_0), arg_0 -> ((Log)this.getLog()).error(arg_0));
    }

    public List<String> getExcludeList() {
        if (this.excludes != null) {
            return Arrays.asList(this.excludes);
        }
        return new ArrayList<String>();
    }

    public List<String> getSearchPathList() {
        if (this.searchPaths != null) {
            return Arrays.asList(this.searchPaths);
        }
        return Collections.singletonList("");
    }

    public String[] getValidatorPackages() {
        return this.validatorPackages;
    }

    public String[] getValidatorClasses() {
        return this.validatorClasses;
    }

    public boolean failOnWarning() {
        return this.failOnWarning;
    }

    void loadClasspath() throws MojoExecutionException {
        if (this.classpath != null && this.classpath.length != 0) {
            this.loadProjectClasspath(Arrays.asList(this.classpath));
        } else {
            this.loadProjectClasspath();
        }
    }

    void loadProjectClasspath() throws MojoExecutionException {
        List classpath = this.project.getArtifacts().stream().map(Artifact::getFile).map(File::getAbsolutePath).collect(Collectors.toList());
        this.loadProjectClasspath(classpath);
    }
}

