/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.result;

import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public final class PrettyPrintValidationResults {
    private PrettyPrintValidationResults() {
    }

    public static void logPrettified(File file, List<ValidationResult> validationResults, Log log) {
        log.info((CharSequence)("Validation results for file " + file.getAbsolutePath()));
        validationResults.sort(Comparator.comparing(ValidationResult::getSeverity).reversed());
        for (ValidationResult validationResult : validationResults) {
            String errorMessage = "Element '" + PrettyPrintValidationResults.delegate(validationResult.getElement()) + "' of type '" + validationResult.getElement().getElementType().getTypeName() + "' has the following validation result: " + validationResult.getMessage();
            PrettyPrintValidationResults.getLoggingMethod(validationResult.getSeverity(), log).accept(errorMessage);
        }
    }

    private static String delegate(ModelElementInstance element) {
        if (element instanceof Rule) {
            return PrettyPrintValidationResults.prettify((Rule)element);
        }
        return element.getRawTextContent().trim();
    }

    private static String prettify(Rule rule) {
        return Stream.concat(rule.getInputEntries().stream().map(ModelElementInstance::getTextContent), rule.getOutputEntries().stream().map(ModelElementInstance::getTextContent)).collect(Collectors.joining(","));
    }

    private static Consumer<CharSequence> getLoggingMethod(Severity severity, Log log) {
        if (severity == Severity.WARNING) {
            return arg_0 -> ((Log)log).warn(arg_0);
        }
        return arg_0 -> ((Log)log).error(arg_0);
    }
}

