/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck;

import de.redsix.dmncheck.result.PrettyPrintValidationResults;
import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.ProjectClassLoader;
import de.redsix.dmncheck.util.ValidatorLoader;
import de.redsix.dmncheck.validators.core.Validator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Mojo(name="check-dmn", requiresProject=false, requiresDependencyResolution=ResolutionScope.TEST)
class CheckerMain
extends AbstractMojo {
    @Parameter
    private String[] excludes;
    @Parameter
    private String[] searchPaths;
    @Parameter
    private String[] validatorPackages;
    @Parameter
    private String[] validatorClasses;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private @MonotonicNonNull List<Validator> validators;

    CheckerMain() {
    }

    public void execute() throws MojoExecutionException {
        this.loadProjectclasspath();
        List<Path> searchPathObjects = this.getSearchPathList().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        List<File> filesToTest = this.fetchFilesToTestFromSearchPaths(searchPathObjects);
        this.testFiles(filesToTest);
    }

    void testFiles(List<File> files) throws MojoExecutionException {
        boolean encounteredError = false;
        for (File file : files) {
            encounteredError |= this.testFile(file);
        }
        if (encounteredError) {
            throw new MojoExecutionException("Some files are not valid, see previous logs.");
        }
    }

    private boolean testFile(File file) {
        boolean encounteredError = false;
        try {
            DmnModelInstance dmnModelInstance = Dmn.readModelFromFile((File)file);
            List<ValidationResult> validationResults = this.runValidators(dmnModelInstance);
            if (!validationResults.isEmpty()) {
                PrettyPrintValidationResults.logPrettified(file, validationResults, this.getLog());
                encounteredError = validationResults.stream().anyMatch(result -> Severity.ERROR.equals((Object)result.getSeverity()));
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            encounteredError = true;
        }
        return encounteredError;
    }

    private List<ValidationResult> runValidators(DmnModelInstance dmnModelInstance) {
        return this.getValidators().stream().flatMap(validator -> validator.apply(dmnModelInstance).stream()).collect(Collectors.toList());
    }

    List<File> fetchFilesToTestFromSearchPaths(List<Path> searchPaths) {
        List<String> fileNames = this.getFileNames(".dmn", searchPaths);
        List files = fileNames.stream().map(File::new).collect(Collectors.toList());
        return files.stream().filter(file -> {
            if (this.getExcludeList().contains(file.getName())) {
                this.getLog().info((CharSequence)("Skipped File: " + file));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    List<String> getFileNames(String suffix, List<Path> dirs) {
        return dirs.stream().flatMap(dir -> {
            try {
                return Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.toAbsolutePath().toString()).filter(absolutePath -> absolutePath.endsWith(suffix));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not determine DMN files.", e);
            }
        }).collect(Collectors.toList());
    }

    private List<String> getExcludeList() {
        if (this.excludes != null) {
            return Arrays.asList(this.excludes);
        }
        return new ArrayList<String>();
    }

    private List<String> getSearchPathList() {
        if (this.searchPaths != null) {
            return Arrays.asList(this.searchPaths);
        }
        return Collections.singletonList("");
    }

    private List<Validator> getValidators() {
        if (this.validators != null) {
            return this.validators;
        }
        this.validators = ValidatorLoader.getValidators((String[])this.validatorPackages, (String[])this.validatorClasses);
        return this.validators;
    }

    private void loadProjectclasspath() throws MojoExecutionException {
        ArrayList<URL> listUrl = new ArrayList<URL>();
        Set deps = this.project.getArtifacts();
        for (Artifact artifact : deps) {
            try {
                URL url = artifact.getFile().toURI().toURL();
                listUrl.add(url);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Failed to construct project class loader.");
            }
        }
        ProjectClassLoader.instance.classLoader = new URLClassLoader(listUrl.toArray(new URL[0]));
    }

    void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    void setSearchPaths(String[] searchPaths) {
        this.searchPaths = searchPaths;
    }

    void setValidatorPackages(String[] validatorPackages) {
        this.validatorPackages = validatorPackages;
    }

    void setValidatorClasses(String[] validatorClasses) {
        this.validatorClasses = validatorClasses;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }
}

