/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testrail.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.testrail.entity.Attachments;
import de.qytera.qtaf.testrail.utils.APIClient;
import de.qytera.qtaf.testrail.utils.APIException;
import de.qytera.qtaf.testrail.utils.APIUtil;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.text.ParseException;
import lombok.Generated;

public class TestRailManager {
    public static void addResultForTestCase(APIClient client, String caseId, String runId, int status, String comment) throws APIException {
        JsonObject body = new JsonObject();
        body.add("status_id", (JsonElement)new JsonPrimitive((Number)status));
        body.add("comment", (JsonElement)new JsonPrimitive(comment));
        RequestBuilder request = WebService.buildRequest((URI)URI.create(client.getUrl() + "add_result_for_case/" + runId + "/" + caseId));
        request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
        try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.json((Object)body));){
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String content = (String)response.readEntity(String.class);
                throw new APIException(response.getStatus(), content);
            }
        }
    }

    public static void addAttachmentForTestCase(APIClient client, String testCaseId, String path) {
        try {
            APIUtil.consumeAttachment(path, entity -> {
                RequestBuilder request = WebService.buildRequest((URI)URI.create("%s/add_attachment_to_case/%s".formatted(client.getUrl(), testCaseId)));
                request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
                try (Response response = WebService.post((RequestBuilder)request, (Entity)entity);){
                    String responseData = (String)response.readEntity(String.class);
                    if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                        String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                        QtafFactory.getLogger().error(String.format("[QTAF TestRail Plugin] Failed to add attachment: %s", reason), new Object[0]);
                    }
                }
            });
        }
        catch (ParseException e) {
            QtafFactory.getLogger().error("[QTAF TestRail Plugin] Failed to read attachment: %s", new Object[]{path});
            QtafFactory.getLogger().error((Throwable)e, new Object[0]);
        }
    }

    public static void deleteAttachmentForTestCase(APIClient client, String attachmentId) throws APIException {
        RequestBuilder request = WebService.buildRequest((URI)URI.create(client.getUrl() + "delete_attachment/" + attachmentId));
        request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
        try (Response response = WebService.post((RequestBuilder)request);){
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String content = (String)response.readEntity(String.class);
                throw new APIException(response.getStatus(), content);
            }
        }
    }

    public static Attachments getAttachmentsForTestCase(APIClient client, String testCaseId) throws APIException {
        RequestBuilder request = WebService.buildRequest((URI)URI.create(client.getUrl() + "get_attachments_for_case/" + testCaseId));
        request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
        try (Response response = WebService.get((RequestBuilder)request);){
            String content = (String)response.readEntity(String.class);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new APIException(response.getStatus(), content);
            }
            Attachments attachments = (Attachments)GsonFactory.getInstance().fromJson(content, Attachments.class);
            return attachments;
        }
    }

    @Generated
    private TestRailManager() {
    }
}

