/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.testrail.utils;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;

public class APIClient {
    private String user;
    private String password;
    private String url;

    public APIClient(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Testrail Base URL is null, please set the value in your configuration file");
        }
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        this.url = (String)baseUrl + "index.php?/api/v2/";
    }

    public String getAuthorizationHeader() {
        return "Basic %s".formatted(new String(Base64.getEncoder().encode((this.user + ":" + this.password).getBytes(StandardCharsets.UTF_8))));
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIClient)) {
            return false;
        }
        APIClient other = (APIClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof APIClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "APIClient(user=" + this.getUser() + ", password=" + this.getPassword() + ", url=" + this.getUrl() + ")";
    }
}

