/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.apitesting.log.model.message;

import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.response.ExtractableResponse;
import io.restassured.specification.QueryableRequestSpecification;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class ApiLogMessage
extends LogMessage {
    Request request = new Request();
    Response response = new Response();

    public ApiLogMessage(LogLevel level, String message) {
        super(level, message);
    }

    public String buildMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("REQUEST:\n\n");
        if (this.getRequest().getRequestMethod() != null) {
            sb.append("Request Method: " + this.getRequest().getRequestMethod() + "\n");
        }
        if (this.getRequest().getBaseUri() != null) {
            sb.append("Base URI: " + this.getRequest().getBaseUri() + "\n");
        }
        if (this.getRequest().getBasePath() != null) {
            sb.append("Base Path: " + this.getRequest().getBasePath() + "\n");
        }
        if (this.getRequest().getContentType() != null) {
            sb.append("Content Type: " + this.getRequest().getContentType() + "\n");
        }
        if (this.getRequest().getHeaders() != null && this.getRequest().getHeaders().size() > 0) {
            sb.append("\nHeaders: \n");
            for (Header header : this.getRequest().getHeaders()) {
                sb.append("\t" + header.getName() + " = " + header.getValue() + "\n");
            }
        }
        if (this.getRequest().getPathParams() != null && this.getRequest().getPathParams().size() > 0) {
            sb.append("\nPath Params: \n");
            for (Map.Entry<String, String> pathParam : this.getRequest().getPathParams().entrySet()) {
                sb.append("\t" + pathParam.getKey() + " = " + pathParam.getValue() + "\n");
            }
        }
        if (this.getRequest().getQueryParams() != null && this.getRequest().getQueryParams().size() > 0) {
            sb.append("\nQuery Params: \n");
            for (Map.Entry<String, String> queryParam : this.getRequest().getQueryParams().entrySet()) {
                sb.append("\t" + queryParam.getKey() + " = " + queryParam.getValue() + "\n");
            }
        }
        if (this.getRequest().getFormParams() != null && this.getRequest().getFormParams().size() > 0) {
            sb.append("\nForm Params: \n");
            for (Map.Entry<String, String> formParam : this.getRequest().getFormParams().entrySet()) {
                sb.append("\t" + formParam.getKey() + " = " + formParam.getValue() + "\n");
            }
        }
        if (this.getRequest().getBodyAsString() != null) {
            sb.append("\nBody:\n");
            sb.append(this.getRequest().getBodyAsString());
        }
        sb.append("\n\nRESPONSE\n\n");
        sb.append("Status Code: " + this.getResponse().getStatusCode() + "\n");
        sb.append("Time: " + this.getResponse().getTime() + "\n");
        if (this.getResponse().getContentType() != null) {
            sb.append("Content Type: " + this.getResponse().getContentType() + "\n");
        }
        if (this.getResponse().getHeaders() != null && this.getResponse().getHeaders().size() > 0) {
            sb.append("\nHeaders: \n");
            for (Header header : this.getResponse().getHeaders()) {
                sb.append("\t" + header.getName() + " = " + header.getValue() + "\n");
            }
        }
        if (this.getResponse().getCookies() != null && this.getResponse().getCookies().size() > 0) {
            sb.append("\nCookies: \n");
            for (Map.Entry<String, String> cookie : this.getResponse().getCookies().entrySet()) {
                sb.append("\t" + cookie.getKey() + " = " + cookie.getValue() + "\n");
            }
        }
        if (this.getResponse().getBodyAsString() != null) {
            sb.append("\nBody:\n");
            sb.append(this.getResponse().getBodyAsString());
        }
        return sb.toString();
    }

    @Generated
    public Request getRequest() {
        return this.request;
    }

    @Generated
    public void setRequest(Request request) {
        this.request = request;
    }

    @Generated
    public Response getResponse() {
        return this.response;
    }

    @Generated
    public void setResponse(Response response) {
        this.response = response;
    }

    public static class Request {
        private String requestMethod;
        private String baseUri;
        private String basePath;
        private Map<String, String> pathParams;
        private Map<String, String> queryParams;
        private Map<String, String> formParams;
        private String bodyAsString;
        private String contentType;
        private Headers headers;

        public void setRequestAttributes(QueryableRequestSpecification request) {
            this.requestMethod = request.getMethod();
            this.baseUri = !Objects.equals(request.getBaseUri(), "") ? request.getBaseUri() : null;
            this.basePath = !Objects.equals(request.getBasePath(), "") ? request.getBasePath() : null;
            this.pathParams = !request.getPathParams().isEmpty() ? request.getPathParams() : null;
            this.queryParams = !request.getQueryParams().isEmpty() ? request.getQueryParams() : null;
            this.headers = request.getHeaders();
            this.contentType = request.getContentType();
            this.formParams = request.getFormParams();
            this.bodyAsString = request.getBody() != null ? request.getBody().toString() : null;
        }

        @Generated
        public Request() {
        }

        @Generated
        public void setRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
        }

        @Generated
        public void setBaseUri(String baseUri) {
            this.baseUri = baseUri;
        }

        @Generated
        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Generated
        public void setPathParams(Map<String, String> pathParams) {
            this.pathParams = pathParams;
        }

        @Generated
        public void setQueryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
        }

        @Generated
        public void setFormParams(Map<String, String> formParams) {
            this.formParams = formParams;
        }

        @Generated
        public void setBodyAsString(String bodyAsString) {
            this.bodyAsString = bodyAsString;
        }

        @Generated
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Generated
        public void setHeaders(Headers headers) {
            this.headers = headers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$requestMethod = this.getRequestMethod();
            String other$requestMethod = other.getRequestMethod();
            if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
                return false;
            }
            String this$baseUri = this.getBaseUri();
            String other$baseUri = other.getBaseUri();
            if (this$baseUri == null ? other$baseUri != null : !this$baseUri.equals(other$baseUri)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            Map<String, String> this$pathParams = this.getPathParams();
            Map<String, String> other$pathParams = other.getPathParams();
            if (this$pathParams == null ? other$pathParams != null : !((Object)this$pathParams).equals(other$pathParams)) {
                return false;
            }
            Map<String, String> this$queryParams = this.getQueryParams();
            Map<String, String> other$queryParams = other.getQueryParams();
            if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
                return false;
            }
            Map<String, String> this$formParams = this.getFormParams();
            Map<String, String> other$formParams = other.getFormParams();
            if (this$formParams == null ? other$formParams != null : !((Object)this$formParams).equals(other$formParams)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            Headers this$headers = this.getHeaders();
            Headers other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestMethod = this.getRequestMethod();
            result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
            String $baseUri = this.getBaseUri();
            result = result * 59 + ($baseUri == null ? 43 : $baseUri.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            Map<String, String> $pathParams = this.getPathParams();
            result = result * 59 + ($pathParams == null ? 43 : ((Object)$pathParams).hashCode());
            Map<String, String> $queryParams = this.getQueryParams();
            result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
            Map<String, String> $formParams = this.getFormParams();
            result = result * 59 + ($formParams == null ? 43 : ((Object)$formParams).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            Headers $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApiLogMessage.Request(requestMethod=" + this.getRequestMethod() + ", baseUri=" + this.getBaseUri() + ", basePath=" + this.getBasePath() + ", pathParams=" + this.getPathParams() + ", queryParams=" + this.getQueryParams() + ", formParams=" + this.getFormParams() + ", bodyAsString=" + this.getBodyAsString() + ", contentType=" + this.getContentType() + ", headers=" + this.getHeaders() + ")";
        }

        @Generated
        public String getRequestMethod() {
            return this.requestMethod;
        }

        @Generated
        public String getBaseUri() {
            return this.baseUri;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public Map<String, String> getPathParams() {
            return this.pathParams;
        }

        @Generated
        public Map<String, String> getQueryParams() {
            return this.queryParams;
        }

        @Generated
        public Map<String, String> getFormParams() {
            return this.formParams;
        }

        @Generated
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Generated
        public Headers getHeaders() {
            return this.headers;
        }
    }

    public static class Response {
        private int statusCode;
        private Headers headers;
        private String contentType;
        private Map<String, String> cookies;
        private String bodyAsString;
        private long time;

        public void setResponseAttributes(ExtractableResponse<io.restassured.response.Response> response) {
            this.statusCode = response.statusCode();
            this.headers = response.headers();
            this.cookies = response.cookies();
            this.contentType = response.contentType();
            this.time = response.time();
            this.bodyAsString = response.body().asString();
        }

        @Generated
        public Response() {
        }

        @Generated
        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        @Generated
        public void setHeaders(Headers headers) {
            this.headers = headers;
        }

        @Generated
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Generated
        public void setCookies(Map<String, String> cookies) {
            this.cookies = cookies;
        }

        @Generated
        public void setBodyAsString(String bodyAsString) {
            this.bodyAsString = bodyAsString;
        }

        @Generated
        public void setTime(long time) {
            this.time = time;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatusCode() != other.getStatusCode()) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            Headers this$headers = this.getHeaders();
            Headers other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            Map<String, String> this$cookies = this.getCookies();
            Map<String, String> other$cookies = other.getCookies();
            if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            return !(this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatusCode();
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            Headers $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            Map<String, String> $cookies = this.getCookies();
            result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApiLogMessage.Response(statusCode=" + this.getStatusCode() + ", headers=" + this.getHeaders() + ", contentType=" + this.getContentType() + ", cookies=" + this.getCookies() + ", bodyAsString=" + this.getBodyAsString() + ", time=" + this.getTime() + ")";
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public Headers getHeaders() {
            return this.headers;
        }

        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Generated
        public Map<String, String> getCookies() {
            return this.cookies;
        }

        @Generated
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @Generated
        public long getTime() {
            return this.time;
        }
    }
}

