/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.apitesting.interceptors;

import de.qytera.qtaf.apitesting.log.model.message.ApiLogMessage;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.guice.annotations.Step;
import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.SpecificationQuerier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.testng.internal.collections.Pair;

public class RestCallMethodInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (methodInvocation.getThis() instanceof IQtafTestContext && methodInvocation.getMethod().getReturnType().getName().contains("io.restassured")) {
            Object result;
            QtafFactory.getLogger().debug(String.format("Intercept @Step method: name=%s", methodInvocation.getMethod().getName()), new Object[0]);
            Step stepAnnotation = methodInvocation.getMethod().getAnnotation(Step.class);
            TestScenarioLogCollection scenarioLogCollection = ((IQtafTestContext)methodInvocation.getThis()).getLogCollection();
            ApiLogMessage apiLogMessage = new ApiLogMessage(LogLevel.INFO, stepAnnotation.name());
            for (Object arg : methodInvocation.getArguments()) {
                if (arg instanceof RequestSpecification) {
                    RequestSpecification request = (RequestSpecification)arg;
                    apiLogMessage.getRequest().setRequestAttributes(SpecificationQuerier.query((RequestSpecification)request));
                    continue;
                }
                if (!(arg instanceof ValidatableResponse)) continue;
                ValidatableResponse response = (ValidatableResponse)arg;
                apiLogMessage.getResponse().setResponseAttributes((ExtractableResponse<Response>)response.extract());
            }
            try {
                Pair pair;
                Object object;
                result = methodInvocation.proceed();
                if (result instanceof RequestSpecification) {
                    RequestSpecification request = (RequestSpecification)result;
                    apiLogMessage.getRequest().setRequestAttributes(SpecificationQuerier.query((RequestSpecification)request));
                } else if (result instanceof ValidatableResponse) {
                    ValidatableResponse response = (ValidatableResponse)result;
                    apiLogMessage.getResponse().setResponseAttributes((ExtractableResponse<Response>)response.extract());
                } else if (result instanceof Pair && (object = (pair = (Pair)result).first()) instanceof RequestSpecification) {
                    RequestSpecification request = (RequestSpecification)object;
                    object = pair.second();
                    if (object instanceof ValidatableResponse) {
                        ValidatableResponse response = (ValidatableResponse)object;
                        apiLogMessage.getRequest().setRequestAttributes(SpecificationQuerier.query((RequestSpecification)request));
                        apiLogMessage.getResponse().setResponseAttributes((ExtractableResponse<Response>)response.extract());
                    }
                }
                StepInformationLogMessage stepInformationLogMessage = new StepInformationLogMessage(methodInvocation.getMethod().getName(), apiLogMessage.buildMessage());
                stepInformationLogMessage.setStep(stepAnnotation);
                stepInformationLogMessage.setStatus(LogMessage.Status.PASSED);
                stepInformationLogMessage.setResult((Object)apiLogMessage.buildMessage());
                scenarioLogCollection.addLogMessage((LogMessage)stepInformationLogMessage);
            }
            catch (Throwable e) {
                apiLogMessage.setError(e);
                StepInformationLogMessage stepInformationLogMessage = new StepInformationLogMessage(methodInvocation.getMethod().getName(), apiLogMessage.buildMessage());
                stepInformationLogMessage.setStep(stepAnnotation);
                stepInformationLogMessage.setStatus(LogMessage.Status.FAILED);
                stepInformationLogMessage.setResult((Object)apiLogMessage.buildMessage());
                throw e;
            }
            return result;
        }
        return methodInvocation.proceed();
    }
}

