/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.io;

import java.io.File;
import java.io.IOException;

public class DirectoryHelper {
    public static final String fs = System.getProperty("file.separator");

    public static String preparePath(String path) {
        return path.replace("$USER_DIR", System.getProperty("user.dir")).replace("$USER_HOME", System.getProperty("user.home")).replace("$USER_NAME", System.getProperty("user.name")).replace("/", fs).replace("\\", fs);
    }

    public static boolean createDirectoryIfNotExists(String dir) throws IOException {
        dir = DirectoryHelper.preparePath(dir);
        File file = new File(dir);
        return file.mkdirs();
    }

    public static boolean deleteDirectory(String dir) {
        return DirectoryHelper.deleteDirectory(new File(DirectoryHelper.preparePath(dir)));
    }

    public static boolean deleteDirectory(File dir) {
        File[] allContents = dir.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                DirectoryHelper.deleteDirectory(file);
            }
        }
        return dir.delete();
    }
}

