/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.io;

import de.qytera.qtaf.core.io.DirectoryHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileHelper {
    public static boolean exists(String filePath) {
        filePath = DirectoryHelper.preparePath(filePath);
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean touch(String filePath) {
        filePath = DirectoryHelper.preparePath(filePath);
        File file = new File(filePath);
        return file.getParentFile().mkdirs();
    }

    public static boolean createFileIfNotExists(String filePath, String fileContent) throws IOException {
        filePath = DirectoryHelper.preparePath(filePath);
        File file = new File(filePath);
        boolean mkdirsSuccess = FileHelper.touch(filePath);
        if (mkdirsSuccess && !file.exists()) {
            boolean fileCreated = file.createNewFile();
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(fileContent);
            bw.close();
            return fileCreated;
        }
        return true;
    }

    public static byte[] getFileContent(String filepath) throws IOException {
        return Files.readAllBytes(Paths.get(DirectoryHelper.preparePath(filepath), new String[0]));
    }

    public static String getFileContentAsUTF8String(String filepath) throws IOException {
        return new String(FileHelper.getFileContent(filepath), StandardCharsets.UTF_8);
    }

    public static void writeFile(String filePath, String content) throws IOException {
        filePath = DirectoryHelper.preparePath(filePath);
        Files.write(Path.of(filePath, new String[0]), content.getBytes(), new OpenOption[0]);
    }

    public static boolean delete(String filePath) {
        filePath = DirectoryHelper.preparePath(filePath);
        File file = new File(filePath);
        return file.delete();
    }
}

